(* ::Package:: *)

(******************************************************************************
*                                                                             *
* Add-on for automatized Mellin-Barnes techniques                             *
*                                                                             *
* Johann Usovitsch                                                            *
*                                                                             *
******************************************************************************)


Print["ResidueLook"];
Print["by Johann Usovitsch"];

BeginPackage["RL`"]
$MaxExtraPrecision=500;
Clear[LimitRules];

RLstart::usage = "Start MBnumerics: RLstart[MBintegrals_,kinRule_,kinRuleEucl_,options___Rule]";
RLtestRad::usage = "";
RLtest0::usage = "";
RLintegrate::usage = "";
RLmove::usage="";
RLfindRes::usage="";
RLcalcRes::usage="";
RLsearchShift::usage="";
RLdo::usage="";
RLshift::usage="";
RLasymptotics::usage="";
RLcheckRotation::usage="";
RLLimitRules::usage="";
RLgeneratePermutations::usage="";
RLgenerateSeed::usage="";
RLgetLimit::usage="";
RLtakeLimit::usage="";
RLtestT2Limit::usage="";
RLnewFunc::usage="";
RLorderAsymptotics::usage="";


Options[RLintegrate] = {
    text-> "",
	Complex-> True,
	Verbose-> 0,
	Debug-> False,
	PrecisionGoal-> Infinity,
	AccuracyGoal-> 6,
	MB`FixedContours-> False,
	MaxPoints-> 1,
	MB`MaxCuhreDim->4,
    RLlogarithm-> 0,
	rad->False,
  WorkingPrecision->20,
  checkRot->0,
  grid->0
};


(*From MB.m and modified!!!!**************************************************************)
ParseOptions[f_, options___Rule] :=
	Block[{pos},
		If[Length[pos = Position[{options}, First[#] -> _, 1, 1] ] === 0, #,
		{options}[[ Sequence @@ First[pos]]]] & /@ Options[f]
	]
RLdefineMAP[num_]=
Switch[num,
 -1,
  MB`MBmap[zt_,xt_,rt_]:=zt-(rt+I)/TAN[-Pi*(0.01+0.98*xt)];
  MB`MBnorm[xt_,rt_]:=((rt+I)/I*Pi/SIN[Pi*(0.01+0.98*xt)]^2)*0.98;
  RLmap1[xt_] := 1/TAN[-Pi(1/2+1/2*xt)];
  RLmap2[zt_, xt_] := zt -I*r*SIN[xt*2*Pi];
  RLmap3[zt_, xt_] := zt -I*r*COS[xt*2*Pi];
  RLnorm[xt_] := (1/2)(2*Pi)/TAN[-Pi*(1/2+1/2*xt)]*Pi/SIN[Pi*(1/2+1/2*xt)]^2;
,
	0,
	MB`MBmap[zt_,xt_,rt_]:=zt-(rt+I)/TAN[-Pi*xt];
	MB`MBnorm[xt_,rt_]:=(rt+I)/I*Pi/SIN[Pi*xt]^2;
	RLmap1[xt_] := 1/TAN[-Pi(1/2+1/2*xt)];
	RLmap2[zt_, xt_] := zt -I*r*SIN[xt*2*Pi];
	RLmap3[zt_, xt_] := zt -I*r*COS[xt*2*Pi];
	RLnorm[xt_] := (1/2)(2*Pi)/TAN[-Pi*(1/2+1/2*xt)]*Pi/SIN[Pi*(1/2+1/2*xt)]^2;
,
	1,
	MB`MBmap[zt_, xt_,rt_] := zt - (rt+I)*Log[xt/(1 - xt)];
	MB`MBnorm[xt_,rt_] := (rt+I)/I/(xt*(1 - xt));
,
	2,
	MB`MBmap[zt_,xt_,rt_]:=zt-(-I Cot[\[Pi] xt]+rt Cot[\[Pi] xt]^2);
	MB`MBnorm[xt_,rt_]:=(1+2 I rt Cot[\[Pi] xt])*Pi/SIN[Pi*xt]^2;
]


Options[MB`MBintegrate] = {
  MB`NamePrefix -> "MB",
  PrecisionGoal -> Infinity,
  AccuracyGoal -> 6,
  MaxPoints -> 1000000,
  MaxRecursion -> 1000,
  Method -> MB`DoubleExponential,
  WorkingPrecision -> $MachinePrecision,
  MB`MaxNIntegrateDim -> 1,
  MB`MaxCuhreDim -> 4,
  MB`PseudoRandom -> False,
  Complex -> False,
  MB`FixedContours -> False,
  MB`NoHigherDimensional -> False,
  Debug -> False,
  MB`ContourDebug -> False,
  Verbose -> True,
  rad -> False,
  checkRot->0
};

MB`MBintegrate[integrals_List, kinematics_List, options___Rule] :=
Block[{opt = ParseOptions[MB`MBintegrate, options], greater, tolist,
  ints, intvars, allvars, xt, expr, ncomp, flags,
  ints1, sum, pow, rules, ndim, integrand, gams, syms, name, exec, source,
  strm, val, result, error, i, j, NINT,
pgams, psyms, a, b, c, dt, rule2, ruleRL, todo, todo3, RL0, RL1, RL2, RL3, 
RL4, RL5, RL6,RL7,RL8,RL9,dd, MBint1, MBint2,W,checkRot,rotateT},
(*Print[integrals];*)
rotateT=checkRot/.opt;
ints = integrals /. kinematics;
  greater[MBint1_, MBint2_] := Block[{e1, e2, n1, n2},
    e1 = Exponent[MBint1, xt];
    e2 = Exponent[MBint2, xt];
    If[e1 != e2, Return[e1 > e2]];
    n1 = MBint1 /. (_.)*MB`MBint[_, {_, r_}] :> Length[r];
    n2 = MBint2 /. (_.)*MB`MBint[_, {_, r_}] :> Length[r]; 
    Return[n1 > n2]];

  tolist[expr_] := If[Head[expr] === Plus, List @@ expr, {expr}];
          
  intvars = Union[Flatten[Cases[ints, MB`MBint[_, {_, rules_}] :>
    (First[#] & /@ rules), -1]]];

  
  allvars = Union[Flatten[ints /. MB`MBint[integrand_, _] :>
    Cases[N[integrand], _Symbol, -1]]];

  
  xt = Complement[allvars, intvars];

  If[Length[xt] == 0, xt = {""}];
  If[Length[xt] > 1, Message[MB`MBintegrate::vars, xt]; Return[{}], xt = First[xt]];

  ints = Sort[Flatten[ints /. MB`MBint[integrand_, rules_] :>
    tolist[Collect[integrand, xt, MB`MBint[#1, rules] & ]]], greater];

  If[Complex /. opt, ncomp = 2, ncomp = 1];

  If[MB`PseudoRandom /. opt, flags = 8, flags = 0];

  If[!MB`FixedContours /. opt,
    If[Verbose /. opt, Print["Shifting contours..."]];
    ints = ints /. MB`MBint[args__] :> First[MB`MBshiftContours[{MB`MBint[args]},
      Verbose -> (MB`ContourDebug /. opt)]]];
  sum = Plus @@ Cases[ints, _.*MB`MBint[_, {_, {}}]] /. MB`MBint[i_, _] -> i;
  If[sum =!= 0, If[(PrecisionGoal /. opt) <= $MachinePrecision,
    sum = N[sum], sum = N[sum, PrecisionGoal /. opt]]];

  ints1 = Cases[ints, _.*i_MB`MBint /;
    0 < Length[i[[2,2]]] <= (MB`MaxNIntegrateDim /. opt)];
  ints = Cases[ints, _.*i_MB`MBint /;
    (MB`MaxNIntegrateDim /. opt) < Length[i[[2,2]]]];

  If[!Complex /. opt,
    ints1 = ints1 /. MB`MBint[integrand_, rules_] :> MB`MBint[Re[integrand], rules]];

  If[Verbose /. opt, WriteString[$Output, "Performing ", Length[ints1],
    " lower-dimensional integrations with NIntegrate"]];
  
  Do[
    If[Verbose /. opt, WriteString[$Output, "...", i]];
    sum += ints1[[i]] /. MB`MBint[integrand_, {_, rules_}] :>
      NINT[(I+2rotateT*MBx[1])/(2*I*Pi)^Length[rules]*integrand /. 
        Table[rules[[j,1]] -> rules[[j,2]]+I*MBx[j]+rotateT*MBx[j]^2, {j, Length[rules]}],

        Sequence @@ Table[{MBx[j], -Infinity, Infinity}, {j, Length[rules]}],
        PrecisionGoal -> (PrecisionGoal /.opt),
        AccuracyGoal -> (AccuracyGoal /. opt),
        MaxPoints -> (MaxPoints /. opt),
        MaxRecursion -> (MaxRecursion /. opt),
        Method -> (Method /. opt),
        WorkingPrecision -> (WorkingPrecision /. opt)] /.
      NINT[args__] :> NIntegrate[args],
  {i, Length[ints1]}];

  If[!Complex /. opt, sum = Collect[sum, xt, Re]];

  If[Verbose /. opt, Print["Higher-dimensional integrals"]];

  Do[
    pow = Exponent[ints[[i]], xt];
    rules = ints[[i]] /. _.*MB`MBint[_, {_, r_}] -> r;
    ndim = Length[rules];
    integrand = ints[[i]] /. _.*MB`MBint[j_, _] -> j;
    gams = Union[Cases[integrand, (Gamma)[__], -1]];
    syms = Table[ToExpression["MBg["<>ToString[j]<>"]"], {j, Length[gams]}];
    Do[integrand = integrand /. gams[[j]] -> syms[[j]], {j, Length[gams]}];    
    pgams = Union[Cases[integrand, (PolyGamma)[__], -1]];
    psyms = Table[ToExpression["MBg2["<>ToString[j]<>"]"], {j, Length[pgams]}];
    Do[integrand = integrand /. pgams[[j]] -> psyms[[j]], {j, Length[pgams]}];
    name = StringJoin[MB`NamePrefix /. opt, "part", ToString[i]];
    exec = StringJoin[name, ToString[xt], ToString[pow]];
    source = StringJoin[exec, ".f"];
    strm = OpenWrite[source];

    If[Verbose /. opt, Print["Preparing ", exec, " (dim ", ndim, ")"]];

    WriteString[strm,
      "      implicit none\n\n",

      "      external integrand\n",
      "      integer ndim, ncomp, flags, mineval, maxeval, nvec\n",
      "      character*(*) statefile\n",
      "      integer*8 spin\n",
      "      integer key, nstart, nincrease, seed, nbatch, gridno\n",
      "      double precision epsrel, epsabs, userdata\n\n",

      "      parameter (ndim=", ndim, ", ncomp=", ncomp, ", flags=", flags, ",\n",
      "     & mineval=0, maxeval=", FortranForm[MaxPoints /. opt], ", gridno=1,\n",
      "     & key=0, nstart=1000, nincrease=1000, seed=0, nbatch=1000,\n",
      "     & epsrel=", FortranForm[10^(-PrecisionGoal) /. opt], ",\n",
      "     & epsabs=", FortranForm[10^(-AccuracyGoal) /. opt], ",\n",
      "     & userdata=0, nvec=1, statefile=\"\", spin=-1)\n\n",

      "      integer nregions, neval, fail\n",
      "      double precision integral(ncomp), error(ncomp), prob(ncomp)\n\n",

      "      if (ndim.gt.", MB`MaxCuhreDim /. opt, ") then\n",
      "        call vegas(ndim, ncomp, integrand, userdata, nvec,\n",
      "     &   epsrel, epsabs, flags, seed, mineval, maxeval,\n",
      "     &   nstart, nincrease, nbatch, gridno, statefile, spin,\n",
      "     &   neval, fail, integral, error, prob)\n",
      "      else\n",
      "        call cuhre(ndim, ncomp, integrand, userdata, nvec, epsrel,\n",
      "     &   epsabs, flags, mineval, maxeval, key, statefile, spin,\n",
      "     &   nregions, neval, fail, integral, error, prob)\n",
      "      endif\n\n",

      "      write (*,*) integral(1), error(1), prob(1)\n",
      "      if (ncomp.eq.2) then\n",
      "        write (*,*) integral(ncomp), error(ncomp), prob(ncomp)\n",
      "      endif\n\n",

      "      end\n\n"];

    WriteString[strm,
      "      subroutine integrand(ndim, MBx, ncomp, MBf)\n\n",

      "      integer ndim, ncomp\n",
      "      double precision MBx(ndim), MBf(ncomp), Pi, EulerGamma\n",
      "      double complex MBval, wlgama, wgamma, wpsipg\n\n"];
    Do[WriteString[strm,
      "      double complex ", rules[[j,1]], "\n"], {j, ndim}];
      
    WriteString[strm,
      "      double complex ","MBg("<>ToString[Length[gams]]<>")\n"];

    WriteString[strm,
      "      double complex ","MBg2("<>ToString[Length[pgams]]<>")\n"];

    WriteString[strm,
      "      Pi = 3.1415926535897932384626433832795D0\n",
      "      EulerGamma = 0.5772156649015328606065120900824024D0\n\n"];
    WriteString[strm, "\n"];

	  If[rad/.opt
    ,
		  MB`MBfortranForm[strm, r,
	  		RLmap1[ToExpression[StringJoin["MBx[","1", "]"]]]
		  ];
		  MB`MBfortranForm[strm, rules[[1,1]],
		  	RLmap2[rules[[1,2]], ToExpression[StringJoin["MBx[","2", "]"]]]
  		];
  		MB`MBfortranForm[strm, rules[[2,1]],
  			RLmap3[rules[[2,2]], ToExpression[StringJoin["MBx[","2", "]"]]]
  		];
  	,
  	    Do[
  			MB`MBfortranForm[strm, rules[[j,1]],
  				MB`MBmap[rules[[j,2]], ToExpression[StringJoin["MBx[", ToString[j], "]"]],rotateT]
  			],
  	    {j, ndim}];
  	];

    WriteString[strm, "\n"];
    Do[MB`MBfortranForm[strm, ToString["MBg("<>ToString[j]<>")"],
      N[gams[[j]]] /. {Gamma[zt_] -> wlgama[zt],PolyGamma[n_,zt_] :>
        wpsipg[zt,Rationalize[n,0]]}],
    {j, Length[syms]}];
    WriteString[strm, "\n"];

    WriteString[strm, "\n"];    
    Do[MB`MBfortranForm[strm, ToString["MBg2("<>ToString[j]<>")"],
      N[pgams[[j]]] /. {Gamma[zt_] -> wlgama[zt],PolyGamma[n_,zt_] :>
        wpsipg[zt,Rationalize[n,0]]}],
    {j, Length[psyms]}];
    WriteString[strm, "\n"];
    
    Clear[FUNC];
    Clear[EXP];
    (*Print[integrand];*)
  	(*rule2=
    {
  	  a__^(c___-b_) (* /; NumberQ[a]*) /; Re[a] < 0 -> EXP[(*I \[Pi] (c-b)*) + (LOG[Abs[a]]+I*ATAN2[Im[a],Re[a]])(c-b)],
  	  a__^(c___+b_) (* /; NumberQ[a]*) /; Re[a] < 0 -> EXP[(*I \[Pi] (c+b)*) + (LOG[Abs[a]]+I*ATAN2[Im[a],Re[a]])(c+b)],
  	  a__^-b_       (* /; NumberQ[a]*) /; Re[a] < 0 -> EXP[(*I \[Pi] (-b) *) + (LOG[Abs[a]]+I*ATAN2[Im[a],Re[a]])(-b)],
  	  a__^+b_       (* /; NumberQ[a]*) /; Re[a] < 0 -> EXP[(*I \[Pi] b    *) + (LOG[Abs[a]]+I*ATAN2[Im[a],Re[a]])(b)] 
    };*)
    rule2=
    {
      a__^(c___-b_) /; NumberQ[a] -> EXP[(*I \[Pi] (c-b)*) + (LOG[Abs[a]]+I*ArcTan[Re[a],Im[a]](*ATAN2[Im[a],Re[a]]*))(c-b)],
      a__^(c___+b_) /; NumberQ[a] -> EXP[(*I \[Pi] (c+b)*) + (LOG[Abs[a]]+I*ArcTan[Re[a],Im[a]](*ATAN2[Im[a],Re[a]]*))(c+b)],
      a__^-b_       /; NumberQ[a] -> EXP[(*I \[Pi] (-b) *) + (LOG[Abs[a]]+I*ArcTan[Re[a],Im[a]](*ATAN2[Im[a],Re[a]]*))(-b)],
      a__^+b_       /; NumberQ[a] -> EXP[(*I \[Pi] b    *) + (LOG[Abs[a]]+I*ArcTan[Re[a],Im[a]](*ATAN2[Im[a],Re[a]]*))(b)] 
    };

  	RLm1=FUNC[a_+b_] -> (FUNC[a]+FUNC[b]);
    RL0=FUNC[c__(a__MBg*dd__ + b_Plus)] -> (FUNC[c*a*dd]+FUNC[c*b]);
  	RL1=FUNC[c__(a__MBg*dd__ + b_)] -> (FUNC[c*a*dd]+FUNC[c*b]);
    RL2=FUNC[EXP[a_]*b_] -> EXP[a]*FUNC[b];
  	RL3=FUNC[b_/(a_MBg)] -> FUNC[b]*EXP[-a];
  	RL4=FUNC[1/(a_MBg)] -> EXP[-a];
    RL5=FUNC[a_MBg*b_] -> EXP[a]*FUNC[b];
    RL6=FUNC[a_MBg] -> EXP[a];
    RL7=FUNC[a_MBg^c_*b_] -> EXP[c*a]*FUNC[b];
    RL8=FUNC[a_MBg^c_] -> EXP[c*a];
    RL9=EXP[a_]*EXP[b_] -> EXP[a+b];
	  
    ruleRL=Dispatch[{RLm1,RL0,RL1,RL2,RL3,RL4,RL5,RL6,RL7,RL8,RL9}];
    SetAttributes[MBg,NHoldFirst];
    SetAttributes[MBg2,NHoldFirst];
    SetAttributes[MBx,NHoldFirst];
    todo=FUNC[integrand /.rule2];
    todo=todo//.ruleRL;
    (*Print[todo];*)
    todo=todo/.FUNC[a_]/;NumeriQ[a]->EXP[LOG[Abs[a]]+I*ArcTan[Re[a],Im[a]]];(*ONLY for 100*)
    todo=todo/.EXP[a_]*EXP[b_] -> EXP[a+b];(*ONLY for 100*)
    (*Print[todo];*)
    todo=todo/.FUNC[a__]->a/.LOG[a_]->Log[a];(*ONLY for 100*)
    (*Print[todo];*)
    (*
     token=Product[MB`MBnorm[ToExpression[StringJoin["MBx[", ToString[j], "]"]],rotateT],
        {j, ndim}] /.a_->EXP[LOG[a]];
     todo=todo*token /.EXP[a_]*EXP[b_]c_->EXP[a+b]*c /.EXP[a_]*EXP[b_]->EXP[a+b];
    *)

    (*Print[todo];*)
    todo3=Plus @@ (1/(2*Pi)^ndim*(#) & /@ ({todo}//Flatten));
    (*Print[N[todo3]];*)
    MB`MBfortranForm[strm, MB`MBval, N[todo3]];
    WriteString[strm, "\n"];
   

    
    WriteString[strm, "\n"];
    If[rad/.opt,
  		MB`MBfortranForm[strm, MB`MBval, MB`MBval*
  			RLnorm[ToExpression[StringJoin["MBx[","1", "]"]]]
  		];
  		,
  		MB`MBfortranForm[strm, MB`MBval, 

        MB`MBval*
  			Product[MB`MBnorm[ToExpression[StringJoin["MBx[", ToString[j], "]"]],rotateT],
  			{j, ndim}]
   		];
	  ];
    WriteString[strm, "\n"];
    

    WriteString[strm,
      "      MBf(1) = dreal(MBval)\n",
      "      if (ncomp.eq.2) MBf(ncomp) = dimag(MBval)\n\n",

      "      end\n"];

    Close[strm];
    Run["gfortran -O -o", exec, source, "-L. -lmathlib -lkernlib -lcuba4"],
  {i, Length[ints]}];

  If[MB`NoHigherDimensional /. opt,
    If[Verbose /. opt,
      Print["The result does not contain higher dimensional integrals"]];
    Return[sum]];

  Do[
    pow = Exponent[ints[[i]], xt];
    name = StringJoin[MB`NamePrefix /. opt, "part", ToString[i]];
    exec = StringJoin[name, ToString[xt], ToString[pow]];
  
    If[Verbose /. opt, Print["Running ", exec]];

    val = Import[StringJoin["! ./", exec], "Table"];
    val = If[ncomp == 1, Flatten[val], Table[val[[1,j]]+I*val[[2,j]], {j,3}]];
    sum += xt^pow*MB`MBval[Sequence @@ val, i];

    If[!Debug /. opt,
      DeleteFile[StringJoin[name, ToString[xt], ToString[pow], ".f"]];
      DeleteFile[exec]],
  {i, Length[ints]}];

  result = sum /. MB`MBval[i_, __] -> i;
  error = Collect[sum, xt, 
    Sqrt[Plus @@ Cases[tolist[#], MB`MBval[_, i_, __] :> {Re[i]^2, Im[i]^2}]] &];

  If[Debug /. opt,
    Return[{result,error,sum}],
    Return[{result,error}]]]
(*************************************************************************)


RLLimitRules = 
  {Gamma[num_+Complex[0,cf_]*tVar]->Exp[-tVar Abs[cf] Pi/2] tVar^(num-1/2)};

Begin["`Private`"]

RLchangeRule[rule : (sym234_ -> _)] := 
	Append[FilterRules[#, Except[sym234]], rule] &;

RLcombine[int_,numer_]:=Block[
	{listNumerf,listNumert,intf,numert,intp,check},
listNumerf=DeleteCases[DeleteDuplicates[If[Depth[#]==1,#]&/@numer],Null];
listNumert=DeleteCases[Range[numer//Length],Alternatives@@listNumerf];
If[(listNumerf//Length)!=0,intf=(int)[[listNumerf]]//Flatten,intf={}];
numert=(numer)[[listNumert]];
check={Plus@@(numert[[#,1]]&/@Range[Length[numert]]),Sqrt[Plus@@(numert[[#,2]]^2&/@Range[Length[numert]])]};
intp=(int)[[listNumert]]//Flatten;
WriteString["stdout","Failed: ",(intf//Length),"; ","Result: ",ToString[check, FortranForm],"\n"];
Return[{intf,numert,intp,check}]
];

RLfindRes[MBintegral_,rulemove_,kinRule_]:=Block[
	{int2deal,int2red,polesMZ,polesM,poles,residue,toIntegrate,arg1,arg2,arg3,arg4,arg,orderedrules,
	argument,argumentK,xmin,xmax,newrule,eps234,MZ,c,count,tkn234,trminate,list1,coef,m,
  orderedrulesLIST,list2,i,zs,qq,qqList,argument55,termin,success},

	count=0;
  success = 0;
	Do[
		If[rulemove[[i,2]]==0,count++;];
	,{i,Length[rulemove]}];
	If[count==Length[rulemove],Return[{0,0}]];


  orderedrulesLIST=Permutations[rulemove];

	(*orderedrules=rulemove[[ Ordering[Abs[rulemove[[All,2]]]] ]];(*CARE*)*)
  WriteString["stdout","Residuems to calculate: "];
  Do[
    orderedrules=orderedrulesLIST[[iteRules]];

    WriteString["stdout","\ntry: ",orderedrules];
    list1={MBintegral}/. {Gamma[a_] :> Gamma[Expand[a]],
      PolyGamma[a_, b_] :> PolyGamma[a, Expand[b]]};
  	list2=MBintegral/. {Gamma[a_] :> Gamma[Expand[a]], 
      PolyGamma[a_, b_] :> PolyGamma[a, Expand[b]]};

  	Do[
  		list2=RLmove[list2,{orderedrules[[i]]}]//Flatten;
  		list1 = Join[list1,{list2}];,
  	{i,1,Length[rulemove]-1}];
    (*Print[orderedrules];*)

  	
  	(*count=1;*)
  	toIntegrate=Table[
  	(
  		int2deal = # /. MB`MBint[arg1_, _] -> arg1;
      listO = If[ Head[int2deal] =!= Power && Head[int2deal] =!= Times, {int2deal}, List @@ int2deal];
      int2deal1 = DeleteCases[((If[Head[#] === Plus, #]) & /@ listO), Null];
      int2deal2 = DeleteCases[((If[Head[#] =!= Plus, #]) & /@ listO), Null];
      int2deal3 = {(List @@ #) & /@ int2deal1, int2deal2} // Flatten;
      (*Print[int2deal3];*)

  		argument=#/.MB`MBint[_,{_,arg2_}]->arg2;
      zs=argument/.Rule[a_,_]->a;

  		eps234=#/.MB`MBint[_,{arg1_,_}]->arg1;
  		If[orderedrules[[i,2]]>0,
  			xmin=orderedrules[[i,1]]/.argument;
  			xmax=xmin+orderedrules[[i,2]];
  			c=-1;
  			newrule=RLchangeRule[orderedrules[[i,1]]->xmax]/@ {argument}//Flatten;
  		];
  		
      If[orderedrules[[i,2]]<0,
  			xmax=orderedrules[[i,1]]/.argument;
  			xmin=xmax+orderedrules[[i,2]];
  			c=1;
  			newrule=RLchangeRule[orderedrules[[i,1]]->xmin]/@ {argument}//Flatten;
  		];

      int2red = DeleteDuplicates[Join[
        Cases[int2deal3, (arg3___*Gamma[arg_] -> arg)],
        Cases[int2deal3, (arg3___*Gamma[arg_]^(arg2_ /; (arg2 > 0)) -> arg)],
        Cases[int2deal3, (Gamma[arg_] -> arg)],
        Cases[int2deal3, (Gamma[arg_]^(arg2_ /; (arg2 > 0)) -> arg)],
        Cases[int2deal3, (arg3___*PolyGamma[_, arg_] -> arg)],
        Cases[int2deal3, (arg3___*PolyGamma[_, arg_]^(arg2_ /; (arg2 > 0)) -> arg)],
        Cases[int2deal3, (PolyGamma[_, arg_] -> arg)],
        Cases[int2deal3, (PolyGamma[_, arg_]^(arg2_ /; (arg2 > 0)) -> arg)]] // Flatten];

  		(*int2red=DeleteDuplicates[Join[
  			Cases[List@@int2deal,(Gamma[arg_]->arg),-1],
  			Cases[List@@int2deal,(Gamma[arg_]^(arg2_/;(arg2>0))->arg),-1],
  			Cases[List@@int2deal,(PolyGamma[_,arg_]->arg),-1],
  			Cases[List@@int2deal,(PolyGamma[_,arg_]^(arg2_/;(arg2>0))->arg),-1]]//Flatten];
      *)
      (*Print[int2red];
      WriteString["stdout",orderedrules[[i,1]]];*)


      polesMZ=Join[
  			
        Cases[int2red,arg1_ + orderedrules[[i,1]] -> arg1 + orderedrules[[i,1]]+m]
  			
        ,Cases[int2red,orderedrules[[i,1]] -> orderedrules[[i,1]]+m]
        
        ,Cases[int2red,arg1_ + arg2_*orderedrules[[i,1]] -> arg1 + arg2*orderedrules[[i,1]]+m]
        
        ,Cases[int2red,arg2_*orderedrules[[i,1]] -> arg2*orderedrules[[i,1]]+m]
        
      ]//ExpandAll;
      
      (*Print[polesMZ];*)
      
      polesM=orderedrules[[i,1]]/.Solve[{polesMZ[[#]]==0},orderedrules[[i,1]]]&/@Range[Length[polesMZ]]//Flatten;
      
      (*Print["start",polesM];*)
  		
      poles=DeleteDuplicates[Table[polesM,{m,-40,40}]//Flatten];
      
      (*Print[poles];
      WriteString["stdout",xmin," ",xmax];*)
      residue=
  			  DeleteCases[
  				  If[(poles[[#]]/.argument)>xmin && (poles[[#]]/.argument)<xmax,
  					(poles[[#]]) 
          ]&/@(Range[Length[poles]]),
  			Null];
      
      (*Print[residue];*)
  		
      tkn234=RLchangeRule[orderedrules[[i,1]]->trminate]/@argument//Flatten;
  		
      argumentK=DeleteCases[tkn234,Alternatives@@{orderedrules[[i,1]]->trminate}];
  		(*
      Print[{MB`MBint[c*Residue[int2deal,{orderedrules[[i,1]],#}],{eps234,argumentK}]}&/@residue];
      *)

      termin={MB`MBint[c*Residue[int2deal,{orderedrules[[i,1]],#}],{eps234,argumentK}]}&/@residue;
      termin/. {Gamma[a_] :> Gamma[Expand[a]],
      PolyGamma[a_, b_] :> PolyGamma[a, Expand[b]]}
      
    )&/@(list1[[i]]//Flatten)
  	,{i,Length[list1]}];
  	toIntegrate=DeleteCases[(toIntegrate//Flatten)/.MB`MBint[0,_]->0,0];
    toIntegrate=(toIntegrate /. MB`MBint[a1_, {a2_, a3_}] -> {a1, a2, a3} // Factor);
    toIntegrate=#/. {a1_, a2_, a3_} -> MB`MBint[a1, {a2, a3}]&/@toIntegrate;
    
    argument55=list1[[1]]/.MB`MBint[_,{_,arg2_}]->arg2//Flatten;

    If[toIntegrate==={},WriteString["stdout",(toIntegrate//Length),"\n"]; Return[{{MB`MBint[0,{{1->0},Table[argument55[[i,1]]->0,{i,Length[argument55]-1}]}]},0}]];
    zs=toIntegrate[[1]]/.MB`MBint[_,{_,a_}]->a;
  	
    (*toIntegrate=(#//.MB`MBint[arg1_*(arg2_Gamma + arg3_Plus)/.kinRule//N,arg4__]->{MB`MBint[arg1*arg2,arg4],MB`MBint[arg1*arg3,arg4]}//Flatten)&/@toIntegrate//Flatten;*)
    
    toIntegrate=(#//.MB`MBint[arg1_*(coef_*arg2_Gamma + arg3_Plus)/.kinRule//N,arg4__]->{MB`MBint[arg1*coef*arg2,arg4],MB`MBint[arg1*arg3,arg4]}//Flatten)&/@toIntegrate//Flatten;

    (*toIntegrate=(#//.MB`MBint[arg1_*(arg2_Gamma + arg3_)/.kinRule//N,arg4__]->{MB`MBint[arg1*arg2,arg4],MB`MBint[arg1*arg3,arg4]}//Flatten)&/@toIntegrate//Flatten;*)
    
    toIntegrate=(#//.MB`MBint[arg1_*(coef_*arg2_Gamma + arg3_)/.kinRule//N,arg4__]->{MB`MBint[arg1*coef*arg2,arg4],MB`MBint[arg1*arg3,arg4]}//Flatten)&/@toIntegrate//Flatten;
    
    qq=(RLasymptotics[{#},kinRule]/.(#/.MB`MBint[_,{_,a_}]->a))&/@toIntegrate;
    qqList=Cases[qq//Flatten, Hold[LessEqual[a_, _]] /; NumericQ[a] && a > -2/2 -> a];
    If[Length[qqList]==0,WriteString["stdout","Success "]; success = 1; Break[]];
    WriteString["stdout","Failed: "];
    Print[qqList];
  ,{iteRules,Length[orderedrulesLIST]}];

  WriteString["stdout",(toIntegrate//Length),"\n"];
	Return[{toIntegrate,success}];
];

RLmove[MBintegrals_,rulemove_]:=Block[
	{result,oldrule,newrule,token,int,arg1,arg2,resultA},
	result=MBintegrals;
	Do[
		result=(
			oldrule=#/.MB`MBint[_,{_,arg2_}]->arg2;
			token=rulemove[[i,1]]/.oldrule;
			If[Length[DeleteCases[{token},rulemove[[i,1]]]]==0,
				newrule=oldrule,
				newrule=RLchangeRule[rulemove[[i,1]]->token+rulemove[[i,2]]]/@{oldrule}//Flatten;
			];
			{#/.MB`MBint[int_,{arg1_,arg2_}]->MB`MBint[int,{arg1,newrule}]}
		)&/@result;
		result=(result//Flatten);
		,
		{i,Length[rulemove]}
	];

	Return[result];
];

RLintegrate[MBintegrals_,kinRule_, options___Rule]:=Block[
	{opt = ParseOptions[RLintegrate, options],result,count,token,arg1,zs,radIntxtan,r1,r2,int2go,
  tutu,RESULTeps0raV,RESULTeps0raERR,RESULTeps0raERI,resA,resB},
	count=0;
	RLdefineMAP[RLlogarithm/.opt];
	WriteString["stdout",text/.opt];
	result=(
		zs=(#/.MB`MBint[_,{_,arg1_}]->arg1//Flatten)/.Rule[arg1_,_]->arg1;
		
		If[Length[zs]!=1,
			WriteString["stdout","."];
		];
		Switch[Length[zs],
			1,
			tutu=1000000;
			,
			2,
			tutu=2000000;
			,
			3,
			tutu=2000000;
			,
			4,
			tutu=2000000;
			,
			5,
			tutu=2000000;
			,
			6,
			tutu=2000000;
      ,
      7,
      tutu=2000000;
      ,
      8,
      tutu=2000000;
		];

		If [(MaxPoints/.opt)>1,
			tutu=(MaxPoints/.opt);
		];
		If[count++; (Length[zs])!=0,

			If[rad/.opt,
				token=(
					RESULTeps0raV={};
					RESULTeps0raERR={};

					RESULTeps0raERI={};
					(int2go=MB`MBshiftContours[{#}]/.{MB`MBint[int_,{arg1_,arg2_}]}->{int,arg1,arg2};
					radIntxtan=((D[Tan[Pi (r1-1/2)],r1]/.(r1->(1/2+1/2*r1)))r int2go[[1]]*2Pi*1/2
					/.{zs[[1]]->zs[[1]]+I*t1,zs[[2]]->zs[[2]]+I*t2}/.int2go[[3]]/.kinRule
					/.t1->r Sin[2*Pi*r2]/.t2->r Cos[2*Pi*r2]
					/.r->Tan[Pi ((1/2+1/2*r1)-1/2)])/(2 Pi)^2;				
					On[Cuba`Cuhre::success];
					resA=Cuba`Cuhre[Re[radIntxtan],{r1,0,1},{r2,0,1},Verbose->0,Compiled->0,PrecisionGoal->(PrecisionGoal/.opt),
                        AccuracyGoal->(AccuracyGoal/.opt),MaxPoints->1000000]//Flatten;
					resB=Cuba`Cuhre[Im[radIntxtan],{r1,0,1},{r2,0,1},Verbose->0,Compiled->0,PrecisionGoal->(PrecisionGoal/.opt),
                        AccuracyGoal->(AccuracyGoal/.opt),MaxPoints->1000000]//Flatten;
					(*RESULTeps0raV={RESULTeps0raV,resA[[1]]+resB[[1]]*I};
					RESULTeps0raERR={RESULTeps0raERR,resA[[2]]};
					RESULTeps0raERI={RESULTeps0raERI,resB[[2]]};v1*)
					RESULTeps0raV=resA[[1]]+resB[[1]]*I;
					RESULTeps0raERR=resA[[2]];
					RESULTeps0raERI=resB[[2]];
					Off[Cuba`Cuhre::success];
					);
					(*{RESULTeps0raV//Flatten,{RESULTeps0raERR//Flatten,RESULTeps0raERI//Flatten}}v1*)
					{RESULTeps0raV,{RESULTeps0raERR,RESULTeps0raERI}})
				,
          If[(checkRot/.opt)==0,tutu=tutu*1.5;];
        	token=MB`MBintegrate[{#},
					kinRule,
					PrecisionGoal->(PrecisionGoal/.opt),
					AccuracyGoal->(AccuracyGoal/.opt),
					Complex->(Complex/.opt),
					MaxPoints->tutu,
					MB`FixedContours->(MB`FixedContours/.opt),
					MB`MaxCuhreDim->(MB`MaxCuhreDim/.opt),
					Verbose->(Verbose/.opt),
					rad->(rad/.opt),
					Debug->(Debug/.opt),
          checkRot->(checkRot/.opt)
          ]
			];
		
			If[(Length[(List@@(token)[[1]])]!=2)
			,
				token
      ,
				count
			]
		,
			{N[#/.MB`MBint[arg1_,_]->arg1/.kinRule,{Infinity,(AccuracyGoal/.opt)}],{0,0}}
		]
	)&/@(MBintegrals//Flatten);
	Return[result]
];

RLshift[MBintegrals_,kinRule_,rulemove_,options___Rule]:=Block[
{resultA,resultN,resultY,count,arg1},
	resultA=RLmove[MBintegrals,rulemove];
	resultN=RLintegrate[resultA,kinRule,options];
	resultY=RLcombine[MBintegrals//Flatten,resultN];
	Return[resultY]
];

RLcalcRes[MBintegrals_,kinRule_,rulemove_,options___Rule]:=Block[
{resultA,resultN,resultZ},
	resultA=RLfindRes[MBintegrals,rulemove,kinRule][[1]];
	resultN=RLintegrate[resultA,kinRule,options];
	resultZ=RLcombine[resultA//Flatten,resultN];
	Return[resultZ]
];

RLsearchShift[MBintegrals_,M_,options___Rule]:=Block[
  {opt = ParseOptions[RLintegrate, options],into,zs,K,ListAllPerm,length,maxL,maxI,
    du,limites,nums,syms,allV,ruleH,averN,testN,abc,def,
    di,UJ,test1,test2,test3,test4,test5,a,doextra,radial,maxlength,perm,k,M2,upsala,xX,yY,
    sd,rt,fo,RE,B,ListAllPerm2,interesting,JJ2,token,DD,PP,QQ,WW,EE,TT,pole,maxIC,EQ},
  
  radial={rad->False};
  
  If[(MBintegrals//Length)===0,Return[0]];
  
  allV = {};

  into = MB`MBshiftContours[MBintegrals];
  K = into /. {MB`MBint[a_, _]} -> a;
  limites = M /. {Hold[a_], _} -> a /. b_ <= __ -> b // Union;
  zs = into /. {MB`MBint[_, {_, a_}]} -> a;
  nums = zs[[All, 2]];
  syms = zs[[All, 1]];
  allV = Cases[Variables[Level[limites, -1]], x_ /; AtomQ[x] :> x];
  allV = DeleteCases[allV, True];
  allV = DeleteCases[allV, False];
 
  ruleH = # -> # + (# /. zs) & /@ syms;

  allV=syms;


  If[ Length[allV]==2, maxIC = 31; ];
  If[ Length[allV]==3, maxIC = 23; ];
  If[ Length[allV]==4, maxIC = 21; ];
  If[ Length[allV]==5, maxIC = 19; ];
  If[ Length[allV]==6, maxIC = 5; ];
  If[ Length[allV]==7, maxIC = 5; ];
  If[ Length[allV]==8, maxIC = 5; ];

  If[Length[allV]>4,zlength=4,zlength=Length[allV]];
  ListAllPerm = {};
  Do[
    length = Length[zs];
    maxL = m;
    maxI = maxIC;
    maxlength = m + maxIC - 1;
    While[(maxI) > 0,
      maxlengthIndex = maxlength;
      perm = Array[0 &, length];
      If[maxL*maxI < maxlengthIndex, maxlengthIndex = maxL*maxI];
      
      {perm, maxlengthIndex} = 
      RLgenerateSeed[maxI, perm, maxlengthIndex, maxL, 0];
      ListAllPerm = Join[ListAllPerm, {perm}];
      While[1 < maxL,
        k = 1;
        Do[
           If[perm[[maxL]] == 1
             ,
             {perm, maxlengthIndex} = 
         RLgenerateSeed[maxI, perm, maxlengthIndex, maxL, 1];
             If[perm[[1]] == 1, Break[]];
             ListAllPerm = Join[ListAllPerm, {perm}];
             If[perm[[2]] == 1, Break[]];
           ];
           If[ perm[[k]] == perm[[maxL - 1]] && perm[[maxL]] != 1,
             {perm, maxlengthIndex} = 
         RLgenerateSeed[maxI, perm, maxlengthIndex, maxL, k];
             ListAllPerm = Join[ListAllPerm, {perm}];
           ];
           k++;
        , {maxL - 1}];
        If[perm[[2]] == 1, Break[]];
        If[perm[[maxL]] == 0, Break[];]
      ];
      maxI--;
    ];
  ,{m,zlength}];

  M2=M;
  If[Length[M2]==0,M2={Hold[True]}];
  (*Print[M2];*)

  upsala=DeleteCases[(M2 /. {Hold[a_], _} -> a),False];
  
  ListAllPerm = Flatten[Permutations[#] & /@ Union[ListAllPerm], 1];
  xX = If[Length[M2] == 0, False, 
     And @@ ((upsala)/. ruleH // Expand)];
  
  xX=True; (*!!!CARE!!!*)
  
  yY = (Plus @@ ((M2 /. {Hold[a_], _} -> a /. b_ <= __ -> b // 
            Union)) /. ruleH // Expand) /. True -> 0;
  sd = ToString[#] & /@ syms;
  rt = ToExpression[# <> "_"] & /@ sd;
  fo = {xX(*,Delete[allV,0],yY*)};
  
  Clear[EQ];
  RE = ToString[EQ[] /. EQ[b___] -> EQ[b, Delete[rt, 0]]] <> ":=" <> 
     ToString[fo /. Rational[a_, b_] -> RATIONAL[a, b] /. Hold[a_] -> a];
  ToExpression[StringReplace[RE, "RL`Private`RATIONAL" -> "Rational"]];

  B = RLgeneratePermutations[maxL, maxL*2, 2, 0, length] /. {2 -> -1};
  ListAllPerm2 = 
    Flatten[Table[#*B[[i]] & /@ ListAllPerm, {i, Length[B]}], 1];
  interesting = 
    Union[Flatten[Permutations[#] & /@ Union[ListAllPerm2], 1]];
  
  test1 = (j = 0;
            Join[
              EQ[Delete[#, 0]], 
              Table[
                syms[[++j]] ->  i
              , {i, #}]
            ]
          ) & /@ interesting /. Rule[_, 0] -> 0;
  
  test1 = DeleteCases[#, 0] & /@ test1;
  test1 = DeleteCases[test1, {False, __}] /. {True, a__} -> {a};
  test1 = DeleteCases[test1, {_Real}];
  test1 = DeleteDuplicates[test1];
  (*Print[test1];*)
  JJ2 = Thread[token = # /. Rule[_, a_] -> a; 
        DD = Abs[token[[Ordering[Abs[token]]]]]; 
        Flatten[{IntegerPart[(Plus @@ Abs[token]) - 
            IntegerPart[Length[token]]], IntegerPart[Length[token]], 
          Abs[IntegerPart[
            DD[[1]] - 
             Plus @@ (DD[[#]] & /@ (Range[Length[DD] - 1] + 1))]], #(*,
          Drop[#,-1]*)}]] & /@ test1 // AbsoluteTiming;
  (*Print[JJ2];*)

  PP = JJ2[[2]];
  QQ = DeleteCases[
     Cases[PP, {a_, __} /; (a == #)] & /@ 
      (Range[maxlength + maxL+1]-1), {}];
  
  WW = QQ[[#, Ordering[QQ[[#, All, 2]]]]] & /@ Range[Length[QQ]];
  EE = Table[
     DeleteCases[
      Cases[WW[[i]], {(*_,*)_, a_, __} /; (a == #)] & /@ 
       Range[maxL], {}], {i, Length[WW]}];
  (Table[EE[[#, i]] = EE[[#, i, Ordering[EE[[#, i, All]]]]], {i, 
        EE[[#]] // Length}]) & /@ Range[(EE // Length)];
  TT = Flatten[EE, 2];
  TT = Cases[TT, {_, _, _, d__} -> {d}];
  
  WriteString["stdout",Length[TT]];
  If[TT=={}, 
    pole={zs[[1,1]]->0};
    WriteString["stdout","no shifts2",pole];
    Return[{pole}];
    ,
    WriteString["stdout","rdy "];
    Return[TT];
  ];
];


RLsearchContour[into_,kinRule_,listofZR_,rotateList_,options___Rule]:=Block[
  {opt = ParseOptions[RLintegrate, options],listofZ,AstrAcc,AstrAccT,AstrMp,searchz,result,searchz2,res2,listto,
    searchz3,res3,zs,BstrAcc,options2,inttodo,dontpanic,rotateListZ,varR,varE,dontpanicrotate,scMP,rotata,radial,
    maxim,extraFLAG,countergg,breakLIMIT,tokenGG,maximADD,itlengthSZ,haio,rotateTest,negRot,posRot,tokenlistofZ,
    gg,varRT,varET,AstrAccSecond,lengthSZ,trafo,goTrafo},

  listofZ=listofZR;
  If[(into//Length)===0,
    WriteString["stdout","nothing to do"];
    Return[{0,0,0}]
  ];
  rotateListZ=rotateList;

  zs=(into[[1]]/.MB`MBint[_,{_,a_}]->a//Flatten)/.Rule[a_,_]->a;
  
  trafo=1/( (Plus@@zs)^6/10^9 + 1);
  (*Print[trafo];*)
  intoTrafo=into/.{MB`MBint[a_,{b_,c_}]}->{MB`MBint[a*trafo,{b,c}]};
  (*Print[intoTrafo];*)

  AstrAcc=10^-(AccuracyGoal/.opt);
  varR=100;
  varE=10;
  AstrMp=250000;
  dontpanic=250;
  dontpanicrotate=50;
  scMP=5000;
  rotata={0.3};
  Switch[Length[zs],
    2,
      scMP=100000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=250000;
      AstrMpTrafo=250000;
      dontpanicrotate=20;
      dontpanic=141;
      rotata=Range[9]/30;
    ,
    3,
      scMP=90000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=1000000;
      AstrMpTrafo=1000000;
      dontpanicrotate=50;
      dontpanic=171;
      rotata=Range[9]/30;
    ,
    4,
      scMP=90000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=2000000;
      AstrMpTrafo=2000000;
      dontpanicrotate=50;
      dontpanic=297;
    ,
    5,
      scMP=180000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=2000000;
      AstrMpTrafo=2000000;
      dontpanicrotate=50;
      dontpanic=297;
    ,
    6,
      scMP=180000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=2000000;
      AstrMpTrafo=2000000;
      dontpanicrotate=50;
      dontpanic=297;
    ,
    7,
      scMP=180000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=2000000;
      AstrMpTrafo=2000000;
      dontpanicrotate=50;
      dontpanic=297;
    ,
    8,
      scMP=180000;
      AstrAcc=10^-(AccuracyGoal/.opt);
      AstrMp=2000000;
      AstrMpTrafo=2000000;
      dontpanicrotate=50;
      dontpanic=297;
  ];

  If [(AccuracyGoal/.opt)<8,
    AstrAcc=10^-(AccuracyGoal/.opt);
  ];
  
  radial={rad->False};
  maxim={};
  extraFLAG=0;
  countergg=0;
  breakLIMIT=0;
  tokenGG={};
  While[True, 
    listofZ=DeleteCases[listofZ,Alternatives@@maxim];
    lengthSZ=Length[listofZ];
    maximADD={};
    itlengthSZ=0;
    goTrafo=0;
    If[Length[zs]>1 ,
      haio=1;
      If[countergg>dontpanic,tokenGG={};];
      
      If[Length[listofZ]>0,
        
        While[ True,
          itlengthSZ++;
          countergg++;
          If[(countergg-1)==dontpanicrotate,
            WriteString["stdout","@@@@@@@@@@jetzt@@@@@@@@"];
            WriteString["stdout",Length[listofZ]];
            tokenGG = DeleteCases[tokenGG,Alternatives @@ {{{a_}, _, _} /; NumericQ[a], {{a_, __}, _, _} /; ! NumericQ[a]}];
            WriteString["stdout",Length[tokenGG]];
            WriteString["stdout",tokenGG];
            rotateTest=(Take[tokenGG[[All,3]]]//Union)//Flatten;
            WriteString["stdout",rotateTest];
            negRot=Cases[rotateTest,a_/;a<0];
            posRot=Cases[rotateTest,a_/;a>0];
            rotateListZ={};
            If[Length[tokenGG]>0 && Length[negRot]>0,rotateListZ=Join[rotateListZ,-rotata]//Flatten];
            If[Length[tokenGG]>0 && Length[posRot]>0,rotateListZ=Join[rotateListZ,rotata]//Flatten];
            rotateListZ=Join[rotateListZ,{0}]//Flatten;
            WriteString["stdout",rotateListZ];
          ];
          If[(countergg-1)==dontpanic ,


            WriteString["stdout","@@@@@@@@@@jetzt@@@@@@@@\n"];
            WriteString["stdout",Length[listofZ],"\n"];
            tokenGG = DeleteCases[tokenGG,Alternatives @@ {{{a_}, _, _} /; NumericQ[a], {{a_, __}, _, _} /; ! NumericQ[a]}];
            WriteString["stdout",Length[tokenGG],"\n"];
            WriteString["stdout",tokenGG,"\n"];
            
            If[Length[tokenGG]>0
            ,
              tokenlistofZ=cleanup[tokenGG,listofZ,zs];
              listofZ=tokenlistofZ[[2]];
              rotateListZ=tokenlistofZ[[1]];
              listofZ=Delete[listofZ,1];
              (*listofZ=Delete[listofZ,1];
              listofZ=Delete[listofZ,1];
              listofZ=Delete[listofZ,1];*)
              lengthSZ=Length[listofZ];
              itlengthSZ=1;(*IntegerPart[lengthSZ/10];*)
              WriteString["stdout",Length[listofZ],"\n"];
              WriteString["stdout",Take[listofZ,10],"\n"];
            ,
              dontpanic=dontpanic+100;
            ];
          ];
          If[countergg<=dontpanic,breakLIMIT=1];
          haio=1;
          WriteString["stdout","\ncountergg: ",countergg];
          WriteString["stdout",listofZ[[itlengthSZ]]];
          Do[
            gg=RLintegrate[RLmove[into,listofZ[[itlengthSZ]]],kinRule,checkRot->(checkRot/.opt)*j,MaxPoints->scMP,MB`FixedContours->True,
                                  RLlogarithm->0,options]//Flatten;
            WriteString["stdout","\nshort test: ",gg];
            If[Length[gg]===3,
              If[ ( (gg[[2]]>varE || gg[[3]]>varE || Abs[Re[gg[[1]]]]>varR|| Abs[Im[gg[[1]]]]>varR) 
                    || (10^(-3)>Abs[Re[gg[[1]]]/gg[[2]]] && Abs[Re[gg[[1]]]] > 10^(-(AccuracyGoal/.opt)+5) && 
                      10^(-3)>Abs[Im[gg[[1]]]/gg[[3]]] && Abs[Im[gg[[1]]]] > 10^(-(AccuracyGoal/.opt)+5))
                  )
               || ( Abs[Re[gg[[1]]]] > gg[[2]] && gg[[2]] < 10^(-AccuracyGoal/.opt)/10 
                    && Abs[Im[gg[[1]]]] > gg[[3]] && gg[[3]] < 10^(-AccuracyGoal/.opt)/10
                  )
                  (*|| !(gg[[2]]<10^-(AccuracyGoal/.opt)*10^2 && gg[[3]]<10^-(AccuracyGoal/.opt)*10^2)*)
                ,
                maximADD=Join[maximADD,{listofZ[[itlengthSZ]]}];
                Continue[];
              ];
              ,
              maximADD=Join[maximADD,{listofZ[[itlengthSZ]]}];
              Continue[];
            ];

            gg=RLintegrate[RLmove[into,listofZ[[itlengthSZ]]],kinRule,checkRot->(checkRot/.opt)*j,MaxPoints->AstrMp
                                                    ,MB`FixedContours->True,options]//Flatten;

            WriteString["stdout","\n",gg];
            tokenGG=Join[tokenGG,{{gg,listofZ[[itlengthSZ]],(checkRot/.opt)*j}}];
            maximADD=Join[maximADD,{listofZ[[itlengthSZ]]}];
            If[Length[gg]===3,
              
              If[ ( Abs[gg[[2]]]>10^-(AccuracyGoal/.opt)/10 || Abs[gg[[3]]]>10^-(AccuracyGoal/.opt)/10
                   || (0.01<Abs[Re[gg[[1]]]/gg[[2]]] || 0.01<Abs[Im[gg[[1]]]/gg[[3]]])
                  )
                 && ( Abs[Re[gg[[1]]]/gg[[2]]]<10^12 && Abs[Im[gg[[1]]]/gg[[3]]]<10^12 )(*!!CARE*)
                 && !( Abs[Re[gg[[1]]]] > gg[[2]] && gg[[2]] < 10^(-AccuracyGoal/.opt)/10 
                        || Abs[Im[gg[[1]]]] > gg[[3]] && gg[[3]] < 10^(-AccuracyGoal/.opt)/10
                    )
                ,
                varRT=10^(Round[RealExponent[ gg[[1]] ]]+1);
                varET=10^(Round[RealExponent[ gg[[2]]+gg[[3]]I ]]+1);
                If[ varRT<varR && varR>10^(-(AccuracyGoal/.opt)+1), 
                  varR=varR/10;
                ];
                If[ varET<varE && varE>10^-(AccuracyGoal/.opt), 
                  varE=varE/10; 
                ];
                WriteString["stdout","changed:",varR," ",varE];
                If[ ( (gg[[2]]<AstrAcc && gg[[3]]<AstrAcc) ||  
                      ( (Abs[Re[gg[[1]]]]<AstrAcc*10^3 && Abs[Re[gg[[1]]]]<gg[[2]]) || 
                        (Abs[Im[gg[[1]]]]<AstrAcc*10^3 && Abs[Im[gg[[1]]]]<gg[[3]])
                      )
                    )&& (gg[[2]]<varE && gg[[3]]<varE && Abs[Re[gg[[1]]]]<varR && Abs[Im[gg[[1]]]]<varR) 
                  ,
                  searchz={listofZ[[itlengthSZ]],radial};
                  WriteString["stdout",searchz[[1]]];
                  rotateT=(checkRot/.opt)*j;
                  haio=0;
                  Break[];
                ];
              ];
            ];
          ,{j,rotateListZ}];

          If[haio==0,
            Break[];
          ];

          (* Test cut operator *)

          gg=RLintegrate[RLmove[intoTrafo,listofZ[[itlengthSZ]]],kinRule,checkRot->0,MaxPoints->AstrMpTrafo
                                                  ,MB`FixedContours->True,options]//Flatten;

          tokenGG=Join[tokenGG,{{gg,listofZ[[itlengthSZ]],0}}];
          maximADD=Join[maximADD,{listofZ[[itlengthSZ]]}];
          
          WriteString["stdout","\nTest cut operator: \n",gg];
          If[Length[gg]===3,
            
            If[ ( Abs[gg[[2]]]>10^-(AccuracyGoal/.opt)/10 || Abs[gg[[3]]]>10^-(AccuracyGoal/.opt)/10
                 || (0.01<Abs[Re[gg[[1]]]/gg[[2]]] || 0.01<Abs[Im[gg[[1]]]/gg[[3]]])
                )
               && ( Abs[Re[gg[[1]]]/gg[[2]]]<10^12 && Abs[Im[gg[[1]]]/gg[[3]]]<10^12 )(*!!CARE*)
               && !( Abs[Re[gg[[1]]]] > gg[[2]] && gg[[2]] < 10^(-AccuracyGoal/.opt)/10 
                      || Abs[Im[gg[[1]]]] > gg[[3]] && gg[[3]] < 10^(-AccuracyGoal/.opt)/10
                  )
              ,
              varRT=10^(Round[RealExponent[ gg[[1]] ]]+1);
              varET=10^(Round[RealExponent[ gg[[2]]+gg[[3]]I ]]+1);
              If[ varRT<varR && varR>10^(-(AccuracyGoal/.opt)+1), 
                varR=varR/10;
              ];
              If[ varET<varE && varE>10^-(AccuracyGoal/.opt), 
                varE=varE/10; 
              ];
              WriteString["stdout","changed:",varR," ",varE,"\n"];
              If[ ( (gg[[2]]<AstrAcc && gg[[3]]<AstrAcc) ||  
                    ( (Abs[Re[gg[[1]]]]<AstrAcc*10^3 && Abs[Re[gg[[1]]]]<gg[[2]]) || 
                      (Abs[Im[gg[[1]]]]<AstrAcc*10^3 && Abs[Im[gg[[1]]]]<gg[[3]])
                    )
                  )&& (gg[[2]]<AstrAcc && gg[[3]]<AstrAcc && Abs[Re[gg[[1]]]]<AstrAcc*100 && Abs[Im[gg[[1]]]]<AstrAcc*100) 
                ,
                searchz={listofZ[[itlengthSZ]],radial};
                WriteString["stdout",searchz[[1]]];
                rotateT=0;
                haio=0;
                goTrafo=1;
                Break[];
              ];
            ];
          ];

          If[haio==0,
            Break[];
          ];
          
          WriteString["stdout","uhu: ",countergg>=lengthSZ+dontpanic," ",countergg," ",lengthSZ+dontpanic];
          
          If[countergg>=lengthSZ+dontpanic, 
            haio=1;     (*CARE!!!*) 
            Break[];
          ];
        ];
      ];
      
      
      AstrAccSecond=AstrAcc*2;
      While[AstrAccSecond<1 && haio==1,
        maximADD={};
        Do[
          maximADD=Join[maximADD,{tokenGG[[i,2]]}];
          If[Length[tokenGG[[i,1]]]===3,
            If[ Abs[tokenGG[[i,1,2]]]<AstrAccSecond && Abs[tokenGG[[i,1,3]]]<AstrAccSecond 
                && (Abs[tokenGG[[i,1,2]]]>AstrAccSecond/10 || Abs[tokenGG[[i,1,3]]]>AstrAccSecond/10
                    || (0.01<Abs[Re[tokenGG[[i,1,1]]]/tokenGG[[i,1,2]]] || 0.01<Abs[Im[tokenGG[[i,1,1]]]/tokenGG[[i,1,3]]]))
                && (Abs[Re[tokenGG[[i,1,1]]]/tokenGG[[i,1,2]]]<10^12 && Abs[Im[tokenGG[[i,1,1]]]/tokenGG[[i,1,3]]]<10^12)(*!!CARE*)
              ,
              searchz={tokenGG[[i,2]],radial};
              rotateT=tokenGG[[i,3]];
              WriteString["stdout",searchz[[1]]];
              rotateT=0;
              haio=0;
              WriteString["stdout",tokenGG[[i,1]],searchz,rotateT];
              Break[];
            ];
          ];
        ,{i,Length[tokenGG]}];
        
        If[haio==0,
          extraFLAG=1;
          Break[];
          ,
          AstrAccSecond=AstrAccSecond*2;
        ];
      ];
      maxim=Join[maxim,maximADD];
    ];
    


    If[goTrafo==1,
      result = RLshift[ intoTrafo,kinRule,searchz[[1]],text->"calculate integral: ",searchz[[2,1]],
                    checkRot->rotateT,AccuracyGoal->((AccuracyGoal/.opt)+1),MB`FixedContours->True,options];
      ,
      result = RLshift[ into,kinRule,searchz[[1]],text->"calculate integral: ",searchz[[2,1]],
                    checkRot->rotateT,AccuracyGoal->((AccuracyGoal/.opt)+1),MB`FixedContours->True,options];
    ]
    If[extraFLAG==1,
      Break[];
    ];
    
    If[result[[4]]=!={0,0},
      If[ result[[4,2,1]]<10^-(AccuracyGoal/.opt) && result[[4,2,2]]<10^-(AccuracyGoal/.opt)
          && (result[[4,2,1]]>10^-(AccuracyGoal/.opt)/10 || result[[4,2,2]]>10^-(AccuracyGoal/.opt)/10
              || (0.01<Abs[Re[result[[4,1]]]/result[[4,2,1]]] || 0.01<Abs[Im[result[[4,1]]]/result[[4,2,2]]]))
          && (Abs[Re[result[[4,1]]]/result[[4,2,1]]]<10^13 && Abs[Im[result[[4,1]]]/result[[4,2,2]]]<10^13)(*!!CARE*)
          && !( (Abs[Re[result[[4,1]]]] > result[[4,2,1]] && result[[4,2,1]] < 10^((-AccuracyGoal/.opt)-3)) 
                || (Abs[Im[result[[4,1]]]] > result[[4,2,2]] && result[[4,2,2]] < 10^((-AccuracyGoal/.opt)-3))
              )
        ,
        Break[];
      ]
    ];
    If[Not[(breakLIMIT++)!=300], Break[];];
  ];
  Return[{result,searchz}];
];


cleanup[tokenGG_, listofZS_, zs_] := Block[{token,anfang,symsneu,symsneu2,anfang2,syms,anfang6,anfang3,anfang55,anfang5,anfang4,rotateTest,y5,
                                            listofZ,rotateList,anfang7},
    token = tokenGG;
    syms = zs;
    rotateTest=Take[token[[All,3]]];
    rotateList={rotateTest//Union}//Flatten;
    rotateList = rotateList[[Ordering[-Abs[rotateList[[All]]]]]];
    WriteString["stdout",rotateList,"\n"];
    anfang = (Delete[#, 3] & /@ token) // Union;
    symsneu = {(ToString[#] <> "1") & /@ syms, (ToString[#] <> "2") & /@
        syms, (ToString[syms[[1]]] <> "3"),(ToString[syms[[1]]] <> "4")} // Flatten;
    symsneu2 = Delete[symsneu, 1];
    symsneu2 = symsneu2[[;; ;; 2]];
    anfang2 = anfang[[Ordering[Abs[anfang[[All, 1, 2]]]]]];
    anfang2 = DeleteCases[anfang2, {_, {Rule[_, 0]}}];
    anfang3 = Take[anfang2[[All, 2]], Length[anfang2[[All, 2]]]];
    anfang4 = 
    Table[{(# /. a_ -> {___, a}) & /@ i, ___,y5_}// Flatten, {i, 
      anfang3}];
    anfang5 = 
    Table[j = 
      1; {(# /. {Rule[a_, b_] /; b < 0 -> symsneu2[[j++]] <0(*= b*), j--; 
          Rule[a_, b_] /; b > 0 -> symsneu2[[j++]] >0(*= b*)} & /@ i),Length[i]==y5}//Flatten, {i, 
      anfang3}];
    anfang55 = Table[{And @@ (# & /@ i)}, {i, anfang5}];
    k = 0;
    anfang6 = 
    ToExpression[
     Table[WriteString["stdout",i]; k++; j = 1; 
      ToString[{(# /. 
              Rule[a_, b_] -> Rule[a, symsneu[[j++]] <> "_"]) & /@i} // Flatten] <> "/;" <> ToString[anfang55[[k, 1]]], {i, 
       anfang4}]];
    listofZ=listofZS;
    WriteString["stdout",Take[listofZS,5],"\n"];
    listofZ=({#,Length[#]}//Flatten)&/@listofZ;
    WriteString["stdout",Take[listofZ,5],"\n"];
    anfang6 = {anfang6[[#]], #} & /@ Range[Length[anfang6]];
    anfang6 = Union[anfang6, SameTest -> ( #1[[1]] === #2[[1]] &)];
    anfang6 = anfang6[[Ordering[anfang6[[All, 2]]]]];
    anfang6 = Delete[anfang6[[#]], -1] & /@ Range[Length[anfang6]]//Flatten;
    If[Length[anfang6]<5,
      anfang6 = Take[anfang6, Length[anfang6]];
      ,
      anfang6 = Take[anfang6, 3];
    ];
    WriteString["stdout",anfang6,"\n"];
    anfang7 = Cases[listofZ, Alternatives @@ anfang6];
    anfang7=Delete[#,-1]&/@anfang7;
    Return[{rotateList,anfang7}];
];

RLdo[MBintegrals_,kinRule_,kinRuleEucl_,options___Rule]:=Block[
	{opt = ParseOptions[RLintegrate, options],checkRot,AstrAcc,AstrAccT,
    AstrMp,searchz,result,searchz2,res2,listto,searchz3,res3,zs,BstrAcc,
    options2,inttodo,into,listofZ,radial,maxim,allV,doextra,M,rotateT,
    rotateList,limites,zes,nums,syms,maxMinkDim,listofZADD,count,f1,f2,ruleLinear,r2,tokens1},

	If[(MBintegrals//Length)===0,
		WriteString["stdout","nothing to do"];
		Return[{0,0,0}]
	];

	inttodo=MBintegrals;
	into=MB`MBshiftContours[MBintegrals];
	zs=(inttodo[[1]]/.MB`MBint[_,{_,a_}]->a//Flatten)/.Rule[a_,_]->a;
  WriteString["stdout",Length[zs], " dim: "];	

	radial={rad->False};
	maxim={};
	listofZ={};

  allV = {};
  doextra=0;
  M = RLasymptotics[into,kinRule]; 
  Print[M];


  rotateT=0;
  rotateList={0};
  rotateT=RLcheckRotation[MBintegrals,M,kinRule];

  limites = M /. {Hold[a_], _} -> a /. b_ <= __ -> b // Union;
  zes = into /. {MB`MBint[_, {_, a_}]} -> a;
  nums = zes[[All, 2]];
  syms = zes[[All, 1]];
  allV = Cases[Variables[Level[limites, -1]], x_ /; AtomQ[x] :> x];
  If[(Cases[allV,False]//Length)!=0,rotateT=1;];

  
  If[0!=rotateT,
    If[Length[zs]>3,
      rotateList={0.3,-0.3,0}//Flatten;  
      ,
      rotateList={(Range[9]/30),-(Range[9]/30),0}//Flatten;
    ];
  ];
  
  
  WriteString["stdout","after check Rotation: ", rotateT];

  WriteString["stdout","!Generate shifts "];
  If[(listofZADD=RLsearchShift[MBintegrals,M,options])===0,
 	  WriteString["stdout","no contour found\n"];
 	  ,
		listofZ=Join[listofZ,listofZADD];
	];
  listofZ=Join[{{syms[[1]]->0}},listofZADD];

  maxMinkDim=8;
  If[Length[zs]<=maxMinkDim,
    If[Length[listofZ]>0
      ,
      WriteString["stdout","Search contour (rotate)"];
      {result,searchz}=RLsearchContour[into,kinRule,listofZ,rotateList,checkRot->rotateT,options];
      ,
      searchz={{zs[[1]]->0},radial};
      result=RLshift[into,kinRule,searchz[[1]],text->"calculate integral: ",searchz[[2,1]],MB`FixedContours->True,options];
    ];
  ];

	listto=RLfindRes[MBintegrals,searchz[[1]],kinRule][[1]];
	Return[{result,listto,searchz[[1]]}]
];

parallelIntegrate1dim[inttodoNow_,kinRule_,checkContour_,options___Rule]:=Block[
  {result,check},
  DistributeDefinitions[RLintegrate[a_]];
  DistributeDefinitions[MB`MBintegrate[a_]];
  DistributeDefinitions[RLtestT2Limit[a_,b_]];
  DistributeDefinitions[inttodoNow];
  result=
    ParallelTable[
      WriteString["stdout",i];
      If[checkContour==1,check=RLtestT2Limit[{inttodoNow[[i]]},kinRule]//First;,check=0;];
      WriteString["stdout",check];
      RLintegrate[{inttodoNow[[i]]},kinRule,options,checkRot->check]
    ,{i, 1, Length[inttodoNow]}];
  Return[result];
];

combineIntegrals[inttodoNow_,A_,options___Rule]:=Block[
  {opt = ParseOptions[RLintegrate, options],collectIntegrals,dontCollectIntegrals,crosscheck,crosscheck2},
  
  collectIntegrals={};
  dontCollectIntegrals={};
  Do[
    Do[  
      crosscheck=A[[i,1,1]]+A[[j,1,1]];
      crosscheck2=A[[i,1,1]]/A[[j,1,1]];
      
      If[!MemberQ[dontCollectIntegrals,i] && !MemberQ[dontCollectIntegrals,j] 
        && Abs[crosscheck]< If[A[[i,1,2]] == 0, 10^-(AccuracyGoal/.opt), If[ A[[i,1,2,1]]>A[[j,1,2,1]], A[[i,1,2,1]]*10,A[[j,1,2,1]]*10 ]]
        && 0.99<Abs[crosscheck2]<1.01,
        collectIntegrals=Join[collectIntegrals,{i,j}];
        dontCollectIntegrals=Join[dontCollectIntegrals,{i,j}]//Flatten;
        Break[];
      ];
    ,{j,i+1,Length[A]}];
  ,{i, 1, Length[A]-1}];

  collectIntegrals=(collectIntegrals//Flatten)//Union;
  collectIntegrals=Cases[collectIntegrals, a_ -> {a}];

  WriteString["stdout",collectIntegrals];
  WriteString["stdout","The number is even if correct: ",Length[collectIntegrals],"\n"];

  Return[Delete[inttodoNow,collectIntegrals]];
];

RLstart[MBintegrals_,kinRule_,kinRuleEucl_,options___Rule]:=Block[
	{opt = ParseOptions[RLintegrate, options],Ndim,Nintegrals,inttodo,integralsUsed,results,resultRLdo,inttodoNow,zs,A,integralCount,
  i,j,inttodoALLDIM,inttodoBuffer,grid,answer,asymp},
	
  inttodo=MBintegrals;	
  inttodo={#,Length[#/.MB`MBint[_,{_,a_}]->a]}&/@inttodo;  
  inttodo=inttodo[[ Ordering[-inttodo[[All,2]]] ]];

  integralsUsed={};
  inttodoALLDIM={};
	inttodoNow={};
	results={};

  Ndim = inttodo[[1,2]];
  inttodoBuffer={};
  While[(Length[inttodo])>0,
    If[Ndim!=inttodo[[1,2]],
      inttodoBuffer=inttodoBuffer//Flatten;
      inttodoALLDIM=Join[inttodoALLDIM,{inttodoBuffer}];
      inttodoBuffer={};
      Ndim=inttodo[[1,2]];
      Continue[];
    ];

    inttodoBuffer=Join[inttodoBuffer,{inttodo[[1,1]]}];
    inttodo=Delete[inttodo,1];
  ];
  
  If[Length[inttodoBuffer]>0,
    inttodoBuffer=inttodoBuffer//Flatten;
    inttodoALLDIM=Join[inttodoALLDIM,{inttodoBuffer}];
    inttodoBuffer={};
  ];
  
  While[(Length[inttodoALLDIM])>0,
    
    zs=(inttodoALLDIM[[-1,1]]/.MB`MBint[_,{_,a_}]->a//Flatten)/.Rule[a_,_]->a;
    Nintegrals = Length[inttodoALLDIM[[-1]]];
    WriteString["stdout","\nNumber of integrals with different dim: ",(Length[inttodoALLDIM])," / "];
    WriteString["stdout","Number of ",Length[zs],"-dim integrals: ",Nintegrals,"\n\n"];

    (*
    While[Nintegrals>0,
      inttodoNow = Join[inttodoNow,{inttodoALLDIM[[-1,1]]}];
      inttodoALLDIM[[-1]] = Delete[inttodoALLDIM[[-1]],1];
      Nintegrals--;
    ];
    *)

    inttodoNow = inttodoALLDIM[[-1]];
    inttodoALLDIM = Delete[inttodoALLDIM,-1];

    If[Length[zs]==0,

      If[(Length[inttodoNow])>0,
        results=Join[results,Total[parallelIntegrate1dim[inttodoNow,kinRule,0]]];
        Do[
          integralsUsed=Join[integralsUsed,{{inttodoNow[[i]],{0->0} } }];
        ,{i, 1, Length[inttodoNow]}];
      ];
      inttodoNow={};
    ];

    If[Length[zs]==1,
      
      If[(grid/.opt) == 0,

        A=parallelIntegrate1dim[inttodoNow,kinRuleEucl,1,AccuracyGoal->14,Complex->False];
        inttodoNow = combineIntegrals[inttodoNow,A,options];

      ];

      If[(Length[inttodoNow]) > 0,
        results=Join[results,Total[parallelIntegrate1dim[inttodoNow,kinRule,1,AccuracyGoal->(AccuracyGoal/.opt),MaxPoints->10000000]]];
        Do[
          integralsUsed=Join[integralsUsed,{{inttodoNow[[i]],{zs[[1]]->0} } }];
        ,{i, 1, Length[inttodoNow]}];
      ];
      inttodoNow={};

    ];

    If[Length[zs]>1, 

      If[(grid/.opt)==0,

        integralCount=1;
        A=Table[
          answer=RLintegrate[{inttodoNow[[i]]},kinRuleEucl,Complex->False,AccuracyGoal->18,MaxPoints->1000000];
          WriteString["stdout",integralCount++, " ",answer," "];
          answer
        ,{i, 1, Length[inttodoNow]}];

        inttodoNow = combineIntegrals[inttodoNow,A,options];

      ];

      integralCount = 1;
      Nintegrals = Length[inttodoNow];
      If[Nintegrals > 0,
        WriteString["stdout","Number of ",Length[zs],"dim: ",Nintegrals,"\n"];
      ];
            
      asymp = RLasymptotics[{#},kinRule]&/@inttodoNow;
      
      {inttodoNow,asymp} = ManipulateConvergence[inttodoNow, asymp,kinRule];

      inttodoNow = RLorderAsymptotics[inttodoNow, asymp];

      differentAsymptotics = Length[inttodoNow];

      WriteString["stdout","\nNumber of different asymptotics: ",differentAsymptotics,"\n"];

      While[ differentAsymptotics > 0,

        Nintegrals = Length[inttodoNow[[1]]];

        While[ Nintegrals > 0,

          WriteString["stdout", "\n",integralCount, " of "];

          resultRLdo = {0,0,0};

          resultRLdo = RLdo[{inttodoNow[[1,1]]},kinRule,kinRuleEucl,options];
          
          results = Join[results,{resultRLdo[[1,4]]}];
          
          integralsUsed = Join[integralsUsed,{{inttodoNow[[1,1]],resultRLdo[[3]]}}];

          If[resultRLdo[[2]]=!=0,

            If[ Length[inttodoNow[[1]]] > 1,
              WriteString["stdout", "Contour moved for all integrals", " \n"];
              
              (
                {additionalResidues,success} = RLfindRes[{inttodoNow[[1,#]]}, resultRLdo[[3]], kinRule];

                If[success == 1,

                 inttodoBuffer = Join[inttodoBuffer,additionalResidues]; (*Collect Residues*)
                 {inttodoNow[[1,#]]} = RLmove[{inttodoNow[[1,#]]},resultRLdo[[3]]];
                ];
                additionalResidues={};
              )& /@ (Range[ Length[inttodoNow[[1]]] - 1] + 1)
            ];

            inttodoBuffer = Join[inttodoBuffer,resultRLdo[[2]]]; (*Collect Residues*)
          ];

          inttodoNow[[1]] = Delete[inttodoNow[[1]],1];
          Nintegrals--;
          integralCount++;
        ];

        inttodoNow = Delete[inttodoNow,1];
        differentAsymptotics--;
      ];

      inttodoNow={};
      
      If[Length[inttodoBuffer]>0,
        inttodoBuffer = inttodoBuffer//Flatten;
        inttodoALLDIM = Join[inttodoALLDIM,{inttodoBuffer}];
        inttodoBuffer={};
      ];
    ];
  ];

  integralsUsed = RLmove[{#[[1]]}, #[[2]]] & /@ integralsUsed // Flatten;

	Return[{results,integralsUsed}];
];


ManipulateConvergence[inttodoNow_, asymp_,kinRule_]:=Block[
  {M, count, f1, f2, into, tokens1, ruleLinear, r2, zs},

  M = asymp;
  zs = (inttodoNow[[1]]/.MB`MBint[_,{_,a_}]->a//Flatten)/.Rule[a_,_]->a;
  into = inttodoNow;
  Do[   
    If[ Length[M[[j]]] == 2,
      If[Length[DeleteCases[M[[j, 1, 2]], 0]] == 2 && 
         Length[DeleteCases[M[[j, 2, 2]], 0]] == 2,
        count = 0;
        f1 = DeleteCases[(If[count++; Length[Cases[{#}, Alternatives @@ {a_*tVar, tVar}]] == 1, 
              count]) & /@ M[[j, 1, 2]], Null];
        count = 0;
        f2 = DeleteCases[(If[count++; Length[Cases[{#}, Alternatives @@ {a_*tVar, tVar}]] == 1, 
              count]) & /@ M[[j, 2, 2]], Null];
        
        If[f1 === f2,
         ruleLinear = {zs[[f1[[2]]]] -> zs[[f1[[2]]]] + zs[[f1[[1]]]], 
           zs[[f1[[2]]]] -> zs[[f1[[2]]]] - zs[[f1[[1]]]], 
           zs[[f1[[1]]]] -> zs[[f1[[1]]]] + zs[[f1[[2]]]], 
           zs[[f1[[1]]]] -> zs[[f1[[1]]]] - zs[[f1[[2]]]]};
          Do[
            tokens1 = RLnewFunc[{into[[j]]}, {i}];
            r2 = RLasymptotics[tokens1,kinRule];
            If[(r2 // Length) == 2,
              If[
                Length[DeleteCases[r2[[1, 2]], 0]] == 1 && 
                Length[DeleteCases[r2[[2, 2]], 0]] == 1,
                
                M[[j]]=r2;
                into[[j]] = tokens1[[1]];
                Print["Manipulated convergence:", r2];
                Break[];
              ];
            ];
          , {i, ruleLinear}];   
        ];
      ];
    ];
  ,{j,Length[M]}];

  Return[{into,M}];
];

RLasymptotics[MBintegrals_,kinRule_]:=Block[
	{into,zs,a,B,H,HU,K,A,jinx,x,pop,M,tVar,W,T,h0,u0,u1,M1,M2},

	zs=(MBintegrals/.{MB`MBint[_,{_,a_}]}->a//Flatten)/.Rule[a_,_]->a;
  zs=Sort[zs];  
	If[(MBintegrals//Length)===0,Return[0]];
  If[(Length[zs]<=0),Return[{}]];
	into = MBintegrals ; 
	H=into/.{MB`MBint[_,{_,a_}]}-> a;
	HU=(Rule[#[[1]],#[[1]]+#[[2]]])&/@H;
	K=into/.{MB`MBint[a_,_]}->a;
  u0=Cases[
     List @@ K, (arg_)^(arg2_) /; ! NumericQ[arg2] -> (arg)^(arg2)];
    If[Length[u0]==0,Return[{}]];
  u1=Cases[
     List @@ K/.kinRule, (arg_)^(arg2_) /; Re[arg]<0 -> arg2];
  u1=Cases[Variables[Level[u1, 1]], x_ /; AtomQ[x] :> x];
  into = Times @@ Join[Cases[List @@ K, (Gamma[arg_] -> Gamma[arg])],
    Cases[
     List @@ K, (Gamma[arg_]^(arg2_ /; (arg2 > 0)) -> 
       Gamma[arg]^arg2)],
    Cases[
     List @@ K, (Gamma[arg_]^(arg2_ /; (arg2 < 0)) -> 
       Gamma[arg]^arg2)],
    Cases[
     List @@ K, (arg_)^(arg2_) /; ! NumericQ[arg2] -> (arg)^(arg2)]];
  K=into;
		
  WriteString["stdout","Looking for Limits: "];
  B = RLgeneratePermutations[Length[zs], Length[zs]*5, 5, 0] /. {1 -> 0, 2 -> -tVar, 3 -> tVar,
 4 -> -tVar/ 2, 5 -> tVar /2, 6->-tVar/3, 7->tVar/3,8->-tVar/4,9->tVar/4};
	
  position=Position[zs,#]&/@u1//Flatten;
  B=DeleteCases[B,a_/;(Plus@@Abs[a[[position]]/.tVar->1]) === 0];
  If[B==={},
    Return[{}];
  ];
  jinx={};
  Do[
		jinx=Join[jinx,{{ExpandAll[K/.Map[Rule[ zs[[#]],zs[[#]]+(I) B[[i,#]]]&,Range[Length[zs]]]]/.RLLimitRules,B[[i]]}}];
	,{i,Length[B]}]; 
  h0 =(Factor[K] /. kinRule /. a__*(b_)^(z_)->b);
  If[Im[h0]<0,

    M1=DeleteCases[ Cases[Factor[jinx]/.kinRule,
                  {Exp[num_*Pi*tVar]*a_*tVar^x__*(b_)^(Complex[0,d_]tVar+c___),pop__} 
                  /; Re[b] < 0 && (Im[b]<0) && -d == num ->{Hold[x<=-3/2],pop}],True];
    M2=DeleteCases[ Cases[Factor[jinx]/.kinRule,
                  {Exp[num_*Pi*tVar]*tVar^x__*(b_)^(Complex[0,d_]tVar+c___),pop__} 
                  /; Re[b] < 0 && (Im[b]<0) && -d == num ->{Hold[x<=-3/2],pop}],True];
    M=Flatten[Join[M1,M2],0];
    ,
    M1=DeleteCases[ Cases[Factor[jinx]/.kinRule,
                  {Exp[num_*Pi*tVar]*a_*tVar^x__*(b_)^(Complex[0,d_]tVar+c___),pop__} 
                  /; Re[b] < 0 && (Im[b]>0 || Im[b]==0) && d == num ->{Hold[x<=-3/2],pop}],True];
    M2=DeleteCases[ Cases[Factor[jinx]/.kinRule,
                  {Exp[num_*Pi*tVar]*tVar^x__*(b_)^(Complex[0,d_]tVar+c___),pop__} 
                  /; Re[b] < 0 && (Im[b]>0 || Im[b]==0) && d == num ->{Hold[x<=-3/2],pop}],True]; 
    M=Flatten[Join[M1,M2],0];
  ];
	
  WriteString["stdout","found: ",Length[M]," "];

  Return[M];
];

RLcheckRotation[MBintegrals_,jui0_,kinRule_]:=Block[
  {into,zs,a,B,H,HU,K,A,jinx,x,pop,M,tVar,W,parameter3,intMB3,h0,h1,h2,h3,limis0,Explimis0,rotate,limis1},
  
  rotate={W -> 1,W->-1,W->0};
  into = MB`MBshiftContours[MBintegrals];
  If[jui0=={},
    Return[0];
  ];
  parameter3 = into /. {MB`MBint[_, {_, a_}]} -> a;
  zs = (into /. {MB`MBint[_, {_, a_}]} -> a // Flatten)/.Rule[a_, _] -> a;
  zs = Sort[zs];
  parameter3 = Sort[parameter3];
  intMB3 = into /. {MB`MBint[a_, {_, _}]} -> a;
  
  limis0 = (*Table[*)
            (((intMB3 /. 
                  Map[Rule[zs[[#]], zs[[#]] + (W + I) jui0[[(*i4*)1,2,#]]] &, 
                   Range[Length[zs]]] /. parameter3 // ExpandAll)
              /. {Gamma[num_ + cfw__* W*tVar + Complex[0, cft_]*tVar] -> E^(
                1/2 (Log[2 \[Pi]] + Log[1/tVar] - 2 num Log[1/tVar]) + 
                 tVar (-I cft - cfw W - 
                    I (cft - I cfw W) Log[1/tVar]) + (-(1/2) + num + 
                    I tVar (cft - I cfw W)) Log[I cft + cfw W])
               , 
               Gamma[num_ + W*tVar + Complex[0, cft_]*tVar] -> E^(
                
                1/2 (Log[2 \[Pi]] + Log[1/tVar] - 2 num Log[1/tVar]) + 
                 tVar (-I cft - W - I (cft - I W) Log[1/tVar]) + (-(1/2) + 
                    num + I tVar (cft - I W)) Log[I cft + W])
               }
             /. {Gamma[num_ + Complex[0, cft_]*tVar] -> 
               Exp[-tVar Abs[cf] Pi/2] tVar^(num - 1/2)
              ,Gamma[num_+cfw_* W*tVar] ->E^(1/2 (Log[
              2 \[Pi]]+Log[1/tVar]-2 num Log[1/tVar])+tVar (-cfw W-cfw W Log[1/
              tVar])+(-(1/2)+num+cfw tVar W) Log[cfw W])
              ,Gamma[num_+ W*tVar] ->E^(1/2 (Log[2 \[Pi]]+
              Log[1/tVar]-2 num Log[1/tVar])+tVar (-W-W Log[1/tVar])+(-(1/2)+num+
              tVar W) Log[W])
              } /. kinRule ))
          (*,{i4,Length[jui0]}]*);
  
  limis1=(((limis0/. # //N// Simplify) /. {Complex[af_, cf_]*tVar -> af tVar})&/@rotate);
  (*Print[limis1];*)
  Explimis0 = Cases[limis1[[1]], Exp[a_*tVar] -> a];
  (*Print[Explimis0];*)
  If[Length[Explimis0]!=0,
    If[Abs[First[Explimis0]] < 0.01, 
       Return[0]
      ,
       Return[1]
    ];
  ];

  Return[0];
];

RLgenerateSeed[maxI_, perm_List, maxlength_, maxL_, k_] := 
  Block[{perm2 = perm, maxlength2 = maxlength, maxA, j, firstStart, i},
  If[ perm2[[k]] < maxI
    , perm2[[k]]++;, maxlength2--;
  ];
  Do[
    perm2[[i]] = 0;
  , {i, k + 1, maxL}];
  firstStart = k + 1;
  maxA = maxlength2 - Plus @@ perm2;
  j = firstStart;
  Do[
    If[perm2[[j]] < maxI, perm2[[j]]++;];
    j++;
    If[Mod[j, maxL + 1] == 0, j = firstStart;];
  , {i, maxA}];
  Return[{perm2, maxlength2}];
];

RLgeneratePermutations[maxL_, maxlength_, maxS_, opy_, length___] := 
  Block[{B, A, token,xX,border},
  B = {};
  token = 1;
  If[opy==1,
    xX=1;
    A = Join[Table[xX++, {maxL}], Table[0, {length - maxL}]];
    ,
    A = Join[Table[1, {maxL}], Table[0, {length - maxL}]];
  
  ]
  If[opy==0,
    border=maxS+1;
    ,
    border=maxS+1-maxL+1;
  ];

  While[(A[[1]] < maxlength - (maxL - 1) + 1 && A[[1]] < border), 
    B = Join[B, {A}];
    A[[maxL]]++;
    token++;
    Do[ 
      If[A[[i]] == maxS + 1 || A[[maxL]] == maxS + 1 || ( Plus @@ A) > maxlength,

        If[opy==0,
          A[[i]] = 1; A[[i - 1]]++;
          ,
          A[[i - 1]]++;
          Do[
             A[[j+1]] = A[[j]]+1; 
          ,{j,i-1,maxL-1}];
        ];

        ,
        token--;
      ];
    , {i, maxL, 2, -1}];
  ];
  Return[B];
];


RLtestT2Limit[MBintegrals_,kinRule_]:= 
  Block[{B, A, token,aa,u,y,tVar,out,ok1,ok2,ok3},
  
  ok1 = RLgetLimit[MBintegrals, 0, 1,kinRule];
  ok2 = RLgetLimit[MBintegrals, 0, -1,kinRule];
  ok3 = RLgetLimit[MBintegrals, 0, 0,kinRule];
  
  (*
  Print[ok1];
  Print[ok2];
  Print[ok3];
  Print[Re[Coefficient[ok1[[2, 1, 1]],Log[tVar]]], Re[Coefficient[ok3[[2, 1, 1]],Log[tVar]]]];
  *)
  
  If[Re[ok1[[2, 1, 3]]] < 0 && Re[ok1[[2, 2, 3]]] < 0 && Abs[Re[ok1[[2, 1, 3]]]] > 0.0001 && Abs[Re[ok1[[2, 2, 3]]]] > 0.0001, Return[{1,ok1}]];

  If[Re[ok2[[2, 1, 3]]] < 0 && Re[ok2[[2, 2, 3]]] < 0 && Abs[Re[ok2[[2, 1, 3]]]] > 0.0001 && Abs[Re[ok2[[2, 2, 3]]]] > 0.0001, Return[{-1,ok2}]];
  
  If[Re[Coefficient[ok1[[2, 1, 1]],Log[tVar]]] < Re[Coefficient[ok3[[2, 1, 1]],Log[tVar]]] , Return[{-1,ok2}]];
  
  Return[{0}];
];

RLgetLimit[MBintegrals_, T1_, T2_,kinRule_] := 
  Block[{B, A, token, aa, u, y, tVar, out, s, log,into2,MM,trea,zs,into1,into,arg,arg2,mine,cond,seriesCond,uh,uk,Imuk,
  ukRed,ImukRed,Imfin,fin,klops,Imklops},

  $Assumptions = 
    Element[tVar, Reals] && tVar > 0;
  into2 =  MB`MBshiftContours[MBintegrals];

  trea = into2 /. {MB`MBint[_, {_, a_}]} -> a;
  zs = (MBintegrals /. {MB`MBint[_, {_, a_}]} -> a // Flatten) /.Rule[a_, _] -> a;
  zs=Sort[zs];
  into1 = MBintegrals /. {MB`MBint[a_, __]} -> a;
  into = Times @@ Join[Cases[List @@ into1, (Gamma[arg_] -> Gamma[arg])],
    Cases[
     List @@ into1, (Gamma[arg_]^(arg2_ /; (arg2 > 0)) -> 
       Gamma[arg]^arg2)],
    Cases[
     List @@ into1, (Gamma[arg_]^(arg2_ /; (arg2 < 0)) -> 
       Gamma[arg]^arg2)],
    Cases[
     List @@ into1, (arg_)^(arg2_) /; ! NumericQ[arg2] -> (arg)^(arg2)]];

  mine = (into
          /. Gamma[z__] -> Exp[(z - 1/2) Log[z]-z +log[2*Pi]*(1/2)(*+log[1+1/12/z]*)]
        ) ;

  (*Print[mine];*)
  cond=DeleteCases[RLgeneratePermutations[Length[zs], 3*Length[zs], 3, 0], Table[1, {Length[zs]}]]/.{1->0,2->-tVar,3->tVar,4->-tVar/2,5->tVar/2,6->-tVar/4,7->tVar/4};

  out=RLapplyLimit[mine,zs,#,T1,T2]&/@cond/.log[a_]->Log[a];
  
  seriesCond=2;
  If[T2==0,seriesCond=1];
  uh = Series[# /. tVar -> (1/tVar), {tVar, 0, seriesCond}]&/@out/.trea;
  
  uk = Table[Exp[ComplexExpand[Re[SeriesCoefficient[uh[[i]], -#]/.Log[a_]->Log[Abs[a]]+I*Arg[a]]]*y^#] &/@{0,1,2},{i,Length[uh]}];
  uk = (uk/. tVar -> 1/tVar /. y -> tVar );
  
  Imuk = Table[Exp[I*ComplexExpand[Im[SeriesCoefficient[uh[[i]], -#]/.Log[a_]->Log[Abs[a]]+I*Arg[a]]]*y^#]&/@{0,1,2},{i,Length[uh]}];
  Imuk = (Imuk/. tVar -> 1/tVar /. y -> tVar );

  ukRed = Table[(ComplexExpand[Re[SeriesCoefficient[uh[[i]], -#](* /.Log[a_]->Log[Abs[a]]+I*Arg[a] *)]]*y^#) &/@{0,1,2},{i,Length[uh]}];
  ukRed = (ukRed/. tVar -> 1/tVar /. y -> tVar );
  
  ImukRed = Table[(I*ComplexExpand[Im[SeriesCoefficient[uh[[i]], -#](* /.Log[a_]->Log[Abs[a]]+I*Arg[a] *)]]*y^#) &/@{0,1,2},{i,Length[uh]}];
  ImukRed = (ImukRed/. tVar -> 1/tVar /. y -> tVar );
  (*Print["Imuk ",ImukRed];*)


  fin=uk /. kinRule//Simplify;
  
  Imfin=Imuk /. kinRule (* /. Log[z_]/; Abs[z] < 0 -> Log[Abs[z]] + I*Arg[z]*);
  (*Print["Imfin ",Imfin];*)

  klops=(Table[{Coefficient[ (fin[[i, #]]) /. (a__)^b__ -> Exp[b*ln[a]] /. 
                Exp[z_]*a_ -> Exp[z+ln[a]] /. Exp[z_] -> z /. ln[z_] -> Log[z], 
                tVar, # - 1] & /@ Range[seriesCond+1],cond[[i]]}//Flatten,{i,Length[fin]}]//N)//Simplify;
  (*Print["klops: ",klops];*)

  Imklops=(Table[{Coefficient[ (Imfin[[i, #]]) /. (a__)^b__ -> Exp[b*ln[a]] /. 
                Exp[z_]*a__ -> Exp[z+ln[a]] /. Exp[z_] -> z /. ln[z_] -> Log[z], 
                tVar, # - 1] & /@ Range[seriesCond+1],cond[[i]]}//Flatten,{i,Length[Imfin]}]//N)//Simplify;
  (*Print["Imklops",Imklops];*)

  Return[{(*fin,*)1,klops,(*Imklops,*)ukRed(*,ImukRed*)}];

];


RLapplyLimit[mine_, zs_, cond_, u_, aa_] := 
  Block[{ln,a,xX,tVar,kj,uk,fin,y,yin,s,log},
  (*Print[cond];*)
  xX = (mine
          /.Map[Rule[zs[[#]], zs[[#]] + (u + I)*(cond[[#]]) + aa*(cond[[#]])^2] &, 
              Range[Length[zs]]]
         );
  cond2=DeleteCases[cond,0];
  jacobian=Plus@@(Log[(D[(u + I)*#, tVar]) Sign[Coefficient[#, tVar]]] &/@cond2)+Plus@@(Log[1+(2*(#)*aa)]&/@cond2);
  xX = (xX //. (a_^b__*Exp[c_]) -> Exp[c + b*log[a]]/. (a_*Exp[b_]) -> 
   Exp[b + log[a]]/.Exp[a_]->a )+jacobian;
  (*Print[xX];*)
  Return[xX];
];

RLnewFunc[MBintegrals_, linTrafo_] := 
  Block[{int2parts, jacobian, zsv, baba, newRealCut, result, 
    solojacob},
   int2parts = 
    MBintegrals /. {MB`MBint[c1_, {c2_, c3_}]} -> {c1, c2, c3};
   newRealCut = int2parts[[3]];
   jacobian = 1;
   Do[
    zsv = DeleteCases[newRealCut, Rule[i[[1]], _]];
    solojacob = D[i[[2]], i[[1]]];
    jacobian = jacobian*Abs[solojacob];
    baba = 
     i[[1]] -> ((i[[1]] - ((i[[2]]) /. i[[1]] -> 0) /. newRealCut))/
       solojacob;
    newRealCut = Join[zsv, {baba}] // Sort;
    int2parts[[1]] = int2parts[[1]] /. i;
    , {i, linTrafo}];
   result = {MB`MBint[(int2parts[[1]])*jacobian, {int2parts[[2]], 
       newRealCut}]};
   Return[result];
   ];

  RLorderAsymptotics[inttodoPUFFER_,asymp_]:=Block[{A4,A5,A6,length,A8,B1,A7,A9},
    inttodoPUFFER2=inttodoPUFFER//Flatten;
    
    A4 = #[[All, 1]] & /@ asymp;
    
    A5 = DeleteCases[A4[[#]] /. Hold[LessEqual[a_, _]] -> a, 
       Alternatives @@ {True, False}] & /@ Range[Length[A4]];
    
    A6 = {{Plus @@ Cases[A5[[#]], a_ /; NumericQ[a] -> a], 
        Plus @@ Join[Cases[A5[[#]], a_ + b___ /; NumericQ[a] -> a], 
          Cases[A5[[#]], a_ /; NumericQ[a] -> a]]}, {Join[
          DeleteCases[DeleteCases[A5[[#]], a_ + b_ /; NumericQ[a]], 
           a_ /; NumericQ[a]], 
          Cases[A5[[#]], a_ + b_ /; NumericQ[a] -> b]](*, 
         A2[[#, All, 2]]*)} // Flatten, #} & /@ Range[Length[A5]];
    
    length = Length[A6];
    A8 = {};
    B1 = A6;
    While[0 != length,
    
      A7 = Cases[B1, {_, B1[[1, 2]], _}];
      B1 = DeleteCases[B1, {_, B1[[1, 2]], _}];
      length = Length[B1];
      A8 = Join[A8, {A7}];
    ];
    
    A9 = #[[Ordering[#[[All, 1]]]]] & /@ A8;
    
    A1new = inttodoPUFFER2[[#[[All, 3]]]] & /@ A9;
    
    Return[A1new];
  ];



End[]

EndPackage[]
