(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     41654,       1197]
NotebookOptionsPosition[     39183,       1110]
NotebookOutlinePosition[     39518,       1125]
CellTagsIndexPosition[     39475,       1122]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "MB.m"}]], "Input",
 CellChangeTimes->{{3.810271748124408*^9, 3.810271762554912*^9}, {
  3.8102718085545673`*^9, 3.810271810359695*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"MB 1.2\"\>"], "Print",
 CellChangeTimes->{3.8102718107629642`*^9, 3.810272174327682*^9}],

Cell[BoxData["\<\"by Michal Czakon\"\>"], "Print",
 CellChangeTimes->{3.8102718107629642`*^9, 3.810272174328258*^9}],

Cell[BoxData["\<\"improvements by Alexander Smirnov\"\>"], "Print",
 CellChangeTimes->{3.8102718107629642`*^9, 3.810272174328706*^9}],

Cell[BoxData["\<\"more info in hep-ph/0511200\"\>"], "Print",
 CellChangeTimes->{3.8102718107629642`*^9, 3.810272174329145*^9}],

Cell[BoxData["\<\"last modified 2 Jan 09\"\>"], "Print",
 CellChangeTimes->{3.8102718107629642`*^9, 3.810272174329576*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
(* Fig.1 a,     Phys.Lett.B 762 (2016) 184-189, e-Print: 1607.08375] \
https://doi.org/10.1016/j.physletb.2016.09.012 *)\
\>", "Subsection",
 CellChangeTimes->{{3.810038686337144*^9, 3.810038699898633*^9}, {
  3.8102713442325478`*^9, 3.8102713527693863`*^9}, {3.8102714337152*^9, 
  3.8102715010996513`*^9}, {3.81027172991831*^9, 3.810271732927751*^9}},
 ExpressionUUID -> "0e2a4559-a9ac-4cf3-95b8-5b1e9ce64767"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plb161a", "=", 
  RowBox[{"{", 
   RowBox[{"MBint", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["MZ", "2"], ")"}], "z1"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "s"}], ")"}], 
        RowBox[{"-", "z1"}]], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"-", "z1"}], "]"}], "3"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "z1"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "z1"}], "-", "z2"}], "]"}], "3"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"-", "z2"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "z2"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "z1", "+", "z2"}], "]"}]}], 
      RowBox[{"s", " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "-", "z1"}], "]"}], "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "z2"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "z1"}], "-", "z2"}], "]"}]}]], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"z1", "\[Rule]", 
          RowBox[{"-", "0.5635754983749762`"}]}], ",", 
         RowBox[{"z2", "\[Rule]", 
          RowBox[{"-", "0.23729313220480758`"}]}]}], "}"}]}], "}"}]}], "]"}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.810038801144453*^9, 3.810038808544055*^9}},
 ExpressionUUID -> "2780f5d8-e9dd-45e9-a411-78e6db4914fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MBint", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["MZ", "2"], ")"}], "z1"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "s"}], ")"}], 
       RowBox[{"-", "z1"}]], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"-", "z1"}], "]"}], "3"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "z1"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "z1"}], "-", "z2"}], "]"}], "3"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"-", "z2"}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "z2"}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "z1", "+", "z2"}], "]"}]}], 
     RowBox[{"s", " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "z1"}], "]"}], "2"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "-", "z2"}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "z1"}], "-", "z2"}], "]"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"z1", "\[Rule]", 
         RowBox[{"-", "0.5635754983749762`"}]}], ",", 
        RowBox[{"z2", "\[Rule]", 
         RowBox[{"-", "0.23729313220480758`"}]}]}], "}"}]}], "}"}]}], "]"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.810272366755156*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plb161a", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.810272372891467*^9, 3.8102723782225437`*^9}}],

Cell["\<\
{MBint[((MZ^2)^z1*Gamma[-z1]^3*Gamma[1 + z1]*Gamma[-z1 - \
z2]^3*Gamma[-z2]*Gamma[1 + z2]*Gamma[1 + z1 + z2])/
   ((-s)^z1*s*Gamma[1 - z1]^2*Gamma[1 - z2]*Gamma[-2*z1 - z2]), {{eps -> 0}, \
{z1 -> -0.5635754983749762, z2 -> -0.23729313220480758}}]}\
\>", "Output",
 CellChangeTimes->{3.810272383556538*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MBintegrate", "[", 
  RowBox[{"plb161a", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"MZ", "\[Rule]", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.810271830180078*^9, 3.810271873594955*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Shifting contours...\"\>"], "Print",
 CellChangeTimes->{3.810271874259939*^9, 3.8102721855905523`*^9}],

Cell["Performing 0 lower-dimensional integrations with NIntegrate", "Print",
 CellChangeTimes->{3.810271874259939*^9, 3.810272185625355*^9}],

Cell[BoxData["\<\"Higher-dimensional integrals\"\>"], "Print",
 CellChangeTimes->{3.810271874259939*^9, 3.810272185626047*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing \"\>", "\[InvisibleSpace]", "\<\"MBpart10\"\>", 
   "\[InvisibleSpace]", "\<\" (dim \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Preparing ", "MBpart10", " (dim ", 2, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810271874259939*^9, 3.810272185626795*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Running \"\>", "\[InvisibleSpace]", "\<\"MBpart10\"\>"}],
  SequenceForm["Running ", "MBpart10"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810271874259939*^9, 3.8102721857017183`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.551666793220385`"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0002315102562732554`", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.810271874653077*^9, 3.8102721857854223`*^9}]
}, Open  ]]
}, Open  ]],

Cell["\<\
(* Fig.1 c,     Phys.Lett.B 762 (2016) 184-189, e-Print: 1607.08375] \
https://doi.org/10.1016/j.physletb.2016.09.012 *)\
\>", "Subsection",
 CellChangeTimes->{{3.810038686337144*^9, 3.810038699898633*^9}, {
  3.8102713442325478`*^9, 3.8102713527693863`*^9}, {3.8102714337152*^9, 
  3.8102715010996513`*^9}, {3.810271650388932*^9, 3.810271650797765*^9}},
 ExpressionUUID -> "0e2a4559-a9ac-4cf3-95b8-5b1e9ce64767"],

Cell[CellGroupData[{

Cell["", "Subsection",
 CellChangeTimes->{{3.810038907596964*^9, 3.810038917572439*^9}, {
  3.810271628655672*^9, 3.810271632497052*^9}},
 ExpressionUUID -> "bf9c0a5b-a3c0-4958-9908-b7e421ad2dd8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plb161c", "=", 
  RowBox[{"{", 
   RowBox[{"MBint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"-", "z2"}], "]"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"-", "z3"}], "]"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{
           RowBox[{"-", "z1"}], "+", "z3"}], "]"}], "^", "2"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "z1", "-", "z4"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "z1", "-", "z2", "-", "z4"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "z1", "-", "z2", "+", "z3", "-", "z4"}], 
         "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{"-", "z4"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "z4"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "z2", "+", "z4"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{"2", "+", "z1", "+", "z2", "+", "z4"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "z1", "-", "z3", "+", "z4"}], "]"}]}], ")"}], "/", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"s", "/", 
             RowBox[{"MZ", "^", "2"}]}], ")"}]}], ")"}], "^", "z1"}], "*", 
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"-", "z1"}], "]"}], "^", "2"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "z2"}], "-", "z3"}], "]"}], "*", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "z1"}], "-", "z2", "+", "z3"}], "]"}]}], ")"}]}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"z1", "\[Rule]", 
          RowBox[{"-", "0.970582481818209"}]}], ",", 
         RowBox[{"z2", "\[Rule]", 
          RowBox[{"-", "0.3947805149837126"}]}], ",", 
         RowBox[{"z3", "\[Rule]", 
          RowBox[{"-", "0.30380750969543907"}]}], ",", 
         RowBox[{"z4", "\[Rule]", 
          RowBox[{"-", "0.24334775906002817"}]}]}], "}"}]}], "}"}]}], "]"}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.810038920115509*^9, 3.8100389410467167`*^9}},
 ExpressionUUID -> "9df1d6e3-3434-4777-a5d3-960b8874a73f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MBint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["s", 
           SuperscriptBox["MZ", "2"]]}], ")"}], 
        RowBox[{"-", "z1"}]], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"-", "z2"}], "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"-", "z3"}], "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "z1"}], "+", "z3"}], "]"}], "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "z1", "-", "z4"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "z1", "-", "z2", "-", "z4"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "z1", "-", "z2", "+", "z3", "-", "z4"}], 
        "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"-", "z4"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "z4"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "z2", "+", "z4"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"2", "+", "z1", "+", "z2", "+", "z4"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "z1", "-", "z3", "+", "z4"}], "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"-", "z1"}], "]"}], "2"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "z2"}], "-", "z3"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "z1"}], "-", "z2", "+", "z3"}], "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"z1", "\[Rule]", 
         RowBox[{"-", "0.970582481818209`"}]}], ",", 
        RowBox[{"z2", "\[Rule]", 
         RowBox[{"-", "0.3947805149837126`"}]}], ",", 
        RowBox[{"z3", "\[Rule]", 
         RowBox[{"-", "0.30380750969543907`"}]}], ",", 
        RowBox[{"z4", "\[Rule]", 
         RowBox[{"-", "0.24334775906002817`"}]}]}], "}"}]}], "}"}]}], "]"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.810038943789729*^9, 3.810272751023657*^9},
 ExpressionUUID -> "5e493964-30db-47ee-a2a2-08edb0fce178"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plb161c", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.8102727537164516`*^9, 3.810272760531147*^9}}],

Cell["\<\
{MBint[(Gamma[-z2]^2*Gamma[-z3]^2*Gamma[-z1 + z3]^2*Gamma[-1 - z1 - \
z4]*Gamma[-1 - z1 - z2 - z4]*Gamma[-1 - z1 - z2 + z3 - z4]*
    Gamma[-z4]*Gamma[1 + z4]*Gamma[1 + z2 + z4]*Gamma[2 + z1 + z2 + \
z4]*Gamma[1 + z1 - z3 + z4])/
   (s^2*(-(s/MZ^2))^z1*Gamma[-z1]^2*Gamma[-z2 - z3]*Gamma[-z1 - z2 + z3]), 
  {{eps -> 0}, {z1 -> -0.970582481818209, z2 -> -0.3947805149837126, z3 -> \
-0.30380750969543907, z4 -> -0.24334775906002817}}]}\
\>", "Output",
 CellChangeTimes->{3.810272763053321*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MBintegrate", "[", 
  RowBox[{"plb161c", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"MZ", "\[Rule]", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.810272771018485*^9, 3.810272813700194*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Shifting contours...\"\>"], "Print",
 CellChangeTimes->{3.810272814324669*^9}],

Cell["Performing 0 lower-dimensional integrations with NIntegrate", "Print",
 CellChangeTimes->{3.810272814366993*^9}],

Cell[BoxData["\<\"Higher-dimensional integrals\"\>"], "Print",
 CellChangeTimes->{3.810272814367671*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing \"\>", "\[InvisibleSpace]", "\<\"MBpart10\"\>", 
   "\[InvisibleSpace]", "\<\" (dim \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Preparing ", "MBpart10", " (dim ", 4, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8102728143684464`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Running \"\>", "\[InvisibleSpace]", "\<\"MBpart10\"\>"}],
  SequenceForm["Running ", "MBpart10"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810272814503051*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.603543341939854`", ",", 
   RowBox[{"{", 
    RowBox[{"0.004058303818195515`", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.810272818654873*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
(* Fig.1 b, 1 d -> 1 b    Phys.Lett.B 762 (2016) 184-189, e-Print: \
1607.08375] https://doi.org/10.1016/j.physletb.2016.09.012 *)\
\>", "Subsection",
 CellChangeTimes->{{3.8100388218540487`*^9, 3.81003884988482*^9}, {
  3.810271589051155*^9, 3.8102716177795763`*^9}},
 ExpressionUUID -> "dc3ee33d-994d-4e90-b53e-20d7367e04ef"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox[{
    {Hue[0.0603, 0.94, 0.9], Opacity[1], {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$1", Automatic, Center], DynamicLocation[
         "VertexID$2", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$1"], 
      InsetBox["\<\"-p1 - p2\"\>", DynamicLocation[
       "EdgeLabelID$1", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$2", Automatic, Center], DynamicLocation[
         "VertexID$6", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$2"], 
      InsetBox["\<\"[k1 + p1 + p2,0]\"\>", DynamicLocation[
       "EdgeLabelID$2", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$2", Automatic, Center], DynamicLocation[
         "VertexID$7", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$3"], 
      InsetBox["\<\"[k1,0]\"\>", DynamicLocation[
       "EdgeLabelID$3", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$3", Automatic, Center], DynamicLocation[
         "VertexID$4", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$4"], 
      InsetBox["\<\"p1\"\>", DynamicLocation[
       "EdgeLabelID$4", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$4", Automatic, Center], DynamicLocation[
         "VertexID$7", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$5"], 
      InsetBox["\<\"[k2,MT]\"\>", DynamicLocation[
       "EdgeLabelID$5", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$4", Automatic, Center], DynamicLocation[
         "VertexID$8", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$6"], 
      InsetBox["\<\"[k2 + p1,MW]\"\>", DynamicLocation[
       "EdgeLabelID$6", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$5", Automatic, Center], DynamicLocation[
         "VertexID$6", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$7"], 
      InsetBox["\<\"p2\"\>", DynamicLocation[
       "EdgeLabelID$7", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$6", Automatic, Center], DynamicLocation[
         "VertexID$8", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$8"], 
      InsetBox["\<\"[k1 + p1,0]\"\>", DynamicLocation[
       "EdgeLabelID$8", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}, {
      TagBox[
       LineBox[{
        DynamicLocation["VertexID$7", Automatic, Center], DynamicLocation[
         "VertexID$8", Automatic, Center]}],
       "DynamicName",
       BoxID -> "EdgeLabelID$9"], 
      InsetBox["\<\"[k1 - k2,MW]\"\>", DynamicLocation[
       "EdgeLabelID$9", Automatic, Scaled[0.5]], ImageScaled[{0.5, 0.5}],
       BaseStyle->"Graphics"]}}, 
    {GrayLevel[0], 
     TagBox[{
       TagBox[
        DiskBox[{3.688194814752096, 2.538984549816728}, 0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$1"], 
       InsetBox["\<\"ex1\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$1", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$1"], 
     TagBox[{
       TagBox[
        DiskBox[{2.9993855690399576`, 1.7896990762121137`}, 
         0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$2"], 
       InsetBox["\<\"1\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$2", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$2"], 
     TagBox[{
       TagBox[DiskBox[{0., 1.26948863676459}, 0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$3"], 
       InsetBox["\<\"ex2\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$3", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$3"], 
     TagBox[{
       TagBox[
        DiskBox[{1.0102681672728402`, 1.2695529937578895`}, 
         0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$4"], 
       InsetBox["\<\"2\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$4", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$4"], 
     TagBox[{
       TagBox[DiskBox[{3.6882301619384696`, 0.}, 0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$5"], 
       InsetBox["\<\"ex3\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$5", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$5"], 
     TagBox[{
       TagBox[
        DiskBox[{3.0000088636868076`, 0.7497710501166494}, 
         0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$6"], 
       InsetBox["\<\"3\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$6", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$6"], 
     TagBox[{
       TagBox[
        DiskBox[{1.9279686007159476`, 1.6333994937482181`}, 
         0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$7"], 
       InsetBox["\<\"4\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$7", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$7"], 
     TagBox[{
       TagBox[
        DiskBox[{1.92852798126815, 0.9047549269642767}, 0.03497966835188035],
        "DynamicName",
        BoxID -> "VertexID$8"], 
       InsetBox["\<\"5\"\>", 
        Offset[{2, 2}, DynamicLocation[
         "VertexID$8", Automatic, {Right, Top}]], ImageScaled[{0, 0}],
        BaseStyle->"Graphics"]},
      "DynamicName",
      BoxID -> "VertexLabelID$8"]}}],
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->{632., Automatic}]], "Input",
 ExpressionUUID -> "8f50f213-3ed7-409f-8dbe-e34dcb709656"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plb161b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"MBint", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["MT", "2"], ")"}], "z2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["MW", "2"], ")"}], 
            RowBox[{
             RowBox[{"-", "1"}], "-", "z2"}]], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "-", "z2"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"-", "z2"}], "]"}], " ", 
           SuperscriptBox[
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "z2"}], "]"}], "2"]}], 
          RowBox[{
           SuperscriptBox["eps", "2"], " ", "s"}]]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"z2", "\[Rule]", 
            RowBox[{"-", "0.8950748276800662`"}]}], "}"}]}], "}"}]}], "]"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MBint", "[", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["MT", "2"], ")"}], "z2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["MW", "2"], ")"}], 
            RowBox[{
             RowBox[{"-", "1"}], "-", "z2"}]], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "-", "z2"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"-", "z2"}], "]"}], " ", 
           SuperscriptBox[
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "z2"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"Log", "[", 
              SuperscriptBox["MW", "2"], "]"}], "+", 
             RowBox[{"Log", "[", 
              RowBox[{"-", "s"}], "]"}], "+", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "-", "z2"}]}], "]"}], "-", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "+", "z2"}]}], "]"}]}], ")"}]}], 
          RowBox[{"eps", " ", "s"}]], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z2", "\[Rule]", 
             RowBox[{"-", "0.8950748276800662`"}]}], "}"}]}], "}"}]}], "]"}], 
       ",", 
       RowBox[{"MBint", "[", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["MT", "2"], ")"}], "z2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             SuperscriptBox["MW", "2"], ")"}], 
            RowBox[{
             RowBox[{"-", "1"}], "-", "z2", "-", "z3"}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "s"}], ")"}], "z3"], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "-", "z2"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"-", "z2"}], "]"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"-", "z3"}], "]"}], " ", 
           RowBox[{"Gamma", "[", "z3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "z2", "+", "z3"}], "]"}], "2"]}], 
          RowBox[{"eps", " ", "s", " ", 
           SuperscriptBox[
            RowBox[{"Gamma", "[", 
             RowBox[{"2", "+", "z3"}], "]"}], "2"]}]], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"z2", "\[Rule]", 
              RowBox[{"-", "0.9295786323942651`"}]}], ",", 
             RowBox[{"z3", "\[Rule]", "0.6874421652135165`"}]}], "}"}]}], 
          "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MBint", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"6", " ", "s"}]], 
          SuperscriptBox[
           RowBox[{"(", 
            SuperscriptBox["MT", "2"], ")"}], "z2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            SuperscriptBox["MW", "2"], ")"}], 
           RowBox[{
            RowBox[{"-", "1"}], "-", "z2"}]], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "-", "z2"}], "]"}], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"-", "z2"}], "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "z2"}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            SuperscriptBox["\[Pi]", "2"], "+", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              SuperscriptBox["MW", "2"], "]"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox[
              RowBox[{"Log", "[", 
               SuperscriptBox["MW", "2"], "]"}], "2"]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"-", "s"}], "]"}]}], "-", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              SuperscriptBox["MW", "2"], "]"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{"-", "s"}], "]"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox[
              RowBox[{"Log", "[", 
               RowBox[{"-", "s"}], "]"}], "2"]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "-", "z2"}]}], "]"}]}], "-", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              SuperscriptBox["MW", "2"], "]"}], " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "-", "z2"}]}], "]"}]}], "-", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"-", "s"}], "]"}], " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "-", "z2"}]}], "]"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox[
              RowBox[{"PolyGamma", "[", 
               RowBox[{"0", ",", 
                RowBox[{"1", "-", "z2"}]}], "]"}], "2"]}], "-", 
            RowBox[{"6", " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "+", "z2"}]}], "]"}]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              SuperscriptBox["MW", "2"], "]"}], " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "+", "z2"}]}], "]"}]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"-", "s"}], "]"}], " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "+", "z2"}]}], "]"}]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "-", "z2"}]}], "]"}], " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "+", "z2"}]}], "]"}]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox[
              RowBox[{"PolyGamma", "[", 
               RowBox[{"0", ",", 
                RowBox[{"1", "+", "z2"}]}], "]"}], "2"]}], "-", 
            RowBox[{"3", " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"1", ",", 
               RowBox[{"1", "-", "z2"}]}], "]"}]}], "-", 
            RowBox[{"3", " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"1", ",", 
               RowBox[{"1", "+", "z2"}]}], "]"}]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"z2", "\[Rule]", 
             RowBox[{"-", "0.8950748276800662`"}]}], "}"}]}], "}"}]}], "]"}], 
       ",", 
       RowBox[{"MBint", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"s", " ", 
            SuperscriptBox[
             RowBox[{"Gamma", "[", 
              RowBox[{"2", "+", "z3"}], "]"}], "2"]}]], 
          SuperscriptBox[
           RowBox[{"(", 
            SuperscriptBox["MT", "2"], ")"}], "z2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            SuperscriptBox["MW", "2"], ")"}], 
           RowBox[{
            RowBox[{"-", "1"}], "-", "z2", "-", "z3"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "s"}], ")"}], "z3"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "-", "z2"}], "]"}], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"-", "z2"}], "]"}], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"-", "z3"}], "]"}], " ", 
          RowBox[{"Gamma", "[", "z3", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "z2", "+", "z3"}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "EulerGamma"}], "-", 
            RowBox[{"Log", "[", 
             SuperscriptBox["MW", "2"], "]"}], "-", 
            RowBox[{"Log", "[", 
             RowBox[{"-", "s"}], "]"}], "-", 
            RowBox[{"PolyGamma", "[", 
             RowBox[{"0", ",", 
              RowBox[{"1", "-", "z2"}]}], "]"}], "+", 
            RowBox[{"PolyGamma", "[", 
             RowBox[{"0", ",", 
              RowBox[{"1", "-", "z3"}]}], "]"}], "-", 
            RowBox[{"PolyGamma", "[", 
             RowBox[{"0", ",", "z3"}], "]"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"PolyGamma", "[", 
              RowBox[{"0", ",", 
               RowBox[{"1", "+", "z3"}]}], "]"}]}], "+", 
            RowBox[{"PolyGamma", "[", 
             RowBox[{"0", ",", 
              RowBox[{"2", "+", "z3"}]}], "]"}], "+", 
            RowBox[{"PolyGamma", "[", 
             RowBox[{"0", ",", 
              RowBox[{"1", "+", "z2", "+", "z3"}]}], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"z2", "\[Rule]", 
              RowBox[{"-", "0.9295786323942651`"}]}], ",", 
             RowBox[{"z3", "\[Rule]", "0.6874421652135165`"}]}], "}"}]}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"MBint", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              SuperscriptBox["MT", "2"], ")"}], "z2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              SuperscriptBox["MW", "2"], ")"}], "z1"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "s"}], ")"}], 
             RowBox[{
              RowBox[{"-", "2"}], "-", "z1", "-", "z2"}]], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"-", "z1"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "z1", "-", "z2"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"-", "z2"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"2", "+", "z1", "+", "z2"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{
              RowBox[{"-", "z1"}], "-", 
              RowBox[{"2", " ", "z2"}], "-", "z3"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "z1", "-", "z2", "-", "z3"}], "]"}], 
            " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{
              RowBox[{"-", "z1"}], "-", "z2", "-", "z3"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"-", "z3"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "z2", "+", "z3"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "z1", "+", "z2", "+", "z3"}], "]"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "-", "z1", "-", "z2"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "-", "z3"}], "]"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "z1"}], "-", 
              RowBox[{"2", " ", "z2"}], "-", "z3"}], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eps", "\[Rule]", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"z1", "\[Rule]", 
              RowBox[{"-", "0.9367384482915713`"}]}], ",", 
             RowBox[{"z2", "\[Rule]", 
              RowBox[{"-", "0.3696994315102022`"}]}], ",", 
             RowBox[{"z3", "\[Rule]", 
              RowBox[{"-", "0.3134488706938101`"}]}]}], "}"}]}], "}"}]}], 
        "]"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8100388677808228`*^9, 3.810038901827671*^9}, 
   3.810272870938857*^9},
 ExpressionUUID -> "efca8bba-f6e3-434a-aa38-307f303a5e11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MBintegrate", "[", 
  RowBox[{"plb161b", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"MZ", "\[Rule]", "1"}], ",", 
     RowBox[{"MT", "\[Rule]", "2"}], ",", 
     RowBox[{"MW", "\[Rule]", "1.5"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.810272842119473*^9, 3.810272894896594*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Shifting contours...\"\>"], "Print",
 CellChangeTimes->{3.810272896176887*^9}],

Cell["\<\
Performing 3 lower-dimensional integrations with NIntegrate...1...2...3\
\>", "Print",
 CellChangeTimes->{3.810272899627203*^9}],

Cell[BoxData["\<\"Higher-dimensional integrals\"\>"], "Print",
 CellChangeTimes->{3.810272899830159*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing \"\>", "\[InvisibleSpace]", "\<\"MBpart1eps0\"\>", 
   "\[InvisibleSpace]", "\<\" (dim \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Preparing ", "MBpart1eps0", " (dim ", 3, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810272899831065*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing \"\>", "\[InvisibleSpace]", "\<\"MBpart2eps0\"\>", 
   "\[InvisibleSpace]", "\<\" (dim \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Preparing ", "MBpart2eps0", " (dim ", 2, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8102728999346933`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing \"\>", "\[InvisibleSpace]", "\<\"MBpart3eps-1\"\>", 
   "\[InvisibleSpace]", "\<\" (dim \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["Preparing ", "MBpart3eps-1", " (dim ", 2, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8102729000244627`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Running \"\>", "\[InvisibleSpace]", "\<\"MBpart1eps0\"\>"}],
  SequenceForm["Running ", "MBpart1eps0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810272900104447*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Running \"\>", "\[InvisibleSpace]", "\<\"MBpart2eps0\"\>"}],
  SequenceForm["Running ", "MBpart2eps0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.81027290140961*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Running \"\>", "\[InvisibleSpace]", "\<\"MBpart3eps-1\"\>"}],
  SequenceForm["Running ", "MBpart3eps-1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.81027290146426*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.06168616685444992`", "\[VeryThinSpace]", "+", 
    FractionBox["0.18006745456794652616593360990668892298`15.954589770191003", 
     SuperscriptBox["eps", "2"]], "-", 
    FractionBox["0.17726089274747533`", "eps"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2.325532462839057`*^-6", "+", 
      FractionBox["4.401653066333882`*^-7", "eps"]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.810272858420882*^9, 3.8102729015018053`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1366, 683},
WindowMargins->{{87, Automatic}, {Automatic, 90}},
FrontEndVersion->"10.2 for Linux x86 (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 165, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[770, 29, 106, 1, 23, "Print"],
Cell[879, 32, 116, 1, 23, "Print"],
Cell[998, 35, 133, 1, 23, "Print"],
Cell[1134, 38, 127, 1, 23, "Print"],
Cell[1264, 41, 122, 1, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[1435, 48, 422, 7, 45, "Subsection"],
Cell[CellGroupData[{
Cell[1882, 59, 1741, 51, 100, "Input"],
Cell[3626, 112, 1583, 49, 101, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5246, 166, 132, 2, 32, "Input"],
Cell[5381, 170, 316, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5734, 181, 295, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[6054, 193, 120, 1, 23, "Print"],
Cell[6177, 196, 140, 1, 23, "Print"],
Cell[6320, 199, 126, 1, 23, "Print"],
Cell[6449, 202, 369, 7, 23, "Print"],
Cell[6821, 211, 242, 5, 23, "Print"]
}, Open  ]],
Cell[7078, 219, 245, 6, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[7350, 229, 423, 7, 45, "Subsection"],
Cell[CellGroupData[{
Cell[7798, 240, 196, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[8019, 247, 2639, 74, 143, "Input"],
Cell[10661, 323, 2526, 71, 137, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13224, 399, 132, 2, 32, "Input"],
Cell[13359, 403, 503, 9, 100, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13899, 417, 295, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[14219, 429, 96, 1, 23, "Print"],
Cell[14318, 432, 118, 1, 23, "Print"],
Cell[14439, 435, 104, 1, 23, "Print"],
Cell[14546, 438, 349, 7, 23, "Print"],
Cell[14898, 447, 218, 5, 23, "Print"]
}, Open  ]],
Cell[15131, 455, 201, 5, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15381, 466, 337, 6, 45, "Subsection"],
Cell[15721, 474, 6744, 179, 461, "Input"],
Cell[22468, 655, 13625, 361, 584, "Input"],
Cell[CellGroupData[{
Cell[36118, 1020, 383, 10, 32, "Input"],
Cell[CellGroupData[{
Cell[36526, 1034, 96, 1, 23, "Print"],
Cell[36625, 1037, 138, 3, 23, "Print"],
Cell[36766, 1042, 104, 1, 23, "Print"],
Cell[36873, 1045, 353, 7, 23, "Print"],
Cell[37229, 1054, 355, 7, 23, "Print"],
Cell[37587, 1063, 357, 7, 23, "Print"],
Cell[37947, 1072, 224, 5, 23, "Print"],
Cell[38174, 1079, 223, 5, 23, "Print"],
Cell[38400, 1086, 225, 5, 23, "Print"]
}, Open  ]],
Cell[38640, 1094, 515, 12, 63, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

