(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22215,        539]*)
(*NotebookOutlinePosition[     22843,        561]*)
(*  CellTagsIndexPosition[     22799,        557]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(<< hexagon.m\)], "Input"],

Cell[BoxData[
    \("by K.Kajda, ver: 1.0\nlast modified 19 sep 2008"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Install["\<LoopTools\>"]\)], "Input"],

Cell[BoxData[
    \(LinkObject["./LoopTools", 2, 2]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Results\ of\ Table\ 2\ \(arXiv : \ 0807.2984\)\ *) \)], "Input"],

Cell[BoxData[{
    \(\(kinematics = {\[IndentingNewLine]p1 . p1 -> p1s, p2 . p2 \[Rule] p2s, 
          p3 . p3 \[Rule] p3s, p4 . p4 \[Rule] p4s, 
          p5 . p5 \[Rule] 
            p5s, \[IndentingNewLine]p1 . p2 \[Rule] \((s12 - p1s - p2s)\)/
              2, \[IndentingNewLine]p2 . p3 \[Rule] \((s23 - p2s - p3s)\)/
              2, \[IndentingNewLine]p3 . p4 \[Rule] \((s34 - p3s - p4s)\)/
              2, \[IndentingNewLine]p4 . p5 \[Rule] \((s45 - p4s - p5s)\)/
              2, \[IndentingNewLine]p1 . p5 \[Rule] \((s15 - p1s - p5s)\)/
              2, \[IndentingNewLine]p3 . 
              p5 \[Rule] \((s12 - s34 - s45 + p4s)\)/
              2, \[IndentingNewLine]p1 . 
              p4 \[Rule] \((s23 - s15 - s45 + p5s)\)/
              2, \[IndentingNewLine]p2 . 
              p5 \[Rule] \((s34 - s12 - s15 + p1s)\)/
              2, \[IndentingNewLine]p1 . 
              p3 \[Rule] \((s45 - s12 - s23 + p2s)\)/
              2, \[IndentingNewLine]p2 . 
              p4 \[Rule] \((s15 - s23 - s34 + p3s)\)/
              2};\)\), "\[IndentingNewLine]", 
    \(\(chords = {\[IndentingNewLine]\t
          q[n_, 1] \[Rule] p1[n], \[IndentingNewLine]\t
          q[n_, 2] \[Rule] p1[n] + p2[n], \[IndentingNewLine]\t
          q[n_, 3] \[Rule] p1[n] + p2[n] + p3[n], \[IndentingNewLine]\t
          q[n_, 4] \[Rule] p1[n] + p2[n] + p3[n] + p4[n]};\)\)}], "Input"],

Cell[CellGroupData[{

Cell["1) Comparison with AMBRE & MB.m", "Subsection",
  CellFrame->{{0, 0}, {0.5, 0}}],

Cell[BoxData[
    \( (*\ p1s = p1^2\ *) \)], "Input"],

Cell[BoxData[{
    \(\(p1s = \(p2s = \(p3s = \(p5s = 1\)\)\);\)\), "\[IndentingNewLine]", 
    \(\(p4s = 0;\)\), "\[IndentingNewLine]", 
    \(\(s12 = \(-3\);\)\), "\[IndentingNewLine]", 
    \(\(s23 = \(-6\);\)\), "\[IndentingNewLine]", 
    \(\(s34 = \(-5\);\)\), "\[IndentingNewLine]", 
    \(\(s45 = \(-7\);\)\), "\[IndentingNewLine]", 
    \(\(s15 = \(-2\);\)\), "\[IndentingNewLine]", 
    \(\(m1s = \(m3s = 0\);\)\), "\[IndentingNewLine]", 
    \(\(m2s = \(m4s = \(m5s = 1\)\);\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ex1 = 
      RedE3[p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, m3s, 
          m4s, m5s] /. {D4 \[Rule] D0, C3 \[Rule] C0, 
          B2 \[Rule] B0}\)], "Input"],

Cell[BoxData[
    \(\((\(\(0.004916565079209787`\)\(\[InvisibleSpace]\)\) - 
            1.0509030648219643`*^-16\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          1]\ q[mu3, 
          1] + \((\(\(0.0010376018078038566`\)\(\[InvisibleSpace]\)\) + 
            2.1946570028410498`*^-17\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          1]\ q[mu3, 
          1] + \((\(\(0.0017221243707031893`\)\(\[InvisibleSpace]\)\) - 
            4.663646131037231`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          1]\ q[mu3, 
          1] + \((\(\(0.0023949735959220733`\)\(\[InvisibleSpace]\)\) + 
            3.7351373990660174`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          1]\ q[mu3, 
          1] + \((\(\(0.0010376018078038566`\)\(\[InvisibleSpace]\)\) + 
            2.1946570028410498`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          2]\ q[mu3, 
          1] + \((\(\(0.0030138839094356155`\)\(\[InvisibleSpace]\)\) + 
            2.4216533048310295`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          2]\ q[mu3, 
          1] - \((\(\(0.000047948973986148606`\)\(\[InvisibleSpace]\)\) - 
            1.1007531730391259`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          2]\ q[mu3, 
          1] + \((\(\(0.000755390763662645`\)\(\[InvisibleSpace]\)\) - 
            1.4503024822893768`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          2]\ q[mu3, 
          1] + \((\(\(0.0017221243707031893`\)\(\[InvisibleSpace]\)\) - 
            4.663646131037231`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          3]\ q[mu3, 
          1] - \((\(\(0.000047948973986148606`\)\(\[InvisibleSpace]\)\) - 
            1.1007531730391259`*^-17\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          3]\ q[mu3, 
          1] + \((\(\(0.0008313841430618305`\)\(\[InvisibleSpace]\)\) - 
            1.7579799735409162`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          3]\ q[mu3, 
          1] + \((\(\(0.0005838265665950301`\)\(\[InvisibleSpace]\)\) + 
            2.4022225818930243`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          3]\ q[mu3, 
          1] + \((\(\(0.0023949735959220733`\)\(\[InvisibleSpace]\)\) + 
            3.7351373990660174`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          4]\ q[mu3, 
          1] + \((\(\(0.000755390763662645`\)\(\[InvisibleSpace]\)\) - 
            1.4503024822893768`*^-17\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          4]\ q[mu3, 
          1] + \((\(\(0.0005838265665950301`\)\(\[InvisibleSpace]\)\) + 
            2.4022225818930243`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          4]\ q[mu3, 
          1] + \((\(\(0.0016008711784235327`\)\(\[InvisibleSpace]\)\) - 
            1.994907210582331`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          4]\ q[mu3, 
          1] - \((\(\(0.006907184617717087`\)\(\[InvisibleSpace]\)\) - 
            3.9067538815634354`*^-17\ \[ImaginaryI])\)\ \((g[mu2, mu3]\ q[
                mu1, 1] + g[mu3, mu1]\ q[mu2, 1] + 
            g[mu1, mu2]\ q[mu3, 
                1])\) + \
\((\(\(0.0010376018078038566`\)\(\[InvisibleSpace]\)\) + 
            2.1946570028410498`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          1]\ q[mu3, 
          2] + \((\(\(0.0030138839094356155`\)\(\[InvisibleSpace]\)\) + 
            2.4216533048310295`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          1]\ q[mu3, 
          2] - \((\(\(0.000047948973986148606`\)\(\[InvisibleSpace]\)\) - 
            1.1007531730391259`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          1]\ q[mu3, 
          2] + \((\(\(0.000755390763662645`\)\(\[InvisibleSpace]\)\) - 
            1.4503024822893768`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          1]\ q[mu3, 
          2] + \((\(\(0.0030138839094356155`\)\(\[InvisibleSpace]\)\) + 
            2.4216533048310295`*^-18\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          2]\ q[mu3, 
          2] - \((\(\(0.048525484538938374`\)\(\[InvisibleSpace]\)\) + 
            7.661952259547354`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          2]\ q[mu3, 
          2] + \((\(\(0.0032692689026795944`\)\(\[InvisibleSpace]\)\) - 
            8.78345563432566`*^-19\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 2]\ q[
          mu3, 2] + \((\(\(0.002217060628608321`\)\(\[InvisibleSpace]\)\) + 
            4.0145850893612765`*^-18\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          2]\ q[mu3, 
          2] - \((\(\(0.000047948973986148606`\)\(\[InvisibleSpace]\)\) - 
            1.1007531730391259`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          3]\ q[mu3, 
          2] + \((\(\(0.0032692689026795944`\)\(\[InvisibleSpace]\)\) - 
            8.78345563432566`*^-19\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 3]\ q[
          mu3, 2] + \((\(\(0.0004442784395008639`\)\(\[InvisibleSpace]\)\) + 
            4.3890857963479444`*^-18\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          3]\ q[mu3, 
          2] - \((\(\(0.0000335819254334138`\)\(\[InvisibleSpace]\)\) + 
            7.530287726589833`*^-18\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          3]\ q[mu3, 
          2] + \((\(\(0.000755390763662645`\)\(\[InvisibleSpace]\)\) - 
            1.4503024822893768`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          4]\ q[mu3, 
          2] + \((\(\(0.002217060628608321`\)\(\[InvisibleSpace]\)\) + 
            4.0145850893612765`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          4]\ q[mu3, 
          2] - \((\(\(0.0000335819254334138`\)\(\[InvisibleSpace]\)\) + 
            7.530287726589833`*^-18\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          4]\ q[mu3, 
          2] + \((\(\(0.0014093642466815955`\)\(\[InvisibleSpace]\)\) + 
            3.6357805687573174`*^-18\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          4]\ q[mu3, 
          2] - \((\(\(0.009327784187438974`\)\(\[InvisibleSpace]\)\) + 
            3.2424717367811936`*^-18\ \[ImaginaryI])\)\ \((g[mu2, mu3]\ q[
                mu1, 2] + g[mu3, mu1]\ q[mu2, 2] + 
            g[mu1, mu2]\ q[mu3, 
                2])\) + \
\((\(\(0.0017221243707031893`\)\(\[InvisibleSpace]\)\) - 
            4.663646131037231`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          1]\ q[mu3, 
          3] - \((\(\(0.000047948973986148606`\)\(\[InvisibleSpace]\)\) - 
            1.1007531730391259`*^-17\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          1]\ q[mu3, 
          3] + \((\(\(0.0008313841430618305`\)\(\[InvisibleSpace]\)\) - 
            1.7579799735409162`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          1]\ q[mu3, 
          3] + \((\(\(0.0005838265665950301`\)\(\[InvisibleSpace]\)\) + 
            2.4022225818930243`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          1]\ q[mu3, 
          3] - \((\(\(0.000047948973986148606`\)\(\[InvisibleSpace]\)\) - 
            1.1007531730391259`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          2]\ q[mu3, 
          3] + \((\(\(0.0032692689026795944`\)\(\[InvisibleSpace]\)\) - 
            8.78345563432566`*^-19\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 2]\ q[
          mu3, 3] + \((\(\(0.0004442784395008639`\)\(\[InvisibleSpace]\)\) + 
            4.3890857963479444`*^-18\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          2]\ q[mu3, 
          3] - \((\(\(0.0000335819254334138`\)\(\[InvisibleSpace]\)\) + 
            7.530287726589833`*^-18\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          2]\ q[mu3, 
          3] + \((\(\(0.0008313841430618305`\)\(\[InvisibleSpace]\)\) - 
            1.7579799735409162`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          3]\ q[mu3, 
          3] + \((\(\(0.0004442784395008639`\)\(\[InvisibleSpace]\)\) + 
            4.3890857963479444`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          3]\ q[mu3, 
          3] + \((\(\(0.0010124461925073898`\)\(\[InvisibleSpace]\)\) - 
            4.1631212226312565`*^-18\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          3]\ q[mu3, 
          3] - \((\(\(0.0003312828171654297`\)\(\[InvisibleSpace]\)\) - 
            1.6086607108402643`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          3]\ q[mu3, 
          3] + \((\(\(0.0005838265665950301`\)\(\[InvisibleSpace]\)\) + 
            2.4022225818930243`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          4]\ q[mu3, 
          3] - \((\(\(0.0000335819254334138`\)\(\[InvisibleSpace]\)\) + 
            7.530287726589833`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          4]\ q[mu3, 
          3] - \((\(\(0.0003312828171654297`\)\(\[InvisibleSpace]\)\) - 
            1.6086607108402643`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          4]\ q[mu3, 
          3] - \((\(\(0.00025410637194058134`\)\(\[InvisibleSpace]\)\) + 
            1.0023781980745657`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          4]\ q[mu3, 
          3] - \((\(\(0.00529935185412408`\)\(\[InvisibleSpace]\)\) - 
            2.1534583257977832`*^-17\ \[ImaginaryI])\)\ \((g[mu2, mu3]\ q[
                mu1, 3] + g[mu3, mu1]\ q[mu2, 3] + 
            g[mu1, mu2]\ q[mu3, 
                3])\) + \
\((\(\(0.0023949735959220733`\)\(\[InvisibleSpace]\)\) + 
            3.7351373990660174`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          1]\ q[mu3, 
          4] + \((\(\(0.000755390763662645`\)\(\[InvisibleSpace]\)\) - 
            1.4503024822893768`*^-17\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          1]\ q[mu3, 
          4] + \((\(\(0.0005838265665950301`\)\(\[InvisibleSpace]\)\) + 
            2.4022225818930243`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          1]\ q[mu3, 
          4] + \((\(\(0.0016008711784235327`\)\(\[InvisibleSpace]\)\) - 
            1.994907210582331`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          1]\ q[mu3, 
          4] + \((\(\(0.000755390763662645`\)\(\[InvisibleSpace]\)\) - 
            1.4503024822893768`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          2]\ q[mu3, 
          4] + \((\(\(0.002217060628608321`\)\(\[InvisibleSpace]\)\) + 
            4.0145850893612765`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          2]\ q[mu3, 
          4] - \((\(\(0.0000335819254334138`\)\(\[InvisibleSpace]\)\) + 
            7.530287726589833`*^-18\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          2]\ q[mu3, 
          4] + \((\(\(0.0014093642466815955`\)\(\[InvisibleSpace]\)\) + 
            3.6357805687573174`*^-18\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          2]\ q[mu3, 
          4] + \((\(\(0.0005838265665950301`\)\(\[InvisibleSpace]\)\) + 
            2.4022225818930243`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          3]\ q[mu3, 
          4] - \((\(\(0.0000335819254334138`\)\(\[InvisibleSpace]\)\) + 
            7.530287726589833`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          3]\ q[mu3, 
          4] - \((\(\(0.0003312828171654297`\)\(\[InvisibleSpace]\)\) - 
            1.6086607108402643`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          3]\ q[mu3, 
          4] - \((\(\(0.00025410637194058134`\)\(\[InvisibleSpace]\)\) + 
            1.0023781980745657`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          3]\ q[mu3, 
          4] + \((\(\(0.0016008711784235327`\)\(\[InvisibleSpace]\)\) - 
            1.994907210582331`*^-17\ \[ImaginaryI])\)\ q[mu1, 1]\ q[mu2, 
          4]\ q[mu3, 
          4] + \((\(\(0.0014093642466815955`\)\(\[InvisibleSpace]\)\) + 
            3.6357805687573174`*^-18\ \[ImaginaryI])\)\ q[mu1, 2]\ q[mu2, 
          4]\ q[mu3, 
          4] - \((\(\(0.00025410637194058134`\)\(\[InvisibleSpace]\)\) + 
            1.0023781980745657`*^-17\ \[ImaginaryI])\)\ q[mu1, 3]\ q[mu2, 
          4]\ q[mu3, 
          4] + \((\(\(0.0018739951120385475`\)\(\[InvisibleSpace]\)\) + 
            2.1708367920600507`*^-17\ \[ImaginaryI])\)\ q[mu1, 4]\ q[mu2, 
          4]\ q[mu3, 
          4] - \((\(\(0.006121521496639517`\)\(\[InvisibleSpace]\)\) + 
            8.667620252163417`*^-18\ \[ImaginaryI])\)\ \((g[mu2, mu3]\ q[mu1, 
                4] + g[mu3, mu1]\ q[mu2, 4] + 
            g[mu1, mu2]\ q[mu3, 4])\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Contraction\ *) \)], "Input"],

Cell[BoxData[
    \(\(num = p1[mu1]*p2[mu2]*p3[mu3];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(Expand[num*ex1 /. chords] /. p_[_]^2 \[Rule] p . p\) /. 
          g[mu1_, mu2_]*p_[mu2_] \[Rule] p[mu1]\) //. 
        pa_[n_]*pb_[n_] \[Rule] pa . pb\) /. kinematics\)], "Input"],

Cell[BoxData[
    \(\(\(0.21874147801786514`\)\(\[InvisibleSpace]\)\) + 
      2.924988423565353`*^-16\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ \[IndentingNewLine]\(Output\ of\ AMBRE\  &\)\ MB . 
            m\ \[IndentingNewLine]\[IndentingNewLine]0.21888490099015612`\
\[InvisibleSpace] + 
        0.08324642046370305`\/eps\ \[IndentingNewLine]\[IndentingNewLine]*) \
\)], "Input"],

Cell[BoxData[
    \(\(num = p1[mu1]*p1[mu2]*p1[mu3];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(Expand[num*ex1 /. chords] /. 
            g[mu1_, mu2_]*p_[mu2_] \[Rule] p[mu1]\) //. 
          pa_[n_]*pb_[n_] \[Rule] pa . pb\) /. p_[_]^2 \[Rule] p . p\) /. 
      kinematics\)], "Input"],

Cell[BoxData[
    \(\(\(0.20842591457512613`\)\(\[InvisibleSpace]\)\) + 
      3.2633701214269506`*^-16\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ \[IndentingNewLine]\(Output\ of\ AMBRE\  &\)\ MB . 
            m\ \[IndentingNewLine]\[IndentingNewLine]0.20857125145140046`\
\[InvisibleSpace] + 
        0.04994785227822184`\/eps\[IndentingNewLine]\[IndentingNewLine]*) \
\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2) Comparison with LoopTools", "Subsection"],

Cell[BoxData[{
    \(\(p1s = \(p2s = 0\);\)\), "\[IndentingNewLine]", 
    \(\(p3s = \(p5s = 49/256\);\)\), "\[IndentingNewLine]", 
    \(\(p4s = 9/100;\)\), "\[IndentingNewLine]", 
    \(\(s12 = 4;\)\), "\[IndentingNewLine]", 
    \(\(s23 = \(-1\)/5;\)\), "\[IndentingNewLine]", 
    \(\(s34 = 1/5;\)\), "\[IndentingNewLine]", 
    \(\(s45 = 3/10;\)\), "\[IndentingNewLine]", 
    \(\(s15 = \(-1\)/2;\)\), "\[IndentingNewLine]", 
    \(\(m1s = \(m2s = \(m3s = 49/256\)\);\)\), "\[IndentingNewLine]", 
    \(\(m4s = \(m5s = 81/1600\);\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedE0[p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, m3s, 
        m4s, m5s] /. D4 \[Rule] D0\)], "Input"],

Cell[BoxData[
    \(\(\(41.34025332219323`\)\(\[InvisibleSpace]\)\) - 
      45.972082569597724`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(E0[p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, m3s, 
      m4s, m5s]\)], "Input"],

Cell[BoxData[
    \(\(\(41.34025332219332`\)\(\[InvisibleSpace]\)\) - 
      45.97208256959772`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (**) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedEget[rank1, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, 
        m2s, m3s, m4s, m5s] /. D4 \[Rule] D0\)], "Input"],

Cell[BoxData[
    \({ee1 \[Rule] \(-2.386045020740952`\) + 
          5.27599043316882`\ \[ImaginaryI], 
      ee2 \[Rule] \(-5.808754181197259`\) + 
          0.5978911441137024`\ \[ImaginaryI], 
      ee3 \[Rule] \(-14.493075099629046`\) + 
          20.814925638013552`\ \[ImaginaryI], 
      ee4 \[Rule] \(-11.336168767476405`\) + 
          18.159305635638773`\ \[ImaginaryI]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[
      Eget[p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, m3s, 
        m4s, m5s], {2, 3, 4, 5}]\)], "Input"],

Cell[BoxData[
    \({ee1 \[Rule] \(-2.386045020740961`\) + 
          5.275990433168849`\ \[ImaginaryI], 
      ee2 \[Rule] \(-5.80875418119712`\) + 
          0.5978911441136757`\ \[ImaginaryI], 
      ee3 \[Rule] \(-14.493075099629092`\) + 
          20.814925638013623`\ \[ImaginaryI], 
      ee4 \[Rule] \(-11.33616876747646`\) + 
          18.159305635638713`\ \[ImaginaryI]}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (**) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedEcoef[ee34, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, 
        m2s, m3s, m4s, m5s] /. {D4 \[Rule] D0, C3 \[Rule] C0}\)], "Input"],

Cell[BoxData[
    \(\(\(7.19639869763328`\)\(\[InvisibleSpace]\)\) + 
      3.101152974144986`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(E0i[ee34, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, 
      m3s, m4s, m5s]\)], "Input"],

Cell[BoxData[
    \(\(\(7.196398697633282`\)\(\[InvisibleSpace]\)\) + 
      3.101152974144993`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (**) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedEcoef[ee123, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, 
        m2s, m3s, m4s, m5s] /. {D4 \[Rule] D0, C3 \[Rule] C0, 
        B2 \[Rule] B0}\)], "Input"],

Cell[BoxData[
    \(\(-0.14952723300617238`\) - 
      0.31058981560636706`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(E0i[ee123, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, 
      m3s, m4s, m5s]\)], "Input"],

Cell[BoxData[
    \(\(-0.1495272330061167`\) - 
      0.31058981560637133`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (**) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedEcoef[ee002, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, 
        m2s, m3s, m4s, m5s] /. {D4 \[Rule] D0, C3 \[Rule] C0, 
        B2 \[Rule] B0}\)], "Input"],

Cell[BoxData[
    \(\(\(0.15451656084876883`\)\(\[InvisibleSpace]\)\) - 
      0.3877274345974905`\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(E0i[ee002, p1s, p2s, p3s, p4s, p5s, s12, s23, s34, s45, s15, m1s, m2s, 
      m3s, m4s, m5s]\)], "Input"],

Cell[BoxData[
    \(\(\(0.15451656084877652`\)\(\[InvisibleSpace]\)\) - 
      0.38772743459749204`\ \[ImaginaryI]\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 800}},
WindowSize->{1270, 747},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 45, 1, 27, "Input"],
Cell[1824, 56, 82, 1, 39, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1943, 62, 57, 1, 27, "Input"],
Cell[2003, 65, 65, 1, 27, "Output"]
}, Open  ]],
Cell[2083, 69, 89, 1, 27, "Input"],
Cell[2175, 72, 1382, 24, 283, "Input"],

Cell[CellGroupData[{
Cell[3582, 100, 86, 1, 46, "Subsection"],
Cell[3671, 103, 53, 1, 27, "Input"],
Cell[3727, 106, 500, 9, 155, "Input"],

Cell[CellGroupData[{
Cell[4252, 119, 197, 4, 27, "Input"],
Cell[4452, 125, 11814, 208, 758, "Output"]
}, Open  ]],
Cell[16281, 336, 54, 1, 27, "Input"],
Cell[16338, 339, 67, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[16430, 344, 206, 3, 27, "Input"],
Cell[16639, 349, 131, 2, 30, "Output"]
}, Open  ]],
Cell[16785, 354, 264, 5, 123, "Input"],
Cell[17052, 361, 67, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[17144, 366, 217, 4, 27, "Input"],
Cell[17364, 372, 132, 2, 30, "Output"]
}, Open  ]],
Cell[17511, 377, 262, 5, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17810, 387, 50, 0, 38, "Subsection"],
Cell[17863, 389, 550, 10, 171, "Input"],

Cell[CellGroupData[{
Cell[18438, 403, 139, 2, 27, "Input"],
Cell[18580, 407, 125, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18742, 414, 117, 2, 27, "Input"],
Cell[18862, 418, 124, 2, 27, "Output"]
}, Open  ]],
Cell[19001, 423, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[19065, 428, 148, 2, 27, "Input"],
Cell[19216, 432, 395, 8, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19648, 445, 148, 3, 27, "Input"],
Cell[19799, 450, 394, 8, 27, "Output"]
}, Open  ]],
Cell[20208, 461, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[20272, 466, 165, 2, 27, "Input"],
Cell[20440, 470, 123, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20600, 477, 124, 2, 27, "Input"],
Cell[20727, 481, 124, 2, 27, "Output"]
}, Open  ]],
Cell[20866, 486, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[20930, 491, 190, 3, 27, "Input"],
Cell[21123, 496, 104, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21264, 503, 125, 2, 27, "Input"],
Cell[21392, 507, 103, 2, 27, "Output"]
}, Open  ]],
Cell[21510, 512, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[21574, 517, 190, 3, 27, "Input"],
Cell[21767, 522, 127, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21931, 529, 125, 2, 27, "Input"],
Cell[22059, 533, 128, 2, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

