(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    139094,       2882]*)
(*NotebookOutlinePosition[    139722,       2904]*)
(*  CellTagsIndexPosition[    139678,       2900]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(<< hexagon.m\)], "Input"],

Cell[BoxData[
    \("by K.Kajda, ver: 1.0\nlast modified 19 sep 2008"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Install["\<LoopTools\>"]\)], "Input"],

Cell[BoxData[
    \(LinkObject["./LoopTools", 2, 2]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1) Comparison with Sector Decomposition (Table 2 of arxiv: \
0807.2984)\
\>", "Subsection",
  CellFrame->{{0, 0}, {0.5, 0}}],

Cell[BoxData[{
    \(\(p1s = \(p2s = \(p3s = \(p4s = \(p5s = \(p6s = \(-1\)\)\)\)\)\);\)\), \
"\[IndentingNewLine]", 
    \(\(s12 = \(s23 = \(s34 = \(s45 = \(s56 = \(s16 = \(s123 = \(s234 = \
\(-1\)\)\)\)\)\)\)\);\)\), "\[IndentingNewLine]", 
    \(\(s345 = \(-5\)/2;\)\), "\[IndentingNewLine]", 
    \(\(m1s = \(m2s = \(m3s = \(m4s = \(m5s = \(m6s = 
                  1\)\)\)\)\);\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedF0[p1s, p2s, p3s, p4s, p5s, p6s, s12, s23, s34, s45, s56, s16, s123, 
        s234, s345, m1s, m2s, m3s, m4s, m5s, m6s] /. D4 \[Rule] D0\)], "Input"],

Cell[BoxData[
    \(\(\(0.013526026895489963`\)\(\[InvisibleSpace]\)\) + 
      3.4082264211967624`*^-15\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\[IndentingNewLine]Output\ from\ Sector\ Decomposition\ \(arXiv : \ 
          0709.4092\[IndentingNewLine]\[IndentingNewLine]
        0.0135251\)\[IndentingNewLine]\[IndentingNewLine]*) \)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2) Results of Table 4 (arxiv: 0807.2984)", "Subsection",
  CellFrame->{{0, 0}, {0.5, 0}}],

Cell[BoxData[{
    \(p1s := p11*p11 - p12*p12 - p13*p13 - p14*p14\), "\n", 
    \(p2s := p21*p21 - p22*p22 - p23*p23 - p24*p24\), "\n", 
    \(p3s := p31*p31 - p32*p32 - p33*p33 - p34*p34\), "\n", 
    \(p4s := p41*p41 - p42*p42 - p43*p43 - p44*p44\), "\n", 
    \(p5s := p51*p51 - p52*p52 - p53*p53 - p54*p54\), "\n", 
    \(\(\(p6s := 
      p61*p61 - p62*p62 - p63*p63 - 
        p64*p64\)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\( (*\(Two\ \
momenta\ IN\ going\  &\)\ four\ momenta\ OUT\ going ... *) \)\(\
\[IndentingNewLine]\)
    \)\), "\n", 
    \(s12 := \((p11 + p21)\)^2 - \((p12 + p22)\)^2 - \((p13 + 
              p23)\)^2 - \((p14 + p24)\)^2\), "\n", 
    \(s23 := \((p21 - p31)\)^2 - \((p22 - p32)\)^2 - \((p23 - 
              p33)\)^2 - \((p24 - p34)\)^2\), "\n", 
    \(s34 := \((p31 + p41)\)^2 - \((p32 + p42)\)^2 - \((p33 + 
              p43)\)^2 - \((p34 + p44)\)^2\), "\n", 
    \(s45 := \((p41 + p51)\)^2 - \((p42 + p52)\)^2 - \((p43 + 
              p53)\)^2 - \((p44 + p54)\)^2\), "\n", 
    \(s56 := \((p51 + p61)\)^2 - \((p52 + p62)\)^2 - \((p53 + 
              p63)\)^2 - \((p54 + p64)\)^2\), "\n", 
    \(s16 := \((p11 - p61)\)^2 - \((p12 - p62)\)^2 - \((p13 - 
              p63)\)^2 - \((p14 - p64)\)^2\), "\n", 
    \(s123 := \((p11 + p21 - p31)\)^2 - \((p12 + p22 - p32)\)^2 - \((p13 + 
              p23 - p33)\)^2 - \((p14 + p24 - p34)\)^2\), "\n", 
    \(s234 := \((p21 - p31 - p41)\)^2 - \((p22 - p32 - p42)\)^2 - \((p23 - 
              p33 - p43)\)^2 - \((p24 - p34 - p44)\)^2\), "\n", 
    \(\(\(s345 := \((p31 + p41 + p51)\)^2 - \((p32 + p42 + 
              p52)\)^2 - \((p33 + p43 + p53)\)^2 - \((p34 + p44 + 
              p54)\)^2\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(chords := {q[n_, 0] \[Rule] 0, q[n_, 1] \[Rule] p1[n], 
        q[n_, 2] \[Rule] p1[n] + p2[n], 
        q[n_, 3] \[Rule] p1[n] + p2[n] - p3[n], 
        q[n_, 4] \[Rule] p1[n] + p2[n] - p3[n] - p4[n], 
        q[n_, 5] \[Rule] p1[n] + p2[n] - p3[n] - p4[n] - p5[n]}\)}], "Input"],

Cell[BoxData[{
    \(\(p11 = 0.217745543033608*10^3;\)\), "\n", 
    \(\(p12 = 0. ;\)\), "\n", 
    \(\(p13 = 0. ;\)\), "\n", 
    \(\(\(p14 = 0.217745543033608*10^3;\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(p21 = 0.217745543033608*10^3;\)\), "\n", 
    \(\(p22 = 0. ;\)\), "\n", 
    \(\(p23 = 0. ;\)\), "\n", 
    \(\(\(p24 = \(-0.217745543033608\)*10^3;\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(p31 = 0.203694145606766*10^3;\)\), "\n", 
    \(\(p32 = 0.475795122438478*10^2;\)\), "\n", 
    \(\(p33 = \(-0.421268225217969\)*10^2;\)\), "\n", 
    \(\(\(p34 = \(-0.840971806502753\)*10^2;\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(p41 = 0.209072365894312*10^3;\)\), "\n", 
    \(\(p42 = \(-0.552159614718998\)*10^2;\)\), "\n", 
    \(\(p43 = 0.466920343021516*10^2;\)\), "\n", 
    \(\(\(p44 = 0.900100867242416*10^2;\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(p51 = 0.684633076491974*10^1;\)\), "\n", 
    \(\(p52 = \(-0.530631952055453\)*10^1;\)\), "\n", 
    \(\(p53 = \(-0.296982674372730\)*10^1;\)\), "\n", 
    \(\(\(p54 = 0.314568707927384*10^1;\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(p61 = 0.158782438012184*10^2;\)\), "\n", 
    \(\(p62 = 0.129427687486066*10^2;\)\), "\n", 
    \(\(p63 = \(-0.159538503662741\)*10^1;\)\), "\n", 
    \(\(\(p64 = \(-0.905859315324015\)*10^1;\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(M1 = 110. ;\)\), "\n", 
    \(\(M2 = 120. ;\)\), "\n", 
    \(\(M3 = 130. ;\)\), "\n", 
    \(\(M4 = 140. ;\)\), "\n", 
    \(\(M5 = 150. ;\)\), "\n", 
    \(\(M6 = 160. ;\)\)}], "Input"],

Cell[CellGroupData[{

Cell["SCALAR", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RedF0[p1s, p2s, p3s, p4s, p5s, p6s, s12, s23, s34, s45, s56, s16, s123, 
        s234, s345, M1^2, M2^2, M3^2, M4^2, M5^2, M6^2] /. 
      D4 \[Rule] D0\)], "Input"],

Cell[BoxData[
    \(\(-2.2339286433538327`*^-19\) - 
      3.967282130110251`*^-20\ \[ImaginaryI]\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VECTOR", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vect = \(RedF1[p1s, p2s, p3s, p4s, p5s, p6s, s12, s23, s34, s45, s56, 
              s16, s123, s234, s345, M1^2, M2^2, M3^2, M4^2, M5^2, M6^2] /. 
            D4 \[Rule] D0\) /. chords // Expand\)], "Input"],

Cell[BoxData[
    \(\((3.514906220305243`*^-20 + 
            3.1856850378025224`*^-20\ \[ImaginaryI])\)\ p1[
          mu1] - \((4.514933228607369`*^-20 - 
            2.5748322596447864`*^-20\ \[ImaginaryI])\)\ p2[
          mu1] - \((2.76069843912362`*^-20 + 
            1.9224069468935224`*^-20\ \[ImaginaryI])\)\ p3[
          mu1] + \((4.884857480351297`*^-20 + 
            5.358097760215935`*^-21\ \[ImaginaryI])\)\ p4[
          mu1] - \((7.115027588907118`*^-20 + 
            3.1145528971090874`*^-21\ \[ImaginaryI])\)\ p5[mu1]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
      Ind[i - 1] \[Rule] \((vect /. {p_[mu1] :> 
                ToExpression[ToString[p] <> ToString[i]]})\), {i, 1, 
        4}]\)], "Input"],

Cell[BoxData[
    \({Ind[0] \[Rule] 
        1.924873443921467`*^-18 + 9.726346181414596`*^-18\ \[ImaginaryI], 
      Ind[1] \[Rule] \(-3.633201778323507`*^-18\) - 
          1.1939975553288103`*^-18\ \[ImaginaryI], 
      Ind[2] \[Rule] 
        3.65513785430741`*^-18 + 1.0692791295674006`*^-18\ \[ImaginaryI], 
      Ind[3] \[Rule] 
        2.3979335017189547`*^-17 + 
          3.4192801771657803`*^-18\ \[ImaginaryI]}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TENSOR 2nd ORDER", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tens2nd = \(RedF2[p1s, p2s, p3s, p4s, p5s, p6s, s12, s23, s34, s45, 
              s56, s16, s123, s234, s345, M1^2, M2^2, M3^2, M4^2, M5^2, 
              M6^2] /. D4 \[Rule] D0\) /. chords // Expand\)], "Input"],

Cell[BoxData[
    \(\((\(-5.42137731306424`*^-19\) - 
            6.38936438349934`*^-20\ \[ImaginaryI])\)\ p1[mu1]\ p1[
          mu2] - \((4.966922645361944`*^-19 + 
            5.96547258886656`*^-20\ \[ImaginaryI])\)\ p1[mu2]\ p2[
          mu1] - \((4.966922645361998`*^-19 + 
            5.96547258886654`*^-20\ \[ImaginaryI])\)\ p1[mu1]\ p2[
          mu2] - \((5.742669975468733`*^-19 + 
            4.596954172128032`*^-20\ \[ImaginaryI])\)\ p2[mu1]\ p2[
          mu2] + \((5.622605321479359`*^-19 + 
            5.2162990913831526`*^-20\ \[ImaginaryI])\)\ p1[mu2]\ p3[
          mu1] + \((6.63066120513429`*^-19 + 
            6.161230672058852`*^-20\ \[ImaginaryI])\)\ p2[mu2]\ p3[
          mu1] + \((5.622605321479478`*^-19 + 
            5.216299091383126`*^-20\ \[ImaginaryI])\)\ p1[mu1]\ p3[
          mu2] + \((6.630661205134364`*^-19 + 
            6.161230672058844`*^-20\ \[ImaginaryI])\)\ p2[mu1]\ p3[
          mu2] - \((7.507395723657778`*^-19 + 
            4.7257885858204886`*^-20\ \[ImaginaryI])\)\ p3[mu1]\ p3[
          mu2] + \((8.079915803831064`*^-19 + 
            4.691913713847519`*^-20\ \[ImaginaryI])\)\ p1[mu2]\ p4[
          mu1] + \((7.982422872757203`*^-19 + 
            4.6261280188581874`*^-20\ \[ImaginaryI])\)\ p2[mu2]\ p4[
          mu1] - \((7.970998220373102`*^-19 + 
            4.7094838716630275`*^-20\ \[ImaginaryI])\)\ p3[mu2]\ p4[
          mu1] + \((8.079915803831137`*^-19 + 
            4.6919137138475083`*^-20\ \[ImaginaryI])\)\ p1[mu1]\ p4[
          mu2] + \((7.98242287275723`*^-19 + 
            4.6261280188581947`*^-20\ \[ImaginaryI])\)\ p2[mu1]\ p4[
          mu2] - \((7.970998220373056`*^-19 + 
            4.709483871663042`*^-20\ \[ImaginaryI])\)\ p3[mu1]\ p4[
          mu2] - \((1.1971716046742887`*^-18 + 
            6.935059774664821`*^-20\ \[ImaginaryI])\)\ p4[mu1]\ p4[
          mu2] - \((3.902517090282072`*^-18 + 
            2.337326943046459`*^-19\ \[ImaginaryI])\)\ p1[mu2]\ p5[
          mu1] - \((4.1601510416535395`*^-18 + 
            2.4916746427712673`*^-19\ \[ImaginaryI])\)\ p2[mu2]\ p5[
          mu1] + \((4.62783091348272`*^-18 + 
            2.7666219785591724`*^-19\ \[ImaginaryI])\)\ p3[mu2]\ p5[
          mu1] + \((5.565492378204229`*^-18 + 
            3.3350594804749236`*^-19\ \[ImaginaryI])\)\ p4[mu2]\ p5[
          mu1] - \((3.902517090282074`*^-18 + 
            2.3373269430464617`*^-19\ \[ImaginaryI])\)\ p1[mu1]\ p5[
          mu2] - \((4.1601510416535395`*^-18 + 
            2.4916746427712683`*^-19\ \[ImaginaryI])\)\ p2[mu1]\ p5[
          mu2] + \((4.627830913482721`*^-18 + 
            2.7666219785591714`*^-19\ \[ImaginaryI])\)\ p3[mu1]\ p5[
          mu2] + \((5.565492378204229`*^-18 + 
            3.3350594804749236`*^-19\ \[ImaginaryI])\)\ p4[mu1]\ p5[
          mu2] - \((5.003559202541373`*^-17 + 
            2.9883096397757294`*^-18\ \[ImaginaryI])\)\ p5[mu1]\ p5[
          mu2]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\(\(Ind[i - 1, j - 1] -> tens2nd /. {mu1 \[Rule] i, 
                mu2 \[Rule] j}\) /. 
            pa_[mua_]*pb_[mub_] \[RuleDelayed] 
              ToExpression[ToString[pa] <> ToString[mua]]*
                ToExpression[ToString[pb] <> ToString[mub]]\) /. 
          p_[mu_]^2 \[RuleDelayed] \((ToExpression[
                  ToString[p] <> ToString[mu]])\)^2, {i, 1, 4}, {j, i, 4}] // 
      Flatten\)], "Input"],

Cell[BoxData[
    \({Ind[0, 0] \[Rule] 
        5.9945948869227145`*^-15 - 1.1460141954089959`*^-15\ \[ImaginaryI], 
      Ind[0, 1] \[Rule] 
        3.2386920120800205`*^-16 + 4.23753553106693`*^-16\ \[ImaginaryI], 
      Ind[0, 2] \[Rule] \(-2.942523553603398`*^-16\) - 
          3.7548137732527405`*^-16\ \[ImaginaryI], 
      Ind[0, 3] \[Rule] \(-2.5545028035484725`*^-15\) - 
          1.956402642879093`*^-15\ \[ImaginaryI], 
      Ind[1, 1] \[Rule] \(-1.6456154497036714`*^-15\) - 
          9.937958280378317`*^-17\ \[ImaginaryI], 
      Ind[1, 2] \[Rule] 
        9.209442721862788`*^-17 + 7.064872417438374`*^-18\ \[ImaginaryI], 
      Ind[1, 3] \[Rule] 
        3.4769432177750473`*^-16 - 1.2719026843382119`*^-17\ \[ImaginaryI], 
      Ind[2, 2] \[Rule] \(-1.6333938670804743`*^-15\) - 
          9.941481994932443`*^-17\ \[ImaginaryI], 
      Ind[2, 3] \[Rule] \(-3.4177265938494324`*^-16\) + 
          8.186780890873067`*^-18\ \[ImaginaryI], 
      Ind[3, 3] \[Rule] \(-4.1390931761397385`*^-15\) + 
          6.70675823184836`*^-16\ \[ImaginaryI]}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TENSOR 3rd ORDER", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tens3rd = \(\(RedF3[p1s, p2s, p3s, p4s, p5s, p6s, s12, s23, s34, s45, 
                s56, s16, s123, s234, s345, M1^2, M2^2, M3^2, M4^2, M5^2, 
                M6^2] /. D4 \[Rule] D0\) /. C3 \[Rule] C0\) /. chords // 
        Expand\)], "Input"],

Cell[BoxData[
    \(\((7.771354015754585`*^-16 + 
            4.2129226576095615`*^-15\ \[ImaginaryI])\)\ g[mu1, mu2]\ p1[
          mu3] + \((8.800351352220942`*^-19 + 
            1.6224410543545763`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu3] + \((7.270312866638696`*^-19 + 
            1.6996740248849353`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu1] + \((7.270312860334219`*^-19 + 
            1.6996740249176237`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu2] + \((7.508894691944541`*^-19 + 
            1.966280286198073`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu2] + \((1.2689437170738607`*^-15 + 
            4.127761276783293`*^-15\ \[ImaginaryI])\)\ g[mu1, mu2]\ p2[
          mu3] + \((8.753452788360648`*^-19 + 
            1.5357589069612279`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu3] + \((8.142713397978142`*^-19 + 
            1.6244242979096102`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu3] + \((8.142713391704849`*^-19 + 
            1.6244242979441968`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu3] + \((8.868949941164708`*^-19 + 
            1.9473057065771086`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu3] - \((8.023876785999058`*^-19 + 
            1.6417427067042072`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p3[
          mu1] - \((8.811154289700227`*^-19 + 
            1.995803214984044`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p3[
          mu1] - \((9.040326460372722`*^-19 + 
            1.5885314983629315`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p3[
          mu1] - \((1.0262033639877356`*^-18 + 
            1.9719873372254154`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p3[
          mu1] - \((8.023876788682541`*^-19 + 
            1.641742706868167`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p3[
          mu2] - \((8.811154298610904`*^-19 + 
            1.9958032150977507`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p3[
          mu2] - \((9.040326462609759`*^-19 + 
            1.588531498635409`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p3[
          mu2] - \((1.0262033648309663`*^-18 + 
            1.971987337445828`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p3[
          mu2] + \((1.0280491810760568`*^-18 + 
            2.0991956579535022`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p3[
          mu2] + \((1.1940047553717872`*^-18 + 
            2.053499444810162`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p3[
          mu2] - \((1.1724249261350803`*^-15 + 
            4.628809386563706`*^-15\ \[ImaginaryI])\)\ g[mu1, mu2]\ p3[
          mu3] - \((1.0918443611306084`*^-18 + 
            1.7324843940452242`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p3[
          mu3] - \((1.0491086633920213`*^-18 + 
            1.861176420983708`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p3[
          mu3] - \((1.0491086627629294`*^-18 + 
            1.8611764210189107`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p3[
          mu3] - \((1.1240817266503051`*^-18 + 
            2.2211304095070964`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p3[
          mu3] + \((1.1432330984168254`*^-18 + 
            1.8320945690418753`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p3[
          mu3] + \((1.2721295386305137`*^-18 + 
            2.245031806745382`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p3[
          mu3] + \((1.1432330986556407`*^-18 + 
            1.8320945693269253`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p3[
          mu3] + \((1.272129539490366`*^-18 + 
            2.245031806977825`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p3[
          mu3] - \((1.4547818969439714`*^-18 + 
            2.331304269892572`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p3[
          mu3] - \((1.0521835372862834`*^-18 + 
            2.112383710284663`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p4[
          mu1] - \((8.453525267704411`*^-19 + 
            2.1944649083969435`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p4[
          mu1] - \((1.0913821128269817`*^-18 + 
            2.0259046378006075`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p4[
          mu1] - \((9.121122729787745`*^-19 + 
            2.119208153338933`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p4[
          mu1] + \((8.320644042002448`*^-19 + 
            2.020282562132785`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p4[
          mu1] + \((8.9796638294678`*^-19 + 
            1.950009096587183`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p4[
          mu1] + \((1.2799016054312943`*^-18 + 
            2.2643847824118103`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p4[
          mu1] + \((1.1111067813385129`*^-18 + 
            2.3789962624780756`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p4[
          mu1] - \((1.1133934923150602`*^-18 + 
            2.2418238719618574`*^-18\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p4[
          mu1] - \((1.0521835372804656`*^-18 + 
            2.11238371017654`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p4[
          mu2] - \((8.453525273851116`*^-19 + 
            2.1944649081928504`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p4[
          mu2] - \((1.0913821128799772`*^-18 + 
            2.0259046377787536`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p4[
          mu2] - \((9.121122736492816`*^-19 + 
            2.1192081532189154`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p4[
          mu2] + \((8.320644038964717`*^-19 + 
            2.02028256185587`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p4[
          mu2] + \((8.979663827468593`*^-19 + 
            1.9500090962865778`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p4[
          mu2] + \((1.2799016055003381`*^-18 + 
            2.2643847824152986`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p4[
          mu2] + \((1.1111067820266584`*^-18 + 
            2.378996262382451`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p4[
          mu2] - \((1.1133934921161687`*^-18 + 
            2.241823871673615`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p4[
          mu2] + \((1.1027512832516022`*^-18 + 
            2.773330256116202`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu1]\ p4[
          mu2] + \((1.174019832426308`*^-18 + 
            2.6922757251005544`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu1]\ p4[
          mu2] - \((1.390851053934961`*^-18 + 
            2.9594606396798645`*^-18\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu1]\ p4[
          mu2] - \((3.1530049003615062`*^-15 + 
            6.647724354593348`*^-15\ \[ImaginaryI])\)\ g[mu1, mu2]\ p4[
          mu3] - \((1.1894536227922096`*^-18 + 
            1.7704952188889078`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p4[
          mu3] - \((9.95684234874879`*^-19 + 
            1.8934133904012262`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p4[
          mu3] - \((9.956842342340159`*^-19 + 
            1.8934133904295204`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p4[
          mu3] - \((1.0552268945401387`*^-18 + 
            2.34490397184775`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p4[
          mu3] + \((1.0062437222929454`*^-18 + 
            1.7404751027475112`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p4[
          mu3] + \((1.1569210977770745`*^-18 + 
            2.309939255497812`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p4[
          mu3] + \((1.0062437224260006`*^-18 + 
            1.7404751030464094`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p4[
          mu3] + \((1.1569210985429336`*^-18 + 
            2.309939255751007`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p4[
          mu3] - \((1.3290190047252102`*^-18 + 
            2.4178036593177916`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p4[
          mu3] + \((1.3881635533761972`*^-18 + 
            2.5028052627543366`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu1]\ p4[
          mu3] + \((1.0781216443156607`*^-18 + 
            2.6186554162819908`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu1]\ p4[
          mu3] - \((1.0089501216308117`*^-18 + 
            2.2677269124022348`*^-18\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu1]\ p4[
          mu3] + \((1.3881635532883601`*^-18 + 
            2.50280526281021`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu2]\ p4[
          mu3] + \((1.0781216448582876`*^-18 + 
            2.6186554162458195`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu2]\ p4[
          mu3] - \((1.0089501213798407`*^-18 + 
            2.2677269121536234`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu2]\ p4[
          mu3] - \((1.4414001254339367`*^-18 + 
            3.4755772560785055`*^-18\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu2]\ p4[
          mu3] + \((9.683309189019324`*^-18 + 
            1.588517777767591`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p5[
          mu1] + \((9.218860233525989`*^-18 + 
            1.7145756724439553`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p5[
          mu1] + \((1.0166310375267837`*^-17 + 
            1.638409444841774`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p5[
          mu1] + \((9.648939597956707`*^-18 + 
            1.7707195253629784`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p5[
          mu1] - \((1.0202138855677639`*^-17 + 
            1.7781415292710198`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p5[
          mu1] - \((1.0673499572396068`*^-17 + 
            1.8325658063467012`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p5[
          mu1] - \((1.1134265372264513`*^-17 + 
            1.7661482310399948`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p5[
          mu1] - \((1.0523438522716249`*^-17 + 
            1.9077342709661668`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p5[
          mu1] + \((1.163086931405625`*^-17 + 
            1.9693047742589888`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p5[
          mu1] - \((1.040417985189015`*^-17 + 
            1.9390586080704137`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu2]\ p5[
          mu1] - \((1.0924990618760285`*^-17 + 
            1.9968591971457932`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu2]\ p5[
          mu1] + \((1.1712118016644985`*^-17 + 
            2.1160936675062278`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu2]\ p5[
          mu1] - \((1.3866142967603584`*^-17 + 
            2.2755980394196095`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu3]\ p5[
          mu1] - \((1.3250813099025098`*^-17 + 
            2.4621960783961917`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu3]\ p5[
          mu1] + \((1.4688420528939852`*^-17 + 
            2.5572135015827853`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu3]\ p5[
          mu1] + \((1.539262747020991`*^-17 + 
            2.8472644092964343`*^-17\ \[ImaginaryI])\)\ p4[mu2]\ p4[mu3]\ p5[
          mu1] + \((9.683309190319126`*^-18 + 
            1.5885177778629484`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p5[
          mu2] + \((9.21886023455549`*^-18 + 
            1.7145756725274698`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p5[
          mu2] + \((1.0166310376470345`*^-17 + 
            1.6384094449132103`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p5[
          mu2] + \((9.648939598889763`*^-18 + 
            1.7707195254225485`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p5[
          mu2] - \((1.0202138857123929`*^-17 + 
            1.7781415293672584`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p5[
          mu2] - \((1.0673499573689041`*^-17 + 
            1.8325658064225107`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p5[
          mu2] - \((1.1134265373295579`*^-17 + 
            1.766148231114547`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p5[
          mu2] - \((1.052343852347506`*^-17 + 
            1.9077342710289638`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p5[
          mu2] + \((1.1630869315193565`*^-17 + 
            1.9693047743380956`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p5[
          mu2] - \((1.0404179853268192`*^-17 + 
            1.939058608142783`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu1]\ p5[
          mu2] - \((1.0924990620033913`*^-17 + 
            1.9968591971944782`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu1]\ p5[
          mu2] + \((1.1712118017765272`*^-17 + 
            2.1160936675580856`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu1]\ p5[
          mu2] - \((1.3866142968535242`*^-17 + 
            2.2755980394635315`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu3]\ p5[
          mu2] - \((1.325081309968452`*^-17 + 
            2.4621960784283175`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu3]\ p5[
          mu2] + \((1.4688420529973303`*^-17 + 
            2.5572135016293974`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu3]\ p5[
          mu2] + \((1.5392627471207622`*^-17 + 
            2.847264409319528`*^-17\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu3]\ p5[
          mu2] + \((8.365533606302322`*^-17 + 
            1.2128062120829722`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p5[mu1]\ p5[
          mu2] + \((8.859585133130391`*^-17 + 
            1.2469330449859277`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p5[mu1]\ p5[
          mu2] - \((8.983687664081892`*^-17 + 
            1.2348963356454238`*^-16\ \[ImaginaryI])\)\ p3[mu3]\ p5[mu1]\ p5[
          mu2] - \((1.3471805819850596`*^-16 + 
            1.9556594908404323`*^-16\ \[ImaginaryI])\)\ p4[mu3]\ p5[mu1]\ p5[
          mu2] + \((1.8682509572591866`*^-14 + 
            2.2843927657625668`*^-14\ \[ImaginaryI])\)\ g[mu1, mu2]\ p5[
          mu3] + \((1.1589184711906392`*^-17 + 
            1.9310328400497218`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p5[
          mu3] + \((1.1010744056827274`*^-17 + 
            2.0542190475722843`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p5[
          mu3] + \((1.1010744056687957`*^-17 + 
            2.0542190475891213`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p5[
          mu3] + \((1.139036975410038`*^-17 + 
            2.3164528998914993`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p5[
          mu3] - \((1.1909941165088213`*^-17 + 
            2.125388560808728`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p5[
          mu3] - \((1.2562062009118379`*^-17 + 
            2.437297824857161`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p5[
          mu3] - \((1.1909941164816794`*^-17 + 
            2.125388560810951`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p5[
          mu3] - \((1.2562062008958337`*^-17 + 
            2.4372978248453215`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p5[
          mu3] + \((1.4180391043310727`*^-17 + 
            2.5964804379402267`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p5[
          mu3] - \((1.3776274296714853`*^-17 + 
            2.4939876457703538`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu1]\ p5[
          mu3] - \((1.2545433570324416`*^-17 + 
            2.624323236629973`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu1]\ p5[
          mu3] + \((1.3027735607490296`*^-17 + 
            2.637101451207798`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu1]\ p5[
          mu3] - \((1.3776274296894763`*^-17 + 
            2.493987645833993`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu2]\ p5[
          mu3] - \((1.2545433570615802`*^-17 + 
            2.6243232366794543`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu2]\ p5[
          mu3] + \((1.3027735607950892`*^-17 + 
            2.637101451264872`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu2]\ p5[
          mu3] + \((1.5315959414915137`*^-17 + 
            3.1496419437523116`*^-17\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu2]\ p5[
          mu3] + \((1.1674219841140916`*^-16 + 
            1.8005353964833665`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p5[mu1]\ p5[
          mu3] + \((1.0911901884244976`*^-16 + 
            1.9354031055350643`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p5[mu1]\ p5[
          mu3] - \((1.203294689976698`*^-16 + 
            1.9845888057219225`*^-16\ \[ImaginaryI])\)\ p3[mu2]\ p5[mu1]\ p5[
          mu3] - \((1.1153027205409855`*^-16 + 
            2.0087225107065724`*^-16\ \[ImaginaryI])\)\ p4[mu2]\ p5[mu1]\ p5[
          mu3] + \((1.1674219841164797`*^-16 + 
            1.8005353964892134`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p5[mu2]\ p5[
          mu3] + \((1.0911901884276295`*^-16 + 
            1.9354031055420141`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p5[mu2]\ p5[
          mu3] - \((1.2032946899780007`*^-16 + 
            1.984588805729117`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p5[mu2]\ p5[
          mu3] - \((1.1153027205449012`*^-16 + 
            2.0087225107147825`*^-16\ \[ImaginaryI])\)\ p4[mu1]\ p5[mu2]\ p5[
          mu3] + \((6.044381408721494`*^-16 + 
            8.020197766737157`*^-16\ \[ImaginaryI])\)\ p5[mu1]\ p5[mu2]\ p5[
          mu3]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\(\(\(\(\(Ind[i - 1, j - 1, k - 1] -> tens3rd /. 
                    g[mu1*mu2] \[Rule] g[mu1, mu2]\) /. {mu1 \[Rule] i, 
                    mu2 \[Rule] j, mu3 \[Rule] k}\) /. 
                p_[mu_] \[RuleDelayed] 
                  ToExpression[ToString[p] <> ToString[mu]]\) /. 
              g[1, 1] \[Rule] 1\) /. g[mu_, mu_] \[Rule] \(-1\)\) /. 
          g[mu_, nu_] \[Rule] 0, {i, 1, 4}, {j, i, 4}, {k, j, 4}] // 
      Flatten\)], "Input"],

Cell[BoxData[
    \({Ind[0, 0, 0] \[Rule] \(-2.277540680515194`*^-12\) - 
          2.6724435101873`*^-13\ \[ImaginaryI], 
      Ind[0, 0, 1] \[Rule] 
        1.4027124235946433`*^-14 - 1.1944843619590086`*^-13\ \[ImaginaryI], 
      Ind[0, 0, 2] \[Rule] \(-2.012704398100457`*^-14\) + 
          1.0196764632250666`*^-13\ \[ImaginaryI], 
      Ind[0, 0, 3] \[Rule] 
        1.0297553084059934`*^-13 + 6.244665906444351`*^-13\ \[ImaginaryI], 
      Ind[0, 1, 1] \[Rule] 
        1.8390368552339966`*^-13 + 1.42428722314514`*^-13\ \[ImaginaryI], 
      Ind[0, 1, 2] \[Rule] \(-1.3102771483704013`*^-14\) - 
          6.103426641050544`*^-15\ \[ImaginaryI], 
      Ind[0, 1, 3] \[Rule] \(-5.433158185632832`*^-14\) - 
          1.5880894270284617`*^-14\ \[ImaginaryI], 
      Ind[0, 2, 2] \[Rule] 
        1.8135172700375647`*^-13 + 1.4168632335167635`*^-13\ \[ImaginaryI], 
      Ind[0, 2, 3] \[Rule] 
        5.064077967834667`*^-14 + 1.6356778755764655`*^-14\ \[ImaginaryI], 
      Ind[0, 3, 3] \[Rule] 
        6.005416959107687`*^-13 + 1.3073315331472422`*^-13\ \[ImaginaryI], 
      Ind[1, 1, 1] \[Rule] \(-5.6354966361337987`*^-14\) + 
          1.7841555003555864`*^-14\ \[ImaginaryI], 
      Ind[1, 1, 2] \[Rule] 
        2.106274061882768`*^-14 - 5.848323947248171`*^-15\ \[ImaginaryI], 
      Ind[1, 1, 3] \[Rule] 
        1.2048171519982378`*^-13 - 5.746874368825124`*^-14\ \[ImaginaryI], 
      Ind[1, 2, 2] \[Rule] \(-2.011977737580706`*^-14\) + 
          6.2077890212235264`*^-15\ \[ImaginaryI], 
      Ind[1, 2, 3] \[Rule] \(-6.8616897240340585`*^-15\) + 
          2.0546353282272448`*^-15\ \[ImaginaryI], 
      Ind[1, 3, 3] \[Rule] \(-4.4732958449577226`*^-14\) + 
          1.931796370561008`*^-14\ \[ImaginaryI], 
      Ind[2, 2, 2] \[Rule] 
        5.821828912569752`*^-14 - 1.6386857928265146`*^-14\ \[ImaginaryI], 
      Ind[2, 2, 3] \[Rule] 
        1.1965927159616953`*^-13 - 5.700833870648877`*^-14\ \[ImaginaryI], 
      Ind[2, 3, 3] \[Rule] 
        4.5746460692917737`*^-14 - 1.8114129586449082`*^-14\ \[ImaginaryI], 
      Ind[3, 3, 3] \[Rule] 
        5.570810546644292`*^-13 - 
          3.7435899921012527`*^-13\ \[ImaginaryI]}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TENSOR 4th ORDER", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tens4th = \(\(\(RedF4[p1s, p2s, p3s, p4s, p5s, p6s, s12, s23, s34, s45, 
                  s56, s16, s123, s234, s345, M1^2, M2^2, M3^2, M4^2, M5^2, 
                  M6^2] /. D4 \[Rule] D0\) /. C3 \[Rule] C0\) /. 
            B2 \[Rule] B0\) /. chords // Expand\)], "Input"],

Cell[BoxData[
    \(\((1.443769113043933`*^-15 - 
            7.19700207135789`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu1]\ p1[
          mu4] + \((1.443769113043933`*^-15 - 
            7.19700207135789`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu2]\ p1[
          mu4] + \((1.443769113043933`*^-15 - 
            7.19700207135789`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu3]\ p1[
          mu4] - \((1.1256433981399094`*^-18 + 
            3.774961861857236`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu3]\ p1[
          mu4] + \((1.9064311846270324`*^-15 - 
            6.308566393173141`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu4]\ p2[
          mu1] - \((7.582428738726954`*^-19 + 
            3.618183260799722`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p1[
          mu4]\ p2[
          mu1] + \((1.9064311846270324`*^-15 - 
            6.308566393173141`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu4]\ p2[
          mu2] - \((7.582429912114163`*^-19 + 
            3.618182986444943`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p1[
          mu4]\ p2[
          mu2] - \((5.883882117905458`*^-19 + 
            3.6139227132876335`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu1]\ p2[
          mu2] + \((1.9064311846270324`*^-15 - 
            6.308566393173141`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu4]\ p2[
          mu3] - \((7.5824284354651565`*^-19 + 
            3.618182953299375`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu4]\ p2[
          mu3] - \((5.883880639382907`*^-19 + 
            3.613922679858075`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu1]\ p2[
          mu3] - \((5.883881812314549`*^-19 + 
            3.6139224055896764`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu2]\ p2[
          mu3] - \((4.833006279417188`*^-19 + 
            3.70228267473232`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu2]\ p2[
          mu3] + \((1.1215193893224807`*^-15 - 
            7.272345883560291`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu1]\ p2[
          mu4] + \((1.1215193893224807`*^-15 - 
            7.272345883560291`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu2]\ p2[
          mu4] + \((1.1215193893224807`*^-15 - 
            7.272345883560291`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu3]\ p2[
          mu4] - \((1.1645258236975717`*^-18 + 
            3.567135251237111`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu3]\ p2[
          mu4] + \((2.1295559525628945`*^-15 - 
            7.003183283796645`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu1]\ p2[
          mu4] - \((9.053912124514934`*^-19 + 
            3.5239655264417715`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu1]\ p2[
          mu4] + \((2.1295559525628945`*^-15 - 
            7.003183283796645`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu2]\ p2[
          mu4] - \((9.05391331244085`*^-19 + 
            3.52396525443977`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu2]\ p2[
          mu4] - \((8.082068502336475`*^-19 + 
            3.666888070375708`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu2]\ p2[
          mu4] + \((2.1295559525628945`*^-15 - 
            7.003183283796645`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu3]\ p2[
          mu4] - \((9.053911822097218`*^-19 + 
            3.52396522099404`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu3]\ p2[
          mu4] - \((8.08206701005619`*^-19 + 
            3.666888036632577`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu3]\ p2[
          mu4] - \((8.082068197431875`*^-19 + 
            3.666887764683824`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu3]\ p2[
          mu4] - \((7.4897449875408255`*^-19 + 
            3.9015748126751535`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu3]\ p2[
          mu4] - \((1.6682943213739545`*^-15 - 
            5.6357406930467924`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu4]\ p3[
          mu1] + \((1.0212571498360188`*^-18 + 
            3.2521061102253048`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p1[
          mu4]\ p3[
          mu1] + \((9.223013053263681`*^-19 + 
            3.334881050002171`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu2]\ p3[
          mu1] + \((9.223012414459897`*^-19 + 
            3.3348810897824543`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu3]\ p3[
          mu1] + \((8.403820860087157`*^-19 + 
            3.4248655792923894`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p2[
          mu3]\ p3[
          mu1] - \((2.1152189339854474`*^-15 - 
            6.403748586081556`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu4]\ p3[
          mu1] + \((1.1757924331784717`*^-18 + 
            3.217043342970276`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu4]\ p3[
          mu1] + \((1.1499721109620368`*^-18 + 
            3.4276156337753616`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p2[
          mu4]\ p3[
          mu1] + \((1.1499720457039129`*^-18 + 
            3.42761567343771`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p2[
          mu4]\ p3[
          mu1] + \((1.1256960337585002`*^-18 + 
            3.647240640334247`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p2[
          mu4]\ p3[
          mu1] - \((1.6682943213739545`*^-15 - 
            5.6357406930467924`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu4]\ p3[
          mu2] + \((1.0212570549190914`*^-18 + 
            3.2521055983133475`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p1[
          mu4]\ p3[
          mu2] + \((9.223011809855206`*^-19 + 
            3.334880882833079`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu1]\ p3[
          mu2] + \((9.223011526600893`*^-19 + 
            3.334880577876808`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu3]\ p3[
          mu2] + \((8.403819678478045`*^-19 + 
            3.4248654120455944`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu3]\ p3[
          mu2] - \((2.1152189339854474`*^-15 - 
            6.403748586081556`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu4]\ p3[
          mu2] + \((1.1757924544422174`*^-18 + 
            3.2170430185748945`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu4]\ p3[
          mu2] + \((1.149972101462771`*^-18 + 
            3.427615651931784`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu4]\ p3[
          mu2] + \((1.1499720730892192`*^-18 + 
            3.427615349017085`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p2[
          mu4]\ p3[
          mu2] + \((1.1256960304395652`*^-18 + 
            3.647240658412967`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p2[
          mu4]\ p3[
          mu2] - \((1.2620656554372786`*^-18 + 
            3.1424369912370203`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p3[
          mu1]\ p3[
          mu2] - \((1.1828702412263949`*^-18 + 
            3.1718754680967175`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p3[
          mu1]\ p3[
          mu2] - \((1.5085439606842027`*^-18 + 
            3.2629062649028122`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p3[
          mu1]\ p3[
          mu2] - \((1.4925487391942673`*^-18 + 
            3.4151698113202943`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p3[
          mu1]\ p3[
          mu2] - \((1.6682943213739545`*^-15 - 
            5.6357406930467924`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu4]\ p3[
          mu3] + \((1.0212568833879928`*^-18 + 
            3.2521053779194156`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu4]\ p3[
          mu3] + \((9.223010132034835`*^-19 + 
            3.334880664993873`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu1]\ p3[
          mu3] + \((9.223011433412754`*^-19 + 
            3.3348803913486747`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu2]\ p3[
          mu3] + \((8.403819624628428`*^-19 + 
            3.4248652283561772`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu2]\ p3[
          mu3] - \((2.1152189339854474`*^-15 - 
            6.403748586081556`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu4]\ p3[
          mu3] + \((1.1757922245697274`*^-18 + 
            3.2170426731433538`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu4]\ p3[
          mu3] + \((1.1499718753464422`*^-18 + 
            3.4276153090786352`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu4]\ p3[
          mu3] + \((1.1499720067968986`*^-18 + 
            3.427615037734544`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu4]\ p3[
          mu3] + \((1.1256959680962823`*^-18 + 
            3.647240350006613`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu4]\ p3[
          mu3] - \((1.2620655517237633`*^-18 + 
            3.1424368220287227`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p3[
          mu1]\ p3[
          mu3] - \((1.1828702169539337`*^-18 + 
            3.1718752598054896`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p3[
          mu1]\ p3[
          mu3] - \((1.5085437995171587`*^-18 + 
            3.2629059795110805`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p3[
          mu1]\ p3[
          mu3] - \((1.492548658846812`*^-18 + 
            3.415169486964356`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p3[
          mu1]\ p3[
          mu3] - \((1.2620655340976524`*^-18 + 
            3.1424363377876393`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p3[
          mu2]\ p3[
          mu3] - \((1.1828701570362009`*^-18 + 
            3.1718751195996632`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p3[
          mu2]\ p3[
          mu3] - \((1.5085438883813536`*^-18 + 
            3.2629056634235877`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p3[
          mu2]\ p3[
          mu3] - \((1.4925487042199219`*^-18 + 
            3.415169512772335`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p3[
          mu2]\ p3[
          mu3] + \((1.5214882089518608`*^-18 + 
            2.8783787962754243`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p3[
          mu2]\ p3[
          mu3] + \((1.849327563119269`*^-18 + 
            3.143880257435467`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p3[
          mu2]\ p3[
          mu3] - \((1.1940031107326557`*^-15 - 
            7.722023424673347`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu1]\ p3[
          mu4] - \((1.1940031107326557`*^-15 - 
            7.722023424673347`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu2]\ p3[
          mu4] - \((1.1940031107326557`*^-15 - 
            7.722023424673347`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu3]\ p3[
          mu4] + \((1.6193598737344616`*^-18 + 
            4.034453297850148`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu3]\ p3[
          mu4] - \((2.4196297413164616`*^-15 - 
            7.529840678904497`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu1]\ p3[
          mu4] + \((1.3445643309746636`*^-18 + 
            4.038343263562792`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu1]\ p3[
          mu4] - \((2.4196297413164616`*^-15 - 
            7.529840678904497`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu2]\ p3[
          mu4] + \((1.3445644536748777`*^-18 + 
            4.038342992755521`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu2]\ p3[
          mu4] + \((1.2148416613343514`*^-18 + 
            4.220036285434144`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu2]\ p3[
          mu4] - \((2.4196297413164616`*^-15 - 
            7.529840678904497`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu3]\ p3[
          mu4] + \((1.3445643003080903`*^-18 + 
            4.038342961346235`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu3]\ p3[
          mu4] + \((1.214841507778632`*^-18 + 
            4.220036253720358`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu3]\ p3[
          mu4] + \((1.2148416304313171`*^-18 + 
            4.220035982970279`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu3]\ p3[
          mu4] + \((1.1137021375654068`*^-18 + 
            4.4810312578835185`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu3]\ p3[
          mu4] + \((2.3452270127292033`*^-15 - 
            6.9732511013690516`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p3[
          mu1]\ p3[
          mu4] - \((1.62393383064219`*^-18 + 
            3.720003782409353`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p3[
          mu1]\ p3[
          mu4] - \((1.5673429066223266`*^-18 + 
            3.9557719902567604`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p3[
          mu1]\ p3[
          mu4] - \((1.56734283722288`*^-18 + 
            3.9557720326473845`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p3[
          mu1]\ p3[
          mu4] - \((1.5053434861867192`*^-18 + 
            4.191479862330662`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p3[
          mu1]\ p3[
          mu4] + \((2.3452270127292033`*^-15 - 
            6.9732511013690516`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p3[
          mu2]\ p3[
          mu4] - \((1.623933846947945`*^-18 + 
            3.720003470022012`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p3[
          mu2]\ p3[
          mu4] - \((1.5673428881838862`*^-18 + 
            3.955772019600414`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p3[
          mu2]\ p3[
          mu4] - \((1.5673428596020751`*^-18 + 
            3.955771720243478`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p3[
          mu2]\ p3[
          mu4] - \((1.5053434738735866`*^-18 + 
            4.191479891603318`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p3[
          mu2]\ p3[
          mu4] + \((1.9447527421879106`*^-18 + 
            3.758577925333039`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p3[
          mu2]\ p3[
          mu4] + \((1.8912960552512267`*^-18 + 
            3.919583399886716`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p3[
          mu2]\ p3[
          mu4] + \((2.3452270127292033`*^-15 - 
            6.9732511013690516`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p3[
          mu3]\ p3[
          mu4] - \((1.6239336165977996`*^-18 + 
            3.7200031268821124`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p3[
          mu3]\ p3[
          mu4] - \((1.5673426618139386`*^-18 + 
            3.955771679367861`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p3[
          mu3]\ p3[
          mu4] - \((1.5673427970063567`*^-18 + 
            3.955771408436344`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p3[
          mu3]\ p3[
          mu4] - \((1.5053434154464064`*^-18 + 
            4.191479583007243`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p3[
          mu3]\ p3[
          mu4] + \((1.9447525815949602`*^-18 + 
            3.7585776433602304`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p3[
          mu3]\ p3[
          mu4] + \((1.8912959794499767`*^-18 + 
            3.919583075441242`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p3[
          mu3]\ p3[
          mu4] + \((1.9447526655315355`*^-18 + 
            3.7585773384343305`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p3[
          mu3]\ p3[
          mu4] + \((1.8912960161544913`*^-18 + 
            3.919583112371371`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p3[
          mu3]\ p3[
          mu4] - \((2.265306392145628`*^-18 + 
            3.599694540845635`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p3[
          mu3]\ p3[
          mu4] - \((3.391827308163178`*^-15 - 
            6.343624086856696`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu4]\ p4[
          mu1] + \((1.326256188601622`*^-18 + 
            3.952688893814573`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p1[
          mu4]\ p4[
          mu1] + \((8.888949096978127`*^-19 + 
            3.649807017388314`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu2]\ p4[
          mu1] + \((8.888948493426565`*^-19 + 
            3.6498070588776645`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu3]\ p4[
          mu1] + \((5.62720157463595`*^-19 + 
            3.3745752043456002`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p2[
          mu3]\ p4[
          mu1] - \((3.2932682441299293`*^-15 - 
            6.400979425439764`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu4]\ p4[
          mu1] + \((1.3901097480050781`*^-18 + 
            3.760417952386298`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu4]\ p4[
          mu1] + \((1.0066067848183188`*^-18 + 
            3.5643437687873235`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p2[
          mu4]\ p4[
          mu1] + \((1.0066067231883634`*^-18 + 
            3.564343810136651`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p2[
          mu4]\ p4[
          mu1] + \((7.243355551454283`*^-19 + 
            3.401344770221158`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p2[
          mu4]\ p4[
          mu1] - \((1.0794931772180583`*^-18 + 
            3.087769018469506`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p3[
          mu2]\ p4[
          mu1] - \((8.142635006970068`*^-19 + 
            2.870354074918318`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p3[
          mu2]\ p4[
          mu1] - \((1.1896209880212604`*^-18 + 
            3.043843791212504`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p3[
          mu2]\ p4[
          mu1] - \((9.744197602859643`*^-19 + 
            2.9364542443267213`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p3[
          mu2]\ p4[
          mu1] - \((1.0794931583701991`*^-18 + 
            3.087768987885763`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p3[
          mu3]\ p4[
          mu1] - \((8.142635568921051`*^-19 + 
            2.8703540034601418`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p3[
          mu3]\ p4[
          mu1] - \((1.189620909734507`*^-18 + 
            3.0438436376220746`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p3[
          mu3]\ p4[
          mu1] - \((9.74419758317559`*^-19 + 
            2.9364540500022757`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p3[
          mu3]\ p4[
          mu1] + \((1.0580590217010664`*^-18 + 
            2.462574000787337`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu2]\ p3[
          mu3]\ p4[
          mu1] + \((1.222401643327043`*^-18 + 
            2.5691532644978385`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu2]\ p3[
          mu3]\ p4[
          mu1] + \((3.2325519338373875`*^-15 - 
            6.450098110005639`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p3[
          mu4]\ p4[
          mu1] - \((1.7377086028014374`*^-18 + 
            4.144906932262337`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p3[
          mu4]\ p4[
          mu1] - \((1.3225816537986871`*^-18 + 
            3.9647213667319954`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p3[
          mu4]\ p4[
          mu1] - \((1.322581588238035`*^-18 + 
            3.964721410841153`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p3[
          mu4]\ p4[
          mu1] - \((1.0016283208923255`*^-18 + 
            3.812230334519967`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p3[
          mu4]\ p4[
          mu1] + \((1.5188751803011398`*^-18 + 
            3.4256518296229778`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p3[
          mu4]\ p4[
          mu1] + \((1.2623657043787468`*^-18 + 
            3.3195796460131635`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p3[
          mu4]\ p4[
          mu1] + \((1.5188751024458932`*^-18 + 
            3.4256516813364547`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p3[
          mu4]\ p4[
          mu1] + \((1.2623657066122093`*^-18 + 
            3.3195794535374135`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p3[
          mu4]\ p4[
          mu1] - \((1.5230003604874691`*^-18 + 
            2.909070592098536`*^-18\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p3[
          mu4]\ p4[
          mu1] - \((3.391827308163178`*^-15 - 
            6.343624086856696`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu4]\ p4[
          mu2] + \((1.326255990213754`*^-18 + 
            3.952686700650306`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p1[
          mu4]\ p4[
          mu2] + \((8.888946785937135`*^-19 + 
            3.6498051646214715`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu1]\ p4[
          mu2] + \((8.888946495738874`*^-19 + 
            3.649804865642005`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu3]\ p4[
          mu2] + \((5.62719925008966`*^-19 + 
            3.374573351458851`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu3]\ p4[
          mu2] - \((3.2932682441299293`*^-15 - 
            6.400979425439764`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu4]\ p4[
          mu2] + \((1.3901095922314762`*^-18 + 
            3.760415857175678`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu4]\ p4[
          mu2] + \((1.0066065951065402`*^-18 + 
            3.564342011766501`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu4]\ p4[
          mu2] + \((1.0066065660247885`*^-18 + 
            3.5643417148226904`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p2[
          mu4]\ p4[
          mu2] + \((7.243353640829227`*^-19 + 
            3.401343013081612`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p2[
          mu4]\ p4[
          mu2] - \((1.0794931095614028`*^-18 + 
            3.087767287279145`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p3[
          mu1]\ p4[
          mu2] - \((8.142634255090962`*^-19 + 
            2.8703523436867392`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p3[
          mu1]\ p4[
          mu2] - \((1.1896208461856473`*^-18 + 
            3.0438419702265007`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p3[
          mu1]\ p4[
          mu2] - \((9.744196109194906`*^-19 + 
            2.9364524232991056`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p3[
          mu1]\ p4[
          mu2] - \((1.079493143411227`*^-18 + 
            3.0877669487674922`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p3[
          mu3]\ p4[
          mu2] - \((8.1426349731871`*^-19 + 
            2.870352304144889`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p3[
          mu3]\ p4[
          mu2] - \((1.1896209298536154`*^-18 + 
            3.0438416840261866`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p3[
          mu3]\ p4[
          mu2] - \((9.74419732723953`*^-19 + 
            2.9364524340571962`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p3[
          mu3]\ p4[
          mu2] + \((1.0580590669302092`*^-18 + 
            2.4625723959555327`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p3[
          mu3]\ p4[
          mu2] + \((1.2224016165389043`*^-18 + 
            2.5691515768078318`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p3[
          mu3]\ p4[
          mu2] + \((3.2325519338373875`*^-15 - 
            6.450098110005639`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p3[
          mu4]\ p4[
          mu2] - \((1.7377084420193576`*^-18 + 
            4.144904824343956`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p3[
          mu4]\ p4[
          mu2] - \((1.322581455127618`*^-18 + 
            3.964719596228751`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p3[
          mu4]\ p4[
          mu2] - \((1.322581425878825`*^-18 + 
            3.964719302837576`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p3[
          mu4]\ p4[
          mu2] - \((1.0016281206782445`*^-18 + 
            3.8122285639125934`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p3[
          mu4]\ p4[
          mu2] + \((1.5188750366237337`*^-18 + 
            3.4256499814536166`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p3[
          mu4]\ p4[
          mu2] + \((1.262365553032035`*^-18 + 
            3.3195777978128396`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p3[
          mu4]\ p4[
          mu2] + \((1.5188751175259555`*^-18 + 
            3.4256497123427907`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p3[
          mu4]\ p4[
          mu2] + \((1.262365672237398`*^-18 + 
            3.3195778221190245`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p3[
          mu4]\ p4[
          mu2] - \((1.5230003317656352`*^-18 + 
            2.9090688753019286`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p3[
          mu4]\ p4[
          mu2] - \((1.3311165368871754`*^-18 + 
            3.721292563171541`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p4[
          mu1]\ p4[
          mu2] - \((8.623896696027102`*^-19 + 
            3.245567041676757`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p4[
          mu1]\ p4[
          mu2] - \((1.3890626685578621`*^-18 + 
            3.543459256242239`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p4[
          mu1]\ p4[
          mu2] - \((9.576522006757506`*^-19 + 
            3.167593440969114`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p4[
          mu1]\ p4[
          mu2] + \((1.0632737917762628`*^-18 + 
            2.5700757571784237`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu3]\ p4[
          mu1]\ p4[
          mu2] + \((1.1471554838963003`*^-18 + 
            2.525645541007375`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu3]\ p4[
          mu1]\ p4[
          mu2] + \((1.643001193104211`*^-18 + 
            3.788605685885629`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu4]\ p4[
          mu1]\ p4[
          mu2] + \((1.1671653269344239`*^-18 + 
            3.412390799631375`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu4]\ p4[
          mu1]\ p4[
          mu2] - \((1.3583534523869265`*^-18 + 
            2.7254037595244957`*^-18\ \[ImaginaryI])\)\ p3[mu3]\ p3[mu4]\ p4[
          mu1]\ p4[
          mu2] - \((3.391827308163178`*^-15 - 
            6.343624086856696`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu4]\ p4[
          mu3] + \((1.3262562767862133`*^-18 + 
            3.952687269762173`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu4]\ p4[
          mu3] + \((8.888949680991576`*^-19 + 
            3.649805735714957`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu1]\ p4[
          mu3] + \((8.888950932933554`*^-19 + 
            3.64980547322583`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu2]\ p4[
          mu3] + \((5.627203718456179`*^-19 + 
            3.3745739612984232`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu2]\ p4[
          mu3] - \((3.2932682441299293`*^-15 - 
            6.400979425439764`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu4]\ p4[
          mu3] + \((1.3901099113148655`*^-18 + 
            3.7604162993543035`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu4]\ p4[
          mu3] + \((1.0066069170531002`*^-18 + 
            3.564342455935423`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu4]\ p4[
          mu3] + \((1.006607043268084`*^-18 + 
            3.564342195979722`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu4]\ p4[
          mu3] + \((7.243358443798987`*^-19 + 
            3.401343496517663`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu4]\ p4[
          mu3] - \((1.0794934626727017`*^-18 + 
            3.087768046712383`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p3[
          mu1]\ p4[
          mu3] - \((8.142638524928802`*^-19 + 
            2.8703530691058727`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p3[
          mu1]\ p4[
          mu3] - \((1.1896212393769967`*^-18 + 
            3.0438426115731777`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p3[
          mu1]\ p4[
          mu3] - \((9.744200789680206`*^-19 + 
            2.9364530310042176`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p3[
          mu1]\ p4[
          mu3] - \((1.0794934403593765`*^-18 + 
            3.087767577504622`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p3[
          mu2]\ p4[
          mu3] - \((8.142637928313299`*^-19 + 
            2.8703529327780865`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p3[
          mu2]\ p4[
          mu3] - \((1.1896213160956919`*^-18 + 
            3.043842311358355`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p3[
          mu2]\ p4[
          mu3] - \((9.744201174322867`*^-19 + 
            2.936453061297068`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p3[
          mu2]\ p4[
          mu3] + \((1.0580593600939957`*^-18 + 
            2.462573165532733`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p3[
          mu2]\ p4[
          mu3] + \((1.2224020056149636`*^-18 + 
            2.569152345012217`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p3[
          mu2]\ p4[
          mu3] + \((3.2325519338373875`*^-15 - 
            6.450098110005639`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p3[
          mu4]\ p4[
          mu3] - \((1.7377087899857057`*^-18 + 
            4.144905265954602`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p3[
          mu4]\ p4[
          mu3] - \((1.3225818062391545`*^-18 + 
            3.964720040126699`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p3[
          mu4]\ p4[
          mu3] - \((1.3225819356229926`*^-18 + 
            3.964719781040718`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p3[
          mu4]\ p4[
          mu3] - \((1.00162863375318`*^-18 + 
            3.812229044700044`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p3[
          mu4]\ p4[
          mu3] + \((1.5188754633876227`*^-18 + 
            3.425650625617316`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p3[
          mu4]\ p4[
          mu3] + \((1.2623660580085245`*^-18 + 
            3.3195784053134394`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p3[
          mu4]\ p4[
          mu3] + \((1.5188755326012925`*^-18 + 
            3.4256503379296045`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p3[
          mu4]\ p4[
          mu3] + \((1.2623660857987137`*^-18 + 
            3.3195784476356297`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p3[
          mu4]\ p4[
          mu3] - \((1.5230007532141794`*^-18 + 
            2.9090696441798038`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p3[
          mu4]\ p4[
          mu3] - \((1.3311170225957373`*^-18 + 
            3.721293608618922`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p4[
          mu1]\ p4[
          mu3] - \((8.623902257631576`*^-19 + 
            3.2455680500038938`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p4[
          mu1]\ p4[
          mu3] - \((1.389063199396762`*^-18 + 
            3.543460178142367`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p4[
          mu1]\ p4[
          mu3] - \((9.576528028828965`*^-19 + 
            3.1675943261205508`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p4[
          mu1]\ p4[
          mu3] + \((1.0632741345882924`*^-18 + 
            2.5700766746741436`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu2]\ p4[
          mu1]\ p4[
          mu3] + \((1.1471559298136334`*^-18 + 
            2.5256464585843475`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu2]\ p4[
          mu1]\ p4[
          mu3] + \((1.6430017620445008`*^-18 + 
            3.788606611892763`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu4]\ p4[
          mu1]\ p4[
          mu3] + \((1.1671659704549056`*^-18 + 
            3.4123916858795254`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu4]\ p4[
          mu1]\ p4[
          mu3] - \((1.3583539353450262`*^-18 + 
            2.7254046771044265`*^-18\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu4]\ p4[
          mu1]\ p4[
          mu3] - \((1.3311169309243809`*^-18 + 
            3.721291593434099`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p4[
          mu2]\ p4[
          mu3] - \((8.623900938923369`*^-19 + 
            3.2455663707349772`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p4[
          mu2]\ p4[
          mu3] - \((1.3890631320057553`*^-18 + 
            3.543458248730588`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p4[
          mu2]\ p4[
          mu3] - \((9.576526944514013`*^-19 + 
            3.16759273025987`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p4[
          mu2]\ p4[
          mu3] + \((1.0632741072144245`*^-18 + 
            2.570075088357102`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p4[
          mu2]\ p4[
          mu3] + \((1.1471558270454692`*^-18 + 
            2.5256447890547077`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p4[
          mu2]\ p4[
          mu3] + \((1.6430016850570013`*^-18 + 
            3.788604668941962`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu4]\ p4[
          mu2]\ p4[
          mu3] + \((1.167165849192785`*^-18 + 
            3.4123900759893477`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu4]\ p4[
          mu2]\ p4[
          mu3] - \((1.358353828593213`*^-18 + 
            2.725402979157453`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu4]\ p4[
          mu2]\ p4[
          mu3] + \((1.1101124514257041`*^-18 + 
            2.7608013201937537`*^-18\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu1]\ p4[
          mu2]\ p4[
          mu3] + \((1.1297804372491528`*^-18 + 
            2.5840134888446407`*^-18\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu1]\ p4[
          mu2]\ p4[
          mu3] - \((1.2570956456660604`*^-18 + 
            2.650119766687023`*^-18\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu1]\ p4[
          mu2]\ p4[
          mu3] - \((7.675877039886022`*^-16 - 
            1.1535961659733143`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu1]\ p4[
          mu4] - \((7.675877039886022`*^-16 - 
            1.1535961659733143`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu2]\ p4[
          mu4] - \((7.675877039886022`*^-16 - 
            1.1535961659733143`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu3]\ p4[
          mu4] + \((1.3228342824088044`*^-18 + 
            4.156795081501793`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu3]\ p4[
          mu4] - \((1.833292768586944`*^-15 - 
            1.0422058137304853`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu1]\ p4[
          mu4] + \((8.71670470355206`*^-19 + 
            4.025530917813044`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu1]\ p4[
          mu4] - \((1.833292768586944`*^-15 - 
            1.0422058137304853`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu2]\ p4[
          mu4] + \((8.71670601050131`*^-19 + 
            4.025530640070107`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu2]\ p4[
          mu4] + \((7.127785994688307`*^-19 + 
            4.1622829857813696`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu2]\ p4[
          mu4] - \((1.833292768586944`*^-15 - 
            1.0422058137304853`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu3]\ p4[
          mu4] + \((8.716704427494131`*^-19 + 
            4.025530614273961`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu3]\ p4[
          mu4] + \((7.127784409677422`*^-19 + 
            4.162282959692556`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu3]\ p4[
          mu4] + \((7.127785715908808`*^-19 + 
            4.162282681976047`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu3]\ p4[
          mu4] + \((6.412315751508358`*^-19 + 
            4.449301049973501`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu3]\ p4[
          mu4] + \((1.638121599269266`*^-15 - 
            8.693137097767605`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p3[
          mu1]\ p4[
          mu4] - \((1.1198672165748301`*^-18 + 
            3.495064063681131`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p3[
          mu1]\ p4[
          mu4] - \((1.0852849506640916`*^-18 + 
            3.764090724126919`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p3[
          mu1]\ p4[
          mu4] - \((1.085284876553765`*^-18 + 
            3.764090773590865`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p3[
          mu1]\ p4[
          mu4] - \((1.0685560138792378`*^-18 + 
            4.051385024823366`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p3[
          mu1]\ p4[
          mu4] + \((1.638121599269266`*^-15 - 
            8.693137097767605`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p3[
          mu2]\ p4[
          mu4] - \((1.1198671675577745`*^-18 + 
            3.4950637186037885`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p3[
          mu2]\ p4[
          mu4] - \((1.0852848589102992`*^-18 + 
            3.764090728590689`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p3[
          mu2]\ p4[
          mu4] - \((1.0852848335884558`*^-18 + 
            3.764090428464613`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p3[
          mu2]\ p4[
          mu4] - \((1.0685559282517392`*^-18 + 
            4.0513850292157435`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p3[
          mu2]\ p4[
          mu4] + \((1.4972796781493077`*^-18 + 
            3.554158535785284`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p3[
          mu2]\ p4[
          mu4] + \((1.496180333281527`*^-18 + 
            3.7484406055296275`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p3[
          mu2]\ p4[
          mu4] + \((1.638121599269266`*^-15 - 
            8.693137097767605`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p3[
          mu3]\ p4[
          mu4] - \((1.1198669475787835`*^-18 + 
            3.495063459970219`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p3[
          mu3]\ p4[
          mu4] - \((1.0852846432603796`*^-18 + 
            3.764090473423374`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p3[
          mu3]\ p4[
          mu4] - \((1.0852847862974278`*^-18 + 
            3.764090195552642`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p3[
          mu3]\ p4[
          mu4] - \((1.0685558854891672`*^-18 + 
            4.051384800061117`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p3[
          mu3]\ p4[
          mu4] + \((1.4972795255976109`*^-18 + 
            3.554158327648673`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p3[
          mu3]\ p4[
          mu4] + \((1.4961802702314247`*^-18 + 
            3.748440347846635`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p3[
          mu3]\ p4[
          mu4] + \((1.4972795442287305`*^-18 + 
            3.5541579978728655`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p3[
          mu3]\ p4[
          mu4] + \((1.4961802337862481`*^-18 + 
            3.7484403677421016`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p3[
          mu3]\ p4[
          mu4] - \((1.924135852988675`*^-18 + 
            3.420929470092148`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p3[
          mu3]\ p4[
          mu4] + \((4.606053418510289`*^-15 - 
            9.677259216957711`*^-15\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p4[
          mu1]\ p4[
          mu4] - \((1.6189707271558135`*^-18 + 
            4.696921968549949`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p4[
          mu1]\ p4[
          mu4] - \((1.046577401738413`*^-18 + 
            4.3401411560677305`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p4[
          mu1]\ p4[
          mu4] - \((1.0465773318329122`*^-18 + 
            4.34014120716304`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p4[
          mu1]\ p4[
          mu4] - \((6.46075561110685`*^-19 + 
            4.03860672184494`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p4[
          mu1]\ p4[
          mu4] + \((1.2399984045706253`*^-18 + 
            3.5420632288456275`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p4[
          mu1]\ p4[
          mu4] + \((9.478078528828704`*^-19 + 
            3.3425432211179747`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p4[
          mu1]\ p4[
          mu4] + \((1.2399983258912163`*^-18 + 
            3.542063150416682`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p4[
          mu1]\ p4[
          mu4] + \((9.478078586374135`*^-19 + 
            3.3425430915132556`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p4[
          mu1]\ p4[
          mu4] - \((1.2368884997914297`*^-18 + 
            2.842790621741071`*^-18\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p4[
          mu1]\ p4[
          mu4] + \((4.606053418510289`*^-15 - 
            9.677259216957711`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p4[
          mu2]\ p4[
          mu4] - \((1.61897063496302`*^-18 + 
            4.6969199920380464`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p4[
          mu2]\ p4[
          mu4] - \((1.046577264225166`*^-18 + 
            4.340139524672613`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p4[
          mu2]\ p4[
          mu4] - \((1.0465772380397172`*^-18 + 
            4.3401392305304416`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p4[
          mu2]\ p4[
          mu4] - \((6.460754220538345`*^-19 + 
            4.038605090343326`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p4[
          mu2]\ p4[
          mu4] + \((1.2399983976544845`*^-18 + 
            3.542061545040958`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p4[
          mu2]\ p4[
          mu4] + \((9.478078382970295`*^-19 + 
            3.3425415372789898`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p4[
          mu2]\ p4[
          mu4] + \((1.2399984194887739`*^-18 + 
            3.542061324155566`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p4[
          mu2]\ p4[
          mu4] + \((9.478078955087722`*^-19 + 
            3.3425416105345856`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p4[
          mu2]\ p4[
          mu4] - \((1.236888617873652`*^-18 + 
            2.8427890729126716`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p4[
          mu2]\ p4[
          mu4] + \((1.6936174848743547`*^-18 + 
            4.656562526220936`*^-18\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu1]\ p4[
          mu2]\ p4[
          mu4] + \((1.0791412392335934`*^-18 + 
            4.045241898045098`*^-18\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu1]\ p4[
          mu2]\ p4[
          mu4] - \((1.3100876074465034`*^-18 + 
            3.12696199321117`*^-18\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu1]\ p4[
          mu2]\ p4[
          mu4] + \((4.606053418510289`*^-15 - 
            9.677259216957711`*^-15\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p4[
          mu3]\ p4[
          mu4] - \((1.6189708241460646`*^-18 + 
            4.696920271847798`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p4[
          mu3]\ p4[
          mu4] - \((1.0465774566851388`*^-18 + 
            4.340139807332914`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p4[
          mu3]\ p4[
          mu4] - \((1.046577592818668`*^-18 + 
            4.340139542220429`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p4[
          mu3]\ p4[
          mu4] - \((6.460757803079149`*^-19 + 
            4.038605405163908`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p4[
          mu3]\ p4[
          mu4] + \((1.2399986534943034`*^-18 + 
            3.5420620166176684`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p4[
          mu3]\ p4[
          mu4] + \((9.478081758235923`*^-19 + 
            3.3425419661302047`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p4[
          mu3]\ p4[
          mu4] + \((1.2399986670139988`*^-18 + 
            3.5420617059263786`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p4[
          mu3]\ p4[
          mu4] + \((9.478081411705105`*^-19 + 
            3.3425419923515467`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p4[
          mu3]\ p4[
          mu4] - \((1.2368888612565683`*^-18 + 
            2.8427895982013434`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p4[
          mu3]\ p4[
          mu4] + \((1.6936178680335627`*^-18 + 
            4.656563277877781`*^-18\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu1]\ p4[
          mu3]\ p4[
          mu4] + \((1.0791417002015052`*^-18 + 
            4.045242603882337`*^-18\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu1]\ p4[
          mu3]\ p4[
          mu4] - \((1.3100879055349514`*^-18 + 
            3.1269626689340384`*^-18\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu1]\ p4[
          mu3]\ p4[
          mu4] + \((1.693617877151217`*^-18 + 
            4.656561473402833`*^-18\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu2]\ p4[
          mu3]\ p4[
          mu4] + \((1.0791416587451883`*^-18 + 
            4.045241139349642`*^-18\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu2]\ p4[
          mu3]\ p4[
          mu4] - \((1.3100879434264058`*^-18 + 
            3.1269611324477624`*^-18\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu2]\ p4[
          mu3]\ p4[
          mu4] - \((1.4528641226712342`*^-18 + 
            3.550669129472374`*^-18\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu2]\ p4[
          mu3]\ p4[
          mu4] + \((1.9418876101438584`*^-14 - 
            2.1263276091200695`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu4]\ p5[
          mu1] - \((1.5096470299920142`*^-17 + 
            2.7328218681204912`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p1[
          mu4]\ p5[
          mu1] - \((1.2368439337886007`*^-17 + 
            2.6076691791952546`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu2]\ p5[
          mu1] - \((1.2368439407064695`*^-17 + 
            2.6076691791334005`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu3]\ p5[
          mu1] - \((9.53293687296859`*^-18 + 
            2.4245424911741857`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p2[
          mu3]\ p5[
          mu1] + \((2.0707565236779943`*^-14 - 
            2.2669519439793676`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu4]\ p5[
          mu1] - \((1.5835501341908494`*^-17 + 
            2.828763949261213`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu4]\ p5[
          mu1] - \((1.299317577563242`*^-17 + 
            2.7050276746203878`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p2[
          mu4]\ p5[
          mu1] - \((1.2993175844515804`*^-17 + 
            2.7050276745549654`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p2[
          mu4]\ p5[
          mu1] - \((1.0048687309028546`*^-17 + 
            2.5199649864824132`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p2[
          mu4]\ p5[
          mu1] + \((1.3642170970671578`*^-17 + 
            2.304098868035038`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p3[
          mu2]\ p5[
          mu1] + \((1.0680023276633516`*^-17 + 
            2.0882271239378534`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p3[
          mu2]\ p5[
          mu1] + \((1.429483529736802`*^-17 + 
            2.389244729042969`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p3[
          mu2]\ p5[
          mu1] + \((1.1224901234229154`*^-17 + 
            2.1714716363434082`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p3[
          mu2]\ p5[
          mu1] + \((1.364217105648711`*^-17 + 
            2.3040988691718385`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p3[
          mu3]\ p5[
          mu1] + \((1.0680023299440655`*^-17 + 
            2.0882271251266187`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p3[
          mu3]\ p5[
          mu1] + \((1.429483537328594`*^-17 + 
            2.389244730458622`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p3[
          mu3]\ p5[
          mu1] + \((1.1224901247433662`*^-17 + 
            2.1714716378146338`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p3[
          mu3]\ p5[
          mu1] - \((1.153993542607878`*^-17 + 
            1.692988993009159`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu2]\ p3[
          mu3]\ p5[
          mu1] - \((1.2087288469566066`*^-17 + 
            1.7631748460315634`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu2]\ p3[
          mu3]\ p5[
          mu1] - \((2.3028257414213452`*^-14 - 
            2.5294078802974343`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p3[
          mu4]\ p5[
          mu1] + \((1.7301825520560458`*^-17 + 
            3.0575114778982585`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p3[
          mu4]\ p5[
          mu1] + \((1.418682508385676`*^-17 + 
            2.924472449446704`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p3[
          mu4]\ p5[
          mu1] + \((1.4186825152275504`*^-17 + 
            2.924472449359823`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p3[
          mu4]\ p5[
          mu1] + \((1.0982568991487168`*^-17 + 
            2.7252212567713375`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p3[
          mu4]\ p5[
          mu1] - \((1.557617610831486`*^-17 + 
            2.579748233728524`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p3[
          mu4]\ p5[
          mu1] - \((1.2246625954858193`*^-17 + 
            2.3471743036582667`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p3[
          mu4]\ p5[
          mu1] - \((1.5576176156912814`*^-17 + 
            2.579748233774056`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p3[
          mu4]\ p5[
          mu1] - \((1.2246625941163414`*^-17 + 
            2.3471743037839162`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p3[
          mu4]\ p5[
          mu1] + \((1.3157771452836626`*^-17 + 
            1.9064340592750167`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p3[
          mu4]\ p5[
          mu1] + \((1.1877268265958585`*^-17 + 
            2.18170314517314`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p4[
          mu2]\ p5[
          mu1] + \((8.645143777042252`*^-18 + 
            1.9310811893045244`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p4[
          mu2]\ p5[
          mu1] + \((1.2443194040849919`*^-17 + 
            2.2532491295606638`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p4[
          mu2]\ p5[
          mu1] + \((9.088048733748418`*^-18 + 
            1.9994548607249382`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p4[
          mu2]\ p5[
          mu1] - \((9.169929518413381`*^-18 + 
            1.4788912890092908`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu3]\ p4[
          mu2]\ p5[
          mu1] - \((9.601375169254215`*^-18 + 
            1.532152933608849`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu3]\ p4[
          mu2]\ p5[
          mu1] - \((1.3343016614044785`*^-17 + 
            2.3981759672751938`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu4]\ p4[
          mu2]\ p5[
          mu1] - \((9.761803110522044`*^-18 + 
            2.1302705323691966`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu4]\ p4[
          mu2]\ p5[
          mu1] + \((1.0308452944185755`*^-17 + 
            1.6348643108902068`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p3[mu4]\ p4[
          mu2]\ p5[
          mu1] + \((1.1877268080676864`*^-17 + 
            2.1817031149763692`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p4[
          mu3]\ p5[
          mu1] + \((8.645143529100447`*^-18 + 
            1.9310811591084105`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p4[
          mu3]\ p5[
          mu1] + \((1.2443193783029837`*^-17 + 
            2.2532490993019193`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p4[
          mu3]\ p5[
          mu1] + \((9.088048413545641`*^-18 + 
            1.99945483046716`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p4[
          mu3]\ p5[
          mu1] - \((9.16992924742503`*^-18 + 
            1.478891257217567`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu2]\ p4[
          mu3]\ p5[
          mu1] - \((9.60137483821522`*^-18 + 
            1.5321529018209297`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu2]\ p4[
          mu3]\ p5[
          mu1] - \((1.3343016308168357`*^-17 + 
            2.3981759355331813`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu4]\ p4[
          mu3]\ p5[
          mu1] - \((9.761802742715043`*^-18 + 
            2.130270500647332`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu4]\ p4[
          mu3]\ p5[
          mu1] + \((1.0308452593351442`*^-17 + 
            1.6348642791054897`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu4]\ p4[
          mu3]\ p5[
          mu1] - \((6.447353319142742`*^-18 + 
            1.1908781339327318`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu1] - \((6.730063001349604`*^-18 + 
            1.2254875496382734`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu1] + \((7.161751440831716`*^-18 + 
            1.2936330538189264`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu1] - \((2.7918778268145965`*^-14 - 
            3.014274647892602`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p4[
          mu4]\ p5[
          mu1] + \((2.1665166634609335`*^-17 + 
            3.9210139804570126`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p4[
          mu4]\ p5[
          mu1] + \((1.780389801497253`*^-17 + 
            3.7478332250654527`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p4[
          mu4]\ p5[
          mu1] + \((1.7803898083238198`*^-17 + 
            3.7478332250508994`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p4[
          mu4]\ p5[
          mu1] + \((1.3758519968327582`*^-17 + 
            3.4893321683972856`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p4[
          mu4]\ p5[
          mu1] - \((1.9647255317568783`*^-17 + 
            3.317219485513773`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p4[
          mu4]\ p5[
          mu1] - \((1.5407126470600117`*^-17 + 
            3.00923814847396`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p4[
          mu4]\ p5[
          mu1] - \((1.964725538077363`*^-17 + 
            3.317219485290397`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p4[
          mu4]\ p5[
          mu1] - \((1.5407126471665292`*^-17 + 
            3.009238148258383`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p4[
          mu4]\ p5[
          mu1] + \((1.663940547748441`*^-17 + 
            2.4420519229578438`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p4[
          mu4]\ p5[
          mu1] - \((1.752308370153808`*^-17 + 
            3.199361085687461`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu1] - \((1.2774522660829099`*^-17 + 
            2.8341495128469065`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu1] + \((1.349435169347458`*^-17 + 
            2.167353317303953`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu1] - \((1.752308354483362`*^-17 + 
            3.199361058210292`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu1] - \((1.2774522442434535`*^-17 + 
            2.834149485303414`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu1] + \((1.3494351473595774`*^-17 + 
            2.1673532895469353`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu1] + \((9.588600136506394`*^-18 + 
            1.763094110932488`*^-17\ \[ImaginaryI])\)\ p4[mu2]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu1] + \((1.9418876101438584`*^-14 - 
            2.1263276091200695`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu4]\ p5[
          mu2] - \((1.509647168905891`*^-17 + 
            2.7328219512069333`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p1[
          mu4]\ p5[
          mu2] - \((1.2368440744665492`*^-17 + 
            2.607669266011887`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p2[
          mu1]\ p5[
          mu2] - \((1.2368440797262399`*^-17 + 
            2.6076692623148115`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu3]\ p5[
          mu2] - \((9.532938280784984`*^-18 + 
            2.4245425780954335`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu3]\ p5[
          mu2] + \((2.0707565236779943`*^-14 - 
            2.2669519439793676`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu4]\ p5[
          mu2] - \((1.5835502468623746`*^-17 + 
            2.828763950316351`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu4]\ p5[
          mu2] - \((1.2993176919533722`*^-17 + 
            2.7050276794037988`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu4]\ p5[
          mu2] - \((1.2993176972306545`*^-17 + 
            2.7050276757103915`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p2[
          mu4]\ p5[
          mu2] - \((1.0048688453966609`*^-17 + 
            2.5199649913704493`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p2[
          mu4]\ p5[
          mu2] + \((1.3642172392012795`*^-17 + 
            2.3040989562589343`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p3[
          mu1]\ p5[
          mu2] + \((1.0680024705191442`*^-17 + 
            2.0882272122596362`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p3[
          mu1]\ p5[
          mu2] + \((1.4294836487152097`*^-17 + 
            2.3892447406753814`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p3[
          mu1]\ p5[
          mu2] + \((1.1224902431229688`*^-17 + 
            2.171471648073792`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p3[
          mu1]\ p5[
          mu2] + \((1.3642172284866848`*^-17 + 
            2.3040989546101756`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p3[
          mu3]\ p5[
          mu2] + \((1.0680024538729465`*^-17 + 
            2.0882272143052117`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p3[
          mu3]\ p5[
          mu2] + \((1.4294836358562938`*^-17 + 
            2.389244738299283`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p3[
          mu3]\ p5[
          mu2] + \((1.1224902243148485`*^-17 + 
            2.1714716493883104`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p3[
          mu3]\ p5[
          mu2] - \((1.1539936720200343`*^-17 + 
            1.6929890850480587`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p3[
          mu3]\ p5[
          mu2] - \((1.2087289543646787`*^-17 + 
            1.7631748650467283`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p3[
          mu3]\ p5[
          mu2] - \((2.3028257414213452`*^-14 - 
            2.5294078802974343`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p3[
          mu4]\ p5[
          mu2] + \((1.730182653863185`*^-17 + 
            3.057511452108638`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p3[
          mu4]\ p5[
          mu2] + \((1.418682611861977`*^-17 + 
            2.924472427380068`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p3[
          mu4]\ p5[
          mu2] + \((1.41868261714133`*^-17 + 
            2.924472423671672`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p3[
          mu4]\ p5[
          mu2] + \((1.0982570027277394`*^-17 + 
            2.7252212348100095`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p3[
          mu4]\ p5[
          mu2] - \((1.5576177176131525`*^-17 + 
            2.579748218655855`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p3[
          mu4]\ p5[
          mu2] - \((1.224662702982812`*^-17 + 
            2.3471742886836332`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p3[
          mu4]\ p5[
          mu2] - \((1.557617705904741`*^-17 + 
            2.5797482162039174`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p3[
          mu4]\ p5[
          mu2] - \((1.224662685323145`*^-17 + 
            2.347174289937291`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p3[
          mu4]\ p5[
          mu2] + \((1.3157772427728614`*^-17 + 
            1.906434053015384`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p3[
          mu4]\ p5[
          mu2] + \((1.1877269829332957`*^-17 + 
            2.1817032337404397`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p4[
          mu1]\ p5[
          mu2] + \((8.645145339900234`*^-18 + 
            1.9310812779639914`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p4[
          mu1]\ p5[
          mu2] + \((1.244319531130579`*^-17 + 
            2.2532491439590924`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p4[
          mu1]\ p5[
          mu2] + \((9.088050003687897`*^-18 + 
            1.999454875215529`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p4[
          mu1]\ p5[
          mu2] - \((9.169930910930693`*^-18 + 
            1.478891377777154`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu3]\ p4[
          mu1]\ p5[
          mu2] - \((9.60137628296329`*^-18 + 
            1.5321529524692807`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu3]\ p4[
          mu1]\ p5[
          mu2] - \((1.3343017765826684`*^-17 + 
            2.3981759560335796`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu4]\ p4[
          mu1]\ p5[
          mu2] - \((9.76180426178757`*^-18 + 
            2.1302705212198236`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu4]\ p4[
          mu1]\ p5[
          mu2] + \((1.0308453962947032`*^-17 + 
            1.6348643055446634`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p3[mu4]\ p4[
          mu1]\ p5[
          mu2] + \((1.1877269512341281`*^-17 + 
            2.1817032193351`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p4[
          mu3]\ p5[
          mu2] + \((8.64514497173249`*^-18 + 
            1.9310812672533508`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p4[
          mu3]\ p5[
          mu2] + \((1.2443195022111946`*^-17 + 
            2.2532491267662338`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p4[
          mu3]\ p5[
          mu2] + \((9.088049663133292`*^-18 + 
            1.9994548617115123`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p4[
          mu3]\ p5[
          mu2] - \((9.169930741320915`*^-18 + 
            1.4788913676514144`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p4[
          mu3]\ p5[
          mu2] - \((9.601376154798439`*^-18 + 
            1.5321529395874878`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p4[
          mu3]\ p5[
          mu2] - \((1.3343017481347172`*^-17 + 
            2.3981759378367278`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu4]\ p4[
          mu3]\ p5[
          mu2] - \((9.761803925909528`*^-18 + 
            2.130270506723607`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu4]\ p4[
          mu3]\ p5[
          mu2] + \((1.0308453825308356`*^-17 + 
            1.6348642917277548`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu4]\ p4[
          mu3]\ p5[
          mu2] - \((6.447354911873064`*^-18 + 
            1.1908782420348668`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu1]\ p4[
          mu3]\ p5[
          mu2] - \((6.730064356681862`*^-18 + 
            1.2254875878393376`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu1]\ p4[
          mu3]\ p5[
          mu2] + \((7.161752715298464`*^-18 + 
            1.2936330678190366`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu1]\ p4[
          mu3]\ p5[
          mu2] - \((2.7918778268145965`*^-14 - 
            3.014274647892602`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p4[
          mu4]\ p5[
          mu2] + \((2.1665168096845552`*^-17 + 
            3.9210139746912`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p4[
          mu4]\ p5[
          mu2] + \((1.7803899493058952`*^-17 + 
            3.747833223201101`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p4[
          mu4]\ p5[
          mu2] + \((1.7803899546535537`*^-17 + 
            3.7478332193841184`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p4[
          mu4]\ p5[
          mu2] + \((1.3758521447441354`*^-17 + 
            3.489332166635887`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p4[
          mu4]\ p5[
          mu2] - \((1.9647256794992578`*^-17 + 
            3.317219483143374`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p4[
          mu4]\ p5[
          mu2] - \((1.5407127955177093`*^-17 + 
            3.009238146199259`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p4[
          mu4]\ p5[
          mu2] - \((1.9647256698819192`*^-17 + 
            3.3172194806554053`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p4[
          mu4]\ p5[
          mu2] - \((1.540712779867202`*^-17 + 
            3.0092381475281346`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p4[
          mu4]\ p5[
          mu2] + \((1.663940683364359`*^-17 + 
            2.4420519230873747`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p4[
          mu4]\ p5[
          mu2] - \((1.752308528819162`*^-17 + 
            3.199361087618001`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu1]\ p4[
          mu4]\ p5[
          mu2] - \((1.277452424696628`*^-17 + 
            2.8341495148672385`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu1]\ p4[
          mu4]\ p5[
          mu2] + \((1.3494353126317894`*^-17 + 
            2.1673533188285548`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu1]\ p4[
          mu4]\ p5[
          mu2] - \((1.7523085064771864`*^-17 + 
            3.199361073415428`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu2] - \((1.2774523971468836`*^-17 + 
            2.834149504469342`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu2] + \((1.3494353028930994`*^-17 + 
            2.1673533090235068`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu2] + \((9.588601764641593`*^-18 + 
            1.7630941317893393`*^-17\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu3]\ p4[
          mu4]\ p5[
          mu2] - \((8.205638695197705`*^-17 + 
            1.1766351120192552`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p1[mu4]\ p5[
          mu1]\ p5[
          mu2] - \((5.827948730625488`*^-17 + 
            1.0167440983640918`*^-16\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu3]\ p5[
          mu1]\ p5[
          mu2] - \((8.659067659805107`*^-17 + 
            1.2129824101020664`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu4]\ p5[
          mu1]\ p5[
          mu2] - \((6.17160674341529`*^-17 + 
            1.049783880207492`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p2[mu4]\ p5[
          mu1]\ p5[
          mu2] + \((5.2051994781413115`*^-17 + 
            6.443104752106454`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu3]\ p5[
          mu1]\ p5[
          mu2] + \((5.5109737025279526`*^-17 + 
            6.657349700698203`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu3]\ p5[
          mu1]\ p5[
          mu2] + \((8.739074395366647`*^-17 + 
            1.2004021920113632`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu4]\ p5[
          mu1]\ p5[
          mu2] + \((6.239529893649049`*^-17 + 
            1.0393596770290353`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu4]\ p5[
          mu1]\ p5[
          mu2] - \((5.564174652605673`*^-17 + 
            6.575067267093567`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p3[mu4]\ p5[
          mu1]\ p5[
          mu2] + \((2.821721747345905`*^-17 + 
            4.383740847522058`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu2] + \((2.988474523237529`*^-17 + 
            4.515780672412767`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu2] - \((3.016586690545751`*^-17 + 
            4.4521376367929016`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu2] + \((1.3253477440846923`*^-16 + 
            1.9048460248705938`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu2] + \((9.423833717561148`*^-17 + 
            1.6475187332282667`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu2] - \((8.426194599090771`*^-17 + 
            1.0479997381008453`*^-16\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu2] - \((4.5702350249790665`*^-17 + 
            7.126184492643365`*^-17\ \[ImaginaryI])\)\ p4[mu3]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu2] + \((1.9418876101438584`*^-14 - 
            2.1263276091200695`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu4]\ p5[
          mu3] - \((1.5096471397406384`*^-17 + 
            2.7328216443158428`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu4]\ p5[
          mu3] - \((1.2368440450760177`*^-17 + 
            2.6076689583580667`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p2[
          mu1]\ p5[
          mu3] - \((1.236844044319717`*^-17 + 
            2.6076689559004297`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p2[
          mu2]\ p5[
          mu3] - \((9.532937924273004`*^-18 + 
            2.4245422708897256`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p2[
          mu2]\ p5[
          mu3] + \((2.0707565236779943`*^-14 - 
            2.2669519439793676`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu4]\ p5[
          mu3] - \((1.5835502091651574`*^-17 + 
            2.828763648151721`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu4]\ p5[
          mu3] - \((1.2993176540258274`*^-17 + 
            2.7050273764737367`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu4]\ p5[
          mu3] - \((1.2993176533195405`*^-17 + 
            2.7050273740214443`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu4]\ p5[
          mu3] - \((1.0048688012362668`*^-17 + 
            2.5199646888873953`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu4]\ p5[
          mu3] + \((1.3642171964684476`*^-17 + 
            2.3040986492025775`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p3[
          mu1]\ p5[
          mu3] + \((1.0680024214011932`*^-17 + 
            2.0882269054429156`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p3[
          mu1]\ p5[
          mu3] + \((1.4294835965743832`*^-17 + 
            2.3892444374726594`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p3[
          mu1]\ p5[
          mu3] + \((1.1224901846282917`*^-17 + 
            2.1714713451107753`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p3[
          mu1]\ p5[
          mu3] + \((1.3642172092892221`*^-17 + 
            2.304098647008361`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p3[
          mu2]\ p5[
          mu3] + \((1.068002434481286`*^-17 + 
            2.08822690592063`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p3[
          mu2]\ p5[
          mu3] + \((1.4294836080498836`*^-17 + 
            2.3892444310504836`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p3[
          mu2]\ p5[
          mu3] + \((1.1224901963131065`*^-17 + 
            2.1714713413551663`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p3[
          mu2]\ p5[
          mu3] - \((1.1539936369477123`*^-17 + 
            1.6929887748197513`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p3[
          mu2]\ p5[
          mu3] - \((1.2087289099035413`*^-17 + 
            1.7631745551677877`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p3[
          mu2]\ p5[
          mu3] - \((2.3028257414213452`*^-14 - 
            2.5294078802974343`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p3[
          mu4]\ p5[
          mu3] + \((1.7301826174878917`*^-17 + 
            3.057511151714093`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p3[
          mu4]\ p5[
          mu3] + \((1.418682575248704`*^-17 + 
            2.924472126216857`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p3[
          mu4]\ p5[
          mu3] + \((1.4186825746027256`*^-17 + 
            2.9244721237521794`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p3[
          mu4]\ p5[
          mu3] + \((1.098256959932548`*^-17 + 
            2.7252209340932347`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p3[
          mu4]\ p5[
          mu3] - \((1.5576176664817327`*^-17 + 
            2.5797479169786025`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p3[
          mu4]\ p5[
          mu3] - \((1.2246626455537973`*^-17 + 
            2.3471739872461157`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p3[
          mu4]\ p5[
          mu3] - \((1.557617677565534`*^-17 + 
            2.5797479093220566`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p3[
          mu4]\ p5[
          mu3] - \((1.2246626567866342`*^-17 + 
            2.3471739822685217`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p3[
          mu4]\ p5[
          mu3] + \((1.3157771975103597`*^-17 + 
            1.9064337432612017`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p3[
          mu4]\ p5[
          mu3] + \((1.1877269133044238`*^-17 + 
            2.1817029216476103`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p4[
          mu1]\ p5[
          mu3] + \((8.645144582196525`*^-18 + 
            1.9310809664210967`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p4[
          mu1]\ p5[
          mu3] + \((1.2443194585391055`*^-17 + 
            2.2532488360604195`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p4[
          mu1]\ p5[
          mu3] + \((9.088049216635307`*^-18 + 
            1.999454567866919`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p4[
          mu1]\ p5[
          mu3] - \((9.169930324373118`*^-18 + 
            1.47889106595164`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu2]\ p4[
          mu1]\ p5[
          mu3] - \((9.601375665156961`*^-18 + 
            1.5321526406420756`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu2]\ p4[
          mu1]\ p5[
          mu3] - \((1.3343017048761588`*^-17 + 
            2.3981756495340402`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu4]\ p4[
          mu1]\ p5[
          mu3] - \((9.76180348408382`*^-18 + 
            2.130270215270367`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu4]\ p4[
          mu1]\ p5[
          mu3] + \((1.0308453334846316`*^-17 + 
            1.6348639937159003`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu4]\ p4[
          mu1]\ p5[
          mu3] + \((1.1877269280217185`*^-17 + 
            2.1817029093649277`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p4[
          mu2]\ p5[
          mu3] + \((8.64514473793734`*^-18 + 
            1.9310809565070872`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p4[
          mu2]\ p5[
          mu3] + \((1.2443194721887362`*^-17 + 
            2.2532488167961995`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p4[
          mu2]\ p5[
          mu3] + \((9.088049361237801`*^-18 + 
            1.9994545509652093`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p4[
          mu2]\ p5[
          mu3] - \((9.169930354031182`*^-18 + 
            1.4788910563968582`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p4[
          mu2]\ p5[
          mu3] - \((9.601375699408365`*^-18 + 
            1.5321526283329464`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p4[
          mu2]\ p5[
          mu3] - \((1.3343017181122686`*^-17 + 
            2.3981756278667133`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu4]\ p4[
          mu2]\ p5[
          mu3] - \((9.76180362401389`*^-18 + 
            2.1302701959773042`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu4]\ p4[
          mu2]\ p5[
          mu3] + \((1.0308453369918233`*^-17 + 
            1.6348639804732134`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu4]\ p4[
          mu2]\ p5[
          mu3] - \((6.447354316066661`*^-18 + 
            1.1908779307482606`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu1]\ p4[
          mu2]\ p5[
          mu3] - \((6.7300637619326564`*^-18 + 
            1.2254872765527363`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu1]\ p4[
          mu2]\ p5[
          mu3] + \((7.161752120549259`*^-18 + 
            1.2936327565324304`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu1]\ p4[
          mu2]\ p5[
          mu3] - \((2.7918778268145965`*^-14 - 
            3.014274647892602`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p4[
          mu4]\ p5[
          mu3] + \((2.1665167655013236`*^-17 + 
            3.92101376251355`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p4[
          mu4]\ p5[
          mu3] + \((1.780389904867842`*^-17 + 
            3.7478330102507026`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p4[
          mu4]\ p5[
          mu3] + \((1.7803899043074943`*^-17 + 
            3.747833007679312`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p4[
          mu4]\ p5[
          mu3] + \((1.3758520941241341`*^-17 + 
            3.489331954129558`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p4[
          mu4]\ p5[
          mu3] - \((1.9647256217891127`*^-17 + 
            3.3172192719365754`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p4[
          mu4]\ p5[
          mu3] - \((1.5407127315099595`*^-17 + 
            3.009237935229809`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p4[
          mu4]\ p5[
          mu3] - \((1.9647256348538524`*^-17 + 
            3.3172192694005257`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p4[
          mu4]\ p5[
          mu3] - \((1.540712744638084`*^-17 + 
            3.009237935479424`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p4[
          mu4]\ p5[
          mu3] + \((1.6639406325375875`*^-17 + 
            2.4420517099476697`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p4[
          mu4]\ p5[
          mu3] - \((1.752308462120928`*^-17 + 
            3.19936087159142`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu1]\ p4[
          mu4]\ p5[
          mu3] - \((1.2774523519345337`*^-17 + 
            2.8341492993882946`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu1]\ p4[
          mu4]\ p5[
          mu3] + \((1.3494352550635506`*^-17 + 
            2.1673531036167488`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu1]\ p4[
          mu4]\ p5[
          mu3] - \((1.7523084666212907`*^-17 + 
            3.19936086004792`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu3] - \((1.2774523571238727`*^-17 + 
            2.834149290327961`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu3] + \((1.3494352475206253`*^-17 + 
            2.167353094373281`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu3] + \((9.588601172187332`*^-18 + 
            1.7630939171070563`*^-17\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu2]\ p4[
          mu4]\ p5[
          mu3] - \((8.205638682102871`*^-17 + 
            1.1766351120340734`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu4]\ p5[
          mu1]\ p5[
          mu3] - \((5.82794872382807`*^-17 + 
            1.0167440983975392`*^-16\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu2]\ p5[
          mu1]\ p5[
          mu3] - \((8.659067649806252`*^-17 + 
            1.2129824101196723`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu4]\ p5[
          mu1]\ p5[
          mu3] - \((6.171606739693922`*^-17 + 
            1.0497838802474825`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu4]\ p5[
          mu1]\ p5[
          mu3] + \((5.205199471277761`*^-17 + 
            6.443104752607961`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu2]\ p5[
          mu1]\ p5[
          mu3] + \((5.510973697519369`*^-17 + 
            6.657349701199534`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu2]\ p5[
          mu1]\ p5[
          mu3] + \((8.739074386386467`*^-17 + 
            1.2004021920303733`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu4]\ p5[
          mu1]\ p5[
          mu3] + \((6.239529890899831`*^-17 + 
            1.0393596770723534`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu4]\ p5[
          mu1]\ p5[
          mu3] - \((5.56417464816095`*^-17 + 
            6.575067267594873`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu4]\ p5[
          mu1]\ p5[
          mu3] + \((2.8217217453936046`*^-17 + 
            4.383740847511655`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu2]\ p5[
          mu1]\ p5[
          mu3] + \((2.988474521285231`*^-17 + 
            4.515780672402364`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu2]\ p5[
          mu1]\ p5[
          mu3] - \((3.016586688593451`*^-17 + 
            4.4521376367824985`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu2]\ p5[
          mu1]\ p5[
          mu3] + \((1.325347742699561`*^-16 + 
            1.904846024874047`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu3] + \((9.423833709940798`*^-17 + 
            1.6475187332562727`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu3] - \((8.426194591620628`*^-17 + 
            1.0479997381507309`*^-16\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu3] - \((4.5702350230267664`*^-17 + 
            7.126184492632962`*^-17\ \[ImaginaryI])\)\ p4[mu2]\ p4[mu4]\ p5[
          mu1]\ p5[
          mu3] - \((8.205638703376097`*^-17 + 
            1.1766351187668252`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu4]\ p5[
          mu2]\ p5[
          mu3] - \((5.82794874410376`*^-17 + 
            1.0167441048134106`*^-16\ \[ImaginaryI])\)\ p1[mu4]\ p2[mu1]\ p5[
          mu2]\ p5[
          mu3] - \((8.659067667912709`*^-17 + 
            1.2129824167189577`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu4]\ p5[
          mu2]\ p5[
          mu3] - \((6.171606756847368`*^-17 + 
            1.0497838865307776`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu4]\ p5[
          mu2]\ p5[
          mu3] + \((5.205199493144361`*^-17 + 
            6.443104816160054`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p3[mu1]\ p5[
          mu2]\ p5[
          mu3] + \((5.510973717484812`*^-17 + 
            6.657349763491521`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p3[mu1]\ p5[
          mu2]\ p5[
          mu3] + \((8.739074403289646`*^-17 + 
            1.2004021985414754`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu4]\ p5[
          mu2]\ p5[
          mu3] + \((6.239529906902368`*^-17 + 
            1.03935968326651`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu4]\ p5[
          mu2]\ p5[
          mu3] - \((5.564174667383779`*^-17 + 
            6.575067329028777`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu4]\ p5[
          mu2]\ p5[
          mu3] + \((2.821721760781`*^-17 + 
            4.38374090956051`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p4[mu1]\ p5[
          mu2]\ p5[
          mu3] + \((2.98847453662808`*^-17 + 
            4.51578073319093`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p4[mu1]\ p5[
          mu2]\ p5[
          mu3] - \((3.0165867037589`*^-17 + 
            4.4521376967129616`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p4[mu1]\ p5[
          mu2]\ p5[
          mu3] + \((1.325347744928731`*^-16 + 
            1.904846031822249`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu4]\ p5[
          mu2]\ p5[
          mu3] + \((9.423833731403367`*^-17 + 
            1.6475187398762938`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu4]\ p5[
          mu2]\ p5[
          mu3] - \((8.426194614457777`*^-17 + 
            1.0479997447049797`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu4]\ p5[
          mu2]\ p5[
          mu3] - \((4.5702350387775256`*^-17 + 
            7.12618455666956`*^-17\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu4]\ p5[
          mu2]\ p5[
          mu3] + \((4.626228150831637`*^-17 + 
            7.20260729154483`*^-17\ \[ImaginaryI])\)\ p1[mu4]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu3] + \((4.8898674161078236`*^-17 + 
            7.409290550219049`*^-17\ \[ImaginaryI])\)\ p2[mu4]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu3] - \((4.9527563002115866`*^-17 + 
            7.342677743627136`*^-17\ \[ImaginaryI])\)\ p3[mu4]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu3] - \((7.445099346173161`*^-17 + 
            1.1611066903380376`*^-16\ \[ImaginaryI])\)\ p4[mu4]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu3] + \((4.544926001417673`*^-16 - 
            4.703305145046265`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p1[
          mu1]\ p5[
          mu4] + \((4.544926001417673`*^-16 - 
            4.703305145046265`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p1[
          mu2]\ p5[
          mu4] + \((4.544926001417673`*^-16 - 
            4.703305145046265`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p1[
          mu3]\ p5[
          mu4] - \((2.1552267289009252`*^-17 + 
            4.526634966498015`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p1[
          mu3]\ p5[
          mu4] + \((6.60959527435573`*^-15 - 
            4.5618573949489366`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p2[
          mu1]\ p5[
          mu4] - \((1.799224625126071`*^-17 + 
            4.4240368374498795`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p2[
          mu1]\ p5[
          mu4] + \((6.60959527435573`*^-15 - 
            4.5618573949489366`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p2[
          mu2]\ p5[
          mu4] - \((1.799224662165605`*^-17 + 
            4.4240368298084304`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p2[
          mu2]\ p5[
          mu4] - \((1.5467395106285802`*^-17 + 
            4.414940631360176`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p2[
          mu2]\ p5[
          mu4] + \((6.60959527435573`*^-15 - 
            4.5618573949489366`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p2[
          mu3]\ p5[
          mu4] - \((1.7992246490671823`*^-17 + 
            4.424036866907484`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p2[
          mu3]\ p5[
          mu4] - \((1.546739497554165`*^-17 + 
            4.414940668465205`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p2[
          mu3]\ p5[
          mu4] - \((1.5467395345944102`*^-17 + 
            4.414940660820941`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p2[
          mu3]\ p5[
          mu4] - \((1.3160984116694851`*^-17 + 
            4.444829374323505`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p2[
          mu3]\ p5[
          mu4] - \((1.0317690280822297`*^-14 - 
            4.1031316086275514`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p3[
          mu1]\ p5[
          mu4] + \((2.0456594176463592`*^-17 + 
            4.164857704754494`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p3[
          mu1]\ p5[
          mu4] + \((1.821500321838786`*^-17 + 
            4.1790767060754255`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p3[
          mu1]\ p5[
          mu4] + \((1.8215003019022694`*^-17 + 
            4.17907674400086`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p3[
          mu1]\ p5[
          mu4] + \((1.5947196903796337`*^-17 + 
            4.175397522589383`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p3[
          mu1]\ p5[
          mu4] - \((1.0317690280822297`*^-14 - 
            4.1031316086275514`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p3[
          mu2]\ p5[
          mu4] + \((2.0456594869807543`*^-17 + 
            4.1648577133415407`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p3[
          mu2]\ p5[
          mu4] + \((1.8215003453376655`*^-17 + 
            4.179076719784053`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p3[
          mu2]\ p5[
          mu4] + \((1.8215003706236628`*^-17 + 
            4.1790767525904806`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p3[
          mu2]\ p5[
          mu4] + \((1.5947197132659097`*^-17 + 
            4.1753975363055396`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p3[
          mu2]\ p5[
          mu4] - \((2.1305660651320233`*^-17 + 
            3.945836499226251`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p3[
          mu2]\ p5[
          mu4] - \((1.892179906497845`*^-17 + 
            3.874376714196589`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p3[
          mu2]\ p5[
          mu4] - \((1.0317690280822297`*^-14 - 
            4.1031316086275514`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p3[
          mu3]\ p5[
          mu4] + \((2.0456594873809798`*^-17 + 
            4.164857779773058`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p3[
          mu3]\ p5[
          mu4] + \((1.8215003497886014`*^-17 + 
            4.179076789559043`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p3[
          mu3]\ p5[
          mu4] + \((1.8215003826834772`*^-17 + 
            4.1790767819306274`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p3[
          mu3]\ p5[
          mu4] + \((1.5947197293526546`*^-17 + 
            4.175397568983132`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p3[
          mu3]\ p5[
          mu4] - \((2.1305660635589358`*^-17 + 
            3.945836569587776`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p3[
          mu3]\ p5[
          mu4] - \((1.8921799233221275`*^-17 + 
            3.874376746640856`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p3[
          mu3]\ p5[
          mu4] - \((2.1305661245391724`*^-17 + 
            3.945836581667129`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p3[
          mu3]\ p5[
          mu4] - \((1.8921799426125965`*^-17 + 
            3.874376763830924`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p3[
          mu3]\ p5[
          mu4] + \((2.19029374585468`*^-17 + 
            3.4960860897970344`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p3[
          mu3]\ p5[
          mu4] - \((1.9906809962521932`*^-14 - 
            4.250918372090362`*^-14\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p4[
          mu1]\ p5[
          mu4] + \((2.120192526027719`*^-17 + 
            4.4397182035037007`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p4[
          mu1]\ p5[
          mu4] + \((1.6478692182958934`*^-17 + 
            4.172471695334666`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p4[
          mu1]\ p5[
          mu4] + \((1.6478692001848088`*^-17 + 
            4.172471732599272`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p4[
          mu1]\ p5[
          mu4] + \((1.2340803217558955`*^-17 + 
            3.902830619409202`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p4[
          mu1]\ p5[
          mu4] - \((1.830497094234421`*^-17 + 
            3.676205359460461`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p4[
          mu1]\ p5[
          mu4] - \((1.44141821631557`*^-17 + 
            3.4102274908748945`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p4[
          mu1]\ p5[
          mu4] - \((1.8304970928969666`*^-17 + 
            3.6762054285810096`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p4[
          mu1]\ p5[
          mu4] - \((1.441418231636401`*^-17 + 
            3.4102275227388896`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p4[
          mu1]\ p5[
          mu4] + \((1.6529639200464264`*^-17 + 
            2.923726403340959`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p4[
          mu1]\ p5[
          mu4] - \((1.9906809962521932`*^-14 - 
            4.250918372090362`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p4[
          mu2]\ p5[
          mu4] + \((2.120192578733212`*^-17 + 
            4.439718202184972`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p4[
          mu2]\ p5[
          mu4] + \((1.6478692290689132`*^-17 + 
            4.172471699086942`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p4[
          mu2]\ p5[
          mu4] + \((1.6478692530408924`*^-17 + 
            4.172471731284044`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p4[
          mu2]\ p5[
          mu4] + \((1.2340803326832402`*^-17 + 
            3.9028306231749135`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p4[
          mu2]\ p5[
          mu4] - \((1.8304970801296227`*^-17 + 
            3.6762053531228316`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p4[
          mu2]\ p5[
          mu4] - \((1.441418202977724`*^-17 + 
            3.410227484543152`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p4[
          mu2]\ p5[
          mu4] - \((1.8304971246963722`*^-17 + 
            3.676205423901012`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p4[
          mu2]\ p5[
          mu4] - \((1.441418225652384`*^-17 + 
            3.410227523124003`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p4[
          mu2]\ p5[
          mu4] + \((1.6529638933930163`*^-17 + 
            2.923726390132228`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p4[
          mu2]\ p5[
          mu4] - \((1.8140400606248985`*^-17 + 
            3.795210568631517`*^-17\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu1]\ p4[
          mu2]\ p5[
          mu4] - \((1.2683158805423884`*^-17 + 
            3.3382347901152024`*^-17\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu1]\ p4[
          mu2]\ p5[
          mu4] + \((1.42036941977461`*^-17 + 
            2.63760798136934`*^-17\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu1]\ p4[
          mu2]\ p5[
          mu4] - \((1.9906809962521932`*^-14 - 
            4.250918372090362`*^-14\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p4[
          mu3]\ p5[
          mu4] + \((2.12019258321301`*^-17 + 
            4.43971825297444`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p4[
          mu3]\ p5[
          mu4] + \((1.647869236477165`*^-17 + 
            4.17247175293937`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p4[
          mu3]\ p5[
          mu4] + \((1.6478692633364196`*^-17 + 
            4.172471749504453`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p4[
          mu3]\ p5[
          mu4] + \((1.2340803458825694`*^-17 + 
            3.9028306444428057`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p4[
          mu3]\ p5[
          mu4] - \((1.830497081438619`*^-17 + 
            3.6762053923230063`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p4[
          mu3]\ p5[
          mu4] - \((1.441418216195615`*^-17 + 
            3.4102274909345275`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p4[
          mu3]\ p5[
          mu4] - \((1.8304971382494133`*^-17 + 
            3.676205417868778`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p4[
          mu3]\ p5[
          mu4] - \((1.4414182373522826`*^-17 + 
            3.410227517397547`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p4[
          mu3]\ p5[
          mu4] + \((1.6529639027402405`*^-17 + 
            2.923726370577247`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p4[
          mu3]\ p5[
          mu4] - \((1.8140400846119843`*^-17 + 
            3.795210605377102`*^-17\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu1]\ p4[
          mu3]\ p5[
          mu4] - \((1.2683159152808958`*^-17 + 
            3.3382347943663295`*^-17\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu1]\ p4[
          mu3]\ p5[
          mu4] + \((1.4203694522034936`*^-17 + 
            2.637607961592814`*^-17\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu1]\ p4[
          mu3]\ p5[
          mu4] - \((1.8140401014910045`*^-17 + 
            3.795210625223738`*^-17\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu4] - \((1.2683158997347696`*^-17 + 
            3.3382348148341835`*^-17\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu4] + \((1.4203694140635873`*^-17 + 
            2.637607960170922`*^-17\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu4] + \((1.203073044703198`*^-17 + 
            2.4018196955155538`*^-17\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu2]\ p4[
          mu3]\ p5[
          mu4] + \((2.489979973901674`*^-13 - 
            2.783995893556392`*^-13\ \[ImaginaryI])\)\ g[mu2\ mu3]\ p5[
          mu1]\ p5[
          mu4] - \((1.8031559207365632`*^-16 + 
            3.1304990618979596`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p1[mu3]\ p5[
          mu1]\ p5[
          mu4] - \((1.4702199534465797`*^-16 + 
            2.984299153847255`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu2]\ p5[
          mu1]\ p5[
          mu4] - \((1.4702199527925765`*^-16 + 
            2.98429915381008`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu3]\ p5[
          mu1]\ p5[
          mu4] - \((1.1351852969841422`*^-16 + 
            2.7735347849828536`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p2[mu3]\ p5[
          mu1]\ p5[
          mu4] + \((1.6087710820623156`*^-16 + 
            2.620323707423755`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu2]\ p5[
          mu1]\ p5[
          mu4] + \((1.2640370209889841`*^-16 + 
            2.3814618592307684`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu2]\ p5[
          mu1]\ p5[
          mu4] + \((1.6087710815782035`*^-16 + 
            2.620323707570561`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu3]\ p5[
          mu1]\ p5[
          mu4] + \((1.2640370210976132`*^-16 + 
            2.381461859415424`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu3]\ p5[
          mu1]\ p5[
          mu4] - \((1.3544946803240726`*^-16 + 
            1.9308134085723614`*^-16\ \[ImaginaryI])\)\ p3[mu2]\ p3[mu3]\ p5[
          mu1]\ p5[
          mu4] + \((1.2831455506498944`*^-16 + 
            2.307859582201727`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu2]\ p5[
          mu1]\ p5[
          mu4] + \((9.39113577405462`*^-17 + 
            2.0482891630926694`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu2]\ p5[
          mu1]\ p5[
          mu4] - \((9.981532699131933`*^-17 + 
            1.5806956810572414`*^-16\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu2]\ p5[
          mu1]\ p5[
          mu4] + \((1.2831455507109005`*^-16 + 
            2.3078595842576967`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu4] + \((9.391135780969578`*^-17 + 
            2.0482891651243964`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu4] - \((9.981532707579682`*^-17 + 
            1.580695683046504`*^-16\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu4] - \((6.693919994397663`*^-17 + 
            1.208858574457352`*^-16\ \[ImaginaryI])\)\ p4[mu2]\ p4[mu3]\ p5[
          mu1]\ p5[
          mu4] + \((2.489979973901674`*^-13 - 
            2.783995893556392`*^-13\ \[ImaginaryI])\)\ g[mu1\ mu3]\ p5[
          mu2]\ p5[
          mu4] - \((1.8031558992834993`*^-16 + 
            3.130499042486628`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu3]\ p5[
          mu2]\ p5[
          mu4] - \((1.4702199313297652`*^-16 + 
            2.9842991343497295`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p2[mu1]\ p5[
          mu2]\ p5[
          mu4] - \((1.4702199313289924`*^-16 + 
            2.9842991343895645`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu3]\ p5[
          mu2]\ p5[
          mu4] - \((1.1351852748570573`*^-16 + 
            2.7735347654750023`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu3]\ p5[
          mu2]\ p5[
          mu4] + \((1.608771060615067`*^-16 + 
            2.6203236890900414`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p3[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((1.2640369994702034`*^-16 + 
            2.3814618408874824`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p3[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((1.6087710617827148`*^-16 + 
            2.620323689035769`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu3]\ p5[
          mu2]\ p5[
          mu4] + \((1.264037000638622`*^-16 + 
            2.3814618407932974`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu3]\ p5[
          mu2]\ p5[
          mu4] - \((1.3544946604733864`*^-16 + 
            1.9308133911148016`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu3]\ p5[
          mu2]\ p5[
          mu4] + \((1.2831455287911832`*^-16 + 
            2.3078595634951765`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p4[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((9.391135555519149`*^-17 + 
            2.0482891443771426`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p4[mu1]\ p5[
          mu2]\ p5[
          mu4] - \((9.981532499592114`*^-17 + 
            1.5806956634655668`*^-16\ \[ImaginaryI])\)\ p3[mu3]\ p4[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((1.2831455303697562`*^-16 + 
            2.3078595638671363`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu3]\ p5[
          mu2]\ p5[
          mu4] + \((9.391135571086143`*^-17 + 
            2.0482891446763132`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu3]\ p5[
          mu2]\ p5[
          mu4] - \((9.981532501314397`*^-17 + 
            1.580695663666752`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu3]\ p5[
          mu2]\ p5[
          mu4] - \((6.693919787099421`*^-17 + 
            1.208858554943486`*^-16\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu3]\ p5[
          mu2]\ p5[
          mu4] - \((5.794323334287816`*^-16 + 
            7.68393268839234`*^-16\ \[ImaginaryI])\)\ p1[mu3]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu4] - \((4.1336776174975636`*^-16 + 
            6.637957271037177`*^-16\ \[ImaginaryI])\)\ p2[mu3]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((3.6424054916720815`*^-16 + 
            4.113073497342693`*^-16\ \[ImaginaryI])\)\ p3[mu3]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((1.9617974255284657`*^-16 + 
            2.779426776408672`*^-16\ \[ImaginaryI])\)\ p4[mu3]\ p5[mu1]\ p5[
          mu2]\ p5[
          mu4] + \((2.489979973901674`*^-13 - 
            2.783995893556392`*^-13\ \[ImaginaryI])\)\ g[mu1\ mu2]\ p5[
          mu3]\ p5[
          mu4] - \((1.8031559047059208`*^-16 + 
            3.13049906535162`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p1[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((1.4702199366822461`*^-16 + 
            2.98429915726243`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p2[mu1]\ p5[
          mu3]\ p5[
          mu4] - \((1.470219937367349`*^-16 + 
            2.984299157211469`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p2[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((1.1351852808277318`*^-16 + 
            2.773534788347244`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p2[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((1.608771067188926`*^-16 + 
            2.620323711601765`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p3[mu1]\ p5[
          mu3]\ p5[
          mu4] + \((1.2640370066738214`*^-16 + 
            2.3814618633793874`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p3[mu1]\ p5[
          mu3]\ p5[
          mu4] + \((1.6087710660826729`*^-16 + 
            2.6203237106432227`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p3[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((1.2640370049321612`*^-16 + 
            2.3814618624504115`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p3[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((1.3544946660860193`*^-16 + 
            1.9308134126298537`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p3[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((1.2831455359318143`*^-16 + 
            2.3078595862330074`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p4[mu1]\ p5[
          mu3]\ p5[
          mu4] + \((9.391135632989315`*^-17 + 
            2.0482891670641226`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p4[mu1]\ p5[
          mu3]\ p5[
          mu4] - \((9.981532559591407`*^-17 + 
            1.5806956849838246`*^-16\ \[ImaginaryI])\)\ p3[mu2]\ p4[mu1]\ p5[
          mu3]\ p5[
          mu4] + \((1.2831455343553473`*^-16 + 
            2.3078595852009535`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p4[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((9.391135611109159`*^-17 + 
            2.0482891660914294`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p4[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((9.981532556686866`*^-17 + 
            1.580695685131775`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p4[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((6.693919846344848`*^-17 + 
            1.2088585764117145`*^-16\ \[ImaginaryI])\)\ p4[mu1]\ p4[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((5.794323335183234`*^-16 + 
            7.683932688318223`*^-16\ \[ImaginaryI])\)\ p1[mu2]\ p5[mu1]\ p5[
          mu3]\ p5[
          mu4] - \((4.1336776177698853`*^-16 + 
            6.637957270938508`*^-16\ \[ImaginaryI])\)\ p2[mu2]\ p5[mu1]\ p5[
          mu3]\ p5[
          mu4] + \((3.6424054917919247`*^-16 + 
            4.1130734972888937`*^-16\ \[ImaginaryI])\)\ p3[mu2]\ p5[mu1]\ p5[
          mu3]\ p5[
          mu4] + \((1.9617974257236957`*^-16 + 
            2.779426776409712`*^-16\ \[ImaginaryI])\)\ p4[mu2]\ p5[mu1]\ p5[
          mu3]\ p5[
          mu4] - \((5.794323333396362`*^-16 + 
            7.683932684999519`*^-16\ \[ImaginaryI])\)\ p1[mu1]\ p5[mu2]\ p5[
          mu3]\ p5[
          mu4] - \((4.1336776166061103`*^-16 + 
            6.637957267644356`*^-16\ \[ImaginaryI])\)\ p2[mu1]\ p5[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((3.64240549062815`*^-16 + 
            4.1130734939947417`*^-16\ \[ImaginaryI])\)\ p3[mu1]\ p5[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((1.9617974246438548`*^-16 + 
            2.7794267732622355`*^-16\ \[ImaginaryI])\)\ p4[mu1]\ p5[mu2]\ p5[
          mu3]\ p5[
          mu4] + \((3.3263263503051626`*^-16 + 
            4.782615768833141`*^-16\ \[ImaginaryI])\)\ p5[mu1]\ p5[mu2]\ p5[
          mu3]\ p5[mu4]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\(\(\(\(\(Ind[i - 1, j - 1, k - 1, l - 1] -> tens4th /. 
                    g[mu1_*mu2_] \[Rule] g[mu1, mu2]\) /. {mu1 \[Rule] i, 
                    mu2 \[Rule] j, mu3 \[Rule] k, mu4 \[Rule] l}\) /. 
                p_[mu_] \[RuleDelayed] 
                  ToExpression[ToString[p] <> ToString[mu]]\) /. 
              g[1, 1] \[Rule] 1\) /. g[mu_, mu_] \[Rule] \(-1\)\) /. 
          g[mu_, nu_] \[Rule] 0, {i, 1, 4}, {j, i, 4}, {k, j, 4}, {l, k, 4}] // 
      Flatten\)], "Input"],

Cell[BoxData[
    \({Ind[0, 0, 0, 0] \[Rule] 
        6.666147275729527`*^-10 + 2.4756161231185996`*^-10\ \[ImaginaryI], 
      Ind[0, 0, 0, 1] \[Rule] \(-2.0004895583475895`*^-11\) + 
          2.9403584481422584`*^-11\ \[ImaginaryI], 
      Ind[0, 0, 0, 2] \[Rule] 
        2.0097530201648664`*^-11 - 2.3733350697180223`*^-11\ \[ImaginaryI], 
      Ind[0, 0, 0, 3] \[Rule] 
        6.454768851109532`*^-11 - 1.6223586923419521`*^-10\ \[ImaginaryI], 
      Ind[0, 0, 1, 1] \[Rule] \(-1.169555292118783`*^-11\) - 
          5.1676016853657304`*^-11\ \[ImaginaryI], 
      Ind[0, 0, 1, 2] \[Rule] 
        1.6035731274742164`*^-12 + 2.222844319114726`*^-12\ \[ImaginaryI], 
      Ind[0, 0, 1, 3] \[Rule] 
        7.926925740281847`*^-12 + 7.295019093699456`*^-12\ \[ImaginaryI], 
      Ind[0, 0, 2, 2] \[Rule] \(-1.1183790670845636`*^-11\) - 
          5.131333743568485`*^-11\ \[ImaginaryI], 
      Ind[0, 0, 2, 3] \[Rule] \(-6.810864358408018`*^-12\) - 
          7.089323118699051`*^-12\ \[ImaginaryI], 
      Ind[0, 0, 3, 3] \[Rule] \(-8.044536135908119`*^-11\) - 
          8.019088608563344`*^-11\ \[ImaginaryI], 
      Ind[0, 1, 1, 1] \[Rule] 
        1.00497735275687`*^-11 - 1.5159802842262453`*^-14\ \[ImaginaryI], 
      Ind[0, 1, 1, 2] \[Rule] \(-3.4898417756151823`*^-12\) - 
          1.9543901000509893`*^-13\ \[ImaginaryI], 
      Ind[0, 1, 1, 3] \[Rule] \(-2.1111051125500102`*^-11\) + 
          2.9521175360456403`*^-12\ \[ImaginaryI], 
      Ind[0, 1, 2, 2] \[Rule] 
        3.5745540623331877`*^-12 + 6.6144962104073106`*^-15\ \[ImaginaryI], 
      Ind[0, 1, 2, 3] \[Rule] 
        1.215952049325409`*^-12 - 8.073964219913136`*^-14\ \[ImaginaryI], 
      Ind[0, 1, 3, 3] \[Rule] 
        8.25803075704191`*^-12 - 1.420858767159047`*^-12\ \[ImaginaryI], 
      Ind[0, 2, 2, 2] \[Rule] \(-9.589607460298402`*^-12\) - 
          5.859450463930449`*^-13\ \[ImaginaryI], 
      Ind[0, 2, 2, 3] \[Rule] \(-2.0923243104339734`*^-11\) + 
          2.8903086886669047`*^-12\ \[ImaginaryI], 
      Ind[0, 2, 3, 3] \[Rule] \(-8.02358872159878`*^-12\) + 
          9.947011077221174`*^-13\ \[ImaginaryI], 
      Ind[0, 3, 3, 3] \[Rule] \(-1.0257605603400408`*^-10\) + 
          3.7847566825961485`*^-11\ \[ImaginaryI], 
      Ind[1, 1, 1, 1] \[Rule] \(-2.4642664182306922`*^-11\) + 
          2.7632641517112114`*^-11\ \[ImaginaryI], 
      Ind[1, 1, 1, 2] \[Rule] 
        9.156784647391443`*^-13 - 6.606431293367227`*^-13\ \[ImaginaryI], 
      Ind[1, 1, 1, 3] \[Rule] 
        3.035281844234365`*^-12 - 2.8747877520681684`*^-12\ \[ImaginaryI], 
      Ind[1, 1, 2, 2] \[Rule] \(-8.226936218127186`*^-12\) + 
          9.196286081441803`*^-12\ \[ImaginaryI], 
      Ind[1, 1, 2, 3] \[Rule] \(-1.1629405263565283`*^-12\) + 
          1.0002364251955021`*^-12\ \[ImaginaryI], 
      Ind[1, 1, 3, 3] \[Rule] \(-1.469182358983655`*^-11\) + 
          1.8379858509495795`*^-11\ \[ImaginaryI], 
      Ind[1, 2, 2, 2] \[Rule] 
        9.082889528680016`*^-13 - 6.547197373422508`*^-13\ \[ImaginaryI], 
      Ind[1, 2, 2, 3] \[Rule] 
        1.0951108286976339`*^-12 - 1.0087646829484768`*^-12\ \[ImaginaryI], 
      Ind[1, 2, 3, 3] \[Rule] 
        7.173403177472985`*^-13 - 5.572934707190147`*^-13\ \[ImaginaryI], 
      Ind[1, 3, 3, 3] \[Rule] 
        4.506609564999767`*^-12 - 4.850645945141164`*^-12\ \[ImaginaryI], 
      Ind[2, 2, 2, 2] \[Rule] \(-2.45154788434634`*^-11\) + 
          2.7431326884456335`*^-11\ \[ImaginaryI], 
      Ind[2, 2, 2, 3] \[Rule] \(-3.184999989982737`*^-12\) + 
          2.7975033724243357`*^-12\ \[ImaginaryI], 
      Ind[2, 2, 3, 3] \[Rule] \(-1.463167281990077`*^-11\) + 
          1.829115336889147`*^-11\ \[ImaginaryI], 
      Ind[2, 3, 3, 3] \[Rule] \(-4.773355875295484`*^-12\) + 
          4.773684727634442`*^-12\ \[ImaginaryI], 
      Ind[3, 3, 3, 3] \[Rule] \(-7.301676490852622`*^-11\) + 
          1.1286526165867085`*^-10\ \[ImaginaryI]}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 800}},
WindowSize->{1270, 747},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 45, 1, 27, "Input"],
Cell[1824, 56, 82, 1, 39, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1943, 62, 57, 1, 27, "Input"],
Cell[2003, 65, 65, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2105, 71, 134, 4, 46, "Subsection"],
Cell[2242, 77, 398, 7, 75, "Input"],

Cell[CellGroupData[{
Cell[2665, 88, 172, 2, 27, "Input"],
Cell[2840, 92, 133, 2, 30, "Output"]
}, Open  ]],
Cell[2988, 97, 223, 3, 107, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3248, 105, 95, 1, 46, "Subsection"],
Cell[3346, 108, 2029, 36, 347, "Input"],
Cell[5378, 146, 1566, 36, 587, "Input"],

Cell[CellGroupData[{
Cell[6969, 186, 31, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[7025, 190, 185, 3, 27, "Input"],
Cell[7213, 195, 111, 2, 30, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7373, 203, 31, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[7429, 207, 228, 3, 27, "Input"],
Cell[7660, 212, 553, 10, 54, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8250, 227, 170, 4, 27, "Input"],
Cell[8423, 233, 436, 9, 32, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8908, 248, 41, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[8974, 252, 233, 3, 27, "Input"],
Cell[9210, 257, 2921, 51, 208, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12168, 313, 446, 8, 59, "Input"],
Cell[12617, 323, 1078, 20, 91, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13744, 349, 41, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[13810, 353, 267, 4, 27, "Input"],
Cell[14080, 359, 16293, 261, 1418, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30410, 625, 477, 8, 43, "Input"],
Cell[30890, 635, 2174, 41, 148, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33113, 682, 41, 0, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[33179, 686, 296, 4, 43, "Input"],
Cell[33478, 692, 101120, 2100, 7710, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[134635, 2797, 512, 8, 59, "Input"],
Cell[135150, 2807, 3904, 70, 243, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

