(*************************************************************************************************************)
(******                   This is the FeynRules mod-file for the type II SeeSaw				******)
(******               Without neutrino Yukawa and neutrinos are in the flavor basis			******)
(******                    Authors:  Dipankar Das, Magdalena Kordiaczynska				******)
(******                                File is available at						******)
(******                           http://prac.us.edu.pl/~gluza/mkord/					******)
(******													******)
(******                            In case of use, please, refer to					******)
(******													******)
(******      "Doubly Charged Higgs Bosons and Spontaneous Symmetry Breaking at eV and TeV Scales",	******)
(******                         J. Gluza, M. Kordiaczyńska, T. Srivastava				******)	
(******                      Published in Published in: Symmetry 12 (2020) 1, 153			******)
(******                                  DOI: 10.3390/sym12010153					******)
(******													******)
(******                "Updated scalar sector constraints in the Higgs triplet model"			******)
(******                                    D. Das, A. Santamaria					******)
(******                          Published in: Phys.Rev.D 94 (2016) 1, 015015				******)
(******                                 e-Print: 1604.08099 [hep-ph]					******)
(*************************************************************************************************************)

M$ModelName = "Type II SeeSaw";

(* The Feynman gauge switch allows to activiate the QCD ghosts (needed, e.g. by CalcHep)   *)
   
M$Information = {Authors -> {"Dipankar Das", "Magdalena Kordiaczynska"}, 
             Version -> "1.0",
             Date -> "07. 06. 2016",
             Institutions -> {"University of Valencia", "University of Silesia"},
             (* URLs  -> "http://prac.us.edu.pl/~gluza/mkord/", *)
             Emails -> {"dipankar.das@uv.es", "mkordiaczynska@us.edu.pl"}};

FeynmanGauge = True;

FR$LoopSwitches = {{Gf, MW}};
FR$RmDblExt = { ymb -> MB, ymc -> MC, ymdo -> MD, yme -> Me, ymm -> MMU, yms -> MS, ymt -> MT, ymtau -> MTA, ymup -> MU};


(******* Index definitions ********)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];


IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {QED, 2}
};



(* ************************** *)
(* *****      vevs      ***** *)
(* ************************** *)
M$vevs = { {Phi[2],vevd} };


(******* Gauge parameters (for FeynArts) ********)

GaugeXi[ V[1] ] = GaugeXi[A];
GaugeXi[ V[2] ] = GaugeXi[Z];
GaugeXi[ V[3] ] = GaugeXi[W];
GaugeXi[ V[4] ] = GaugeXi[G];
GaugeXi[ S[1] ] = 1;
GaugeXi[ S[2] ] = GaugeXi[Z];
GaugeXi[ S[3] ] = GaugeXi[W];
GaugeXi[ U[1] ] = GaugeXi[A];
GaugeXi[ U[2] ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4] ] = GaugeXi[G];


(************** Gauge Groups ******************)

M$GaugeGroups = {
  U1Y  == { 
    Abelian          -> True,  
    CouplingConstant -> g1, 
    GaugeBoson       -> B, 
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> G,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};

Get["Params_NH.fr"];

Get["SMParts.fr"];

Get["Lag.fr"];

(** Get["HiggsPart.fr"]; **)


(** M$ClassesDescription = Join[M$FermionFields, M$HiggsFields]; **)




