

(*****************************************************************************************)

(* SM Lagrangian *)

(******************** Gauge F^2 Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
LGauge := Block[{mu,nu,ii,aa}, 
  ExpandIndices[-1/4 FS[B,mu,nu] FS[B,mu,nu] - 1/4 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa], FlavorExpand->SU2W]];


(********************* Fermion Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
LFermions := Block[{mu}, 
  ExpandIndices[I*(
    QLbar.Ga[mu].DC[QL, mu] + LLbar.Ga[mu].DC[LL, mu] + uRbar.Ga[mu].DC[uR, mu] + dRbar.Ga[mu].DC[dR, mu] + lRbar.Ga[mu].DC[lR, mu]), 
  FlavorExpand->{SU2W,SU2D}]/.{CKM[a_,b_] Conjugate[CKM[a_,c_]]->IndexDelta[b,c], CKM[b_,a_] Conjugate[CKM[c_,a_]]->IndexDelta[b,c]}];
    



(**************Ghost terms (Removed), to add uncomment LGhost **************************)
(* Now we need the ghost terms which are of the form:             *)
(* - g * antighost * d_BRST G                                     *)
(* where d_BRST G is BRST transform of the gauge fixing function. *)

(*
LGhost := Block[{LGh1,LGhw,LGhs,LGhphi,mu, generators,gh,ghbar,Vectorize,phix1,phix2,togoldstones,doublet,doublet0},
  (* Pure gauge piece *) 	
  LGh1 = -ghBbar.del[DC[ghB,mu],mu];
  LGhw = -ghWibar.del[DC[ghWi,mu],mu];
  LGhs = -ghGbar.del[DC[ghG,mu],mu];

  (* Scalar pieces: see Peskin pages 739-742 *)
  (* phix1 and phix2 are the real degrees of freedom of GP *)
  (* Vectorize transforms a doublet in a vector in the phi-basis, i.e. the basis of real degrees of freedom *)
  gh    = {ghB, ghWi[1], ghWi[2], ghWi[3]};
  ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
  generators = {-I/2 g1 IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
  doublet = Expand[{(-I phix1 - phix2)/Sqrt[2], Phi1[2]} /. MR$Definitions /. vev -> 0]; 
  doublet0 = {0, vev/Sqrt[2]};
  Vectorize[{a_, b_}]:= Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]}/.{Im[_]->0, Re[num_]->num}];
  togoldstones := {phix1 -> (GP + GPbar)/Sqrt[2], phix2 -> (-GP + GPbar)/(I Sqrt[2])};
  LGhphi=Plus@@Flatten[Table[-ghbar[[kkk]].gh[[lll]] Vectorize[generators[[kkk]].doublet0].Vectorize[generators[[lll]].(doublet+doublet0)],{kkk,4},{lll,4}]] /.togoldstones;

ExpandIndices[ LGhs + If[FeynmanGauge, LGh1 + LGhw + LGhphi,0], FlavorExpand->SU2W]];
*)

	
(*Higgs sectors*)

(* The doublet *)

Phip := { phi1, (vevd + phi0Re + I phi0Im )/Sqrt[2]} ;
Phipbar := { phi1bar , ( vevd + phi0Re - I phi0Im )/Sqrt[2]} ;

(* The triplet *)

Delta := { -d2, d1, (vevt + d0Re + I d0Im )/Sqrt[2]} ;
Deltabar := { -d2bar, d1bar, (vevt + d0Re - I d0Im )/Sqrt[2]} ;

(********** Higgs Kinetic terms ************) 

LHiggsKin := Block[{ii,mu, PMVec, WVec, Dc, Dcbar, feynmangaugerules,LTKin},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];  
  
  (** Spin matrices in dimension 3 **)
  PMVec = { 1/Sqrt[2] {{0, 1, 0}, {1, 0, 1}, {0, 1, 0}},
            1/Sqrt[2] {{0, -I, 0}, {I, 0, -I}, {0, I, 0}},
            {{1 , 0 , 0} , {0 , 0 , 0} , {0 , 0 , -1}} };
  Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

  Dc[d_, mu_] := del[d, mu] -I (ee/cw B[mu] d + ee/sw(Wvec[mu].PMVec).d);
  Dcbar[d_, mu_] := del[d, mu] +I (ee/cw B[mu] d + ee/sw d.(Wvec[mu].PMVec));

  LTKin := (Dcbar[Deltabar,mu]).Dc[Delta,mu] ;
       
  ExpandIndices[DC[Phibar[ii],mu] DC[Phi[ii],mu] + LTKin, FlavorExpand->{SU2D,SU2W}]/.feynmangaugerules
 ];

(******** Higgs Potential **********)

VHiggs := Block [{DeltaM, DeltaMbar, feynmangaugerules, V2, V3, V4},
        feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];

   (**** 2X2 Representation of the Higgs triplet *****)

        DeltaM := { { d1/Sqrt[2], d2 }, {( vevt + d0Re + I d0Im )/Sqrt[2], -d1/Sqrt[2]} } ;
        DeltaMbar := { { d1bar/Sqrt[2], ( vevt + d0Re - I d0Im )/Sqrt[2]}, { d2bar, -d1bar/Sqrt[2]} };

   (***** Bilinear terms *****)
        V2 := -mph (Phipbar.Phip) +mchi Tr[DeltaMbar.DeltaM] ;

   (***** Trilinear terms *****)
        V3 := mtri (Phip.( I PauliMatrix[2]).DeltaMbar.Phip + HC[Phip.( I PauliMatrix[2]).DeltaMbar.Phip]) ;

   (***** Quartic terms *****)
        V4 := lph/4 (Phipbar.Phip)^2 +l1 (Phipbar.Phip) Tr[DeltaMbar.DeltaM] +l2 (Tr[DeltaMbar.DeltaM])^2 
              +l3 (Tr[DeltaMbar.DeltaM.DeltaMbar.DeltaM]) +l4 Phipbar.(DeltaM.DeltaMbar).Phip ;

        V2 + V3 + V4 ];

(****** Total Higgs Lagrangian **********)

 LHiggs := LHiggsKin - VHiggs ;

(***** The doublet Yukawa *****)

LYukawaD := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,yuk1,yuk2,yuknu,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  yuk1 = ExpandIndices[
   -yd[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR[sp, ff3, cc] Phi[ii] - 
    yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phi[ii], FlavorExpand -> SU2D];
  yuk1 = yuk1 /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
 
  yuk2 = ExpandIndices[- yu[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] Phibar[jj] Eps[ii, jj], FlavorExpand -> SU2D];
  yuk2 = yuk2 /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};

    yuk=yuk1+yuk2;
  yuk+HC[yuk]/.feynmangaugerules
 ];

 (***** The triplet Yukawa *****)

LYukT := CC[lbar].Ynu.ProjM.l d2 +1/Sqrt[2] ( CC[lbar].Ynu.ProjM.vl + CC[vlbar].Ynu.ProjM.l ) d1 
               -CC[vlbar].Ynu.ProjM.vl ( vevt + d0Re + I d0Im )/Sqrt[2] ;

LYukawaT := LYukT + HC[LYukT]/. { PMNS[a_, b_] Conjugate[PMNS[a_, c_]] -> IndexDelta[b, c], PMNS[b_, a_] Conjugate[PMNS[c_, a_]] -> IndexDelta[b, c]} ;

  (***** Total Yukawa *****)
LYukawa := LYukawaD + LYukawaT ;
		
		
LHTM := LGauge + LFermions + LHiggs + LYukawa ;
