
(****************  Parameters *************)

M$Parameters = {

  (* External parameters > SM sector *)

  \[Alpha]EWM1== {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEWM1,
        InteractionOrder -> {QED, -2},
        Value -> 127.9,
        Description -> "Inverse of the electroweak coupling constant"},

  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        InteractionOrder -> {QED, 2},
        Value -> 1.16639 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.118,
        Description -> "Strong coupling constant at the Z pole."},

  (* External parameters > Coming from the scalar sector, physical scalar masses fall in this category *)

  (* Give the triplet vev in GeV *)
  vevt == {
        TeX -> Subscript[v, t],
        ParameterType -> External,
        BlockName -> HIGGSINPUTS,
        InteractionOrder -> {QED, -1},
        Value -> 1.0,
        Description -> "Triplet vev in GeV"},

(** Sin-alpha is, in general, an ext parameter. But the phenomenologically interesting case would be sa = 2 vevt/vevd **)
  
  (**** sa == {                          ****)
  (****        ParameterType -> External, ****)      
  (****        BlockName -> HIGGSINPUTS,  ****)      
  (****        Value -> 0.0,              ****)      
  (****        Description -> "Sin(a)"},  ****)      

  

(* Yukawa masses *)
  
  ymdo == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 1,
    Value         -> 5.04*^-3,
    Description   -> "Down Yukawa mass"
  },
  ymup == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 2,
    Value         -> 2.55*^-3,
    Description   -> "Up Yukawa mass"
  },
  yms == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 3,
    Value         -> 0.101,
    Description   -> "Strange Yukawa mass"
  },
  ymc == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 4,
    Value         -> 1.27,
    Description   -> "Charm Yukawa mass"
  },
  ymb == {
    ParameterType -> External,
    InteractionOrder->{YB,1},
    BlockName     -> YUKAWA,
    OrderBlock    -> 5,
    Value         -> 4.7,
    Description   -> "Bottom Yukawa mass"
  },
  ymt == {
    ParameterType -> External,
    InteractionOrder->{YT,1},
    BlockName     -> YUKAWA,
    OrderBlock    -> 6,
    Value         -> 172,
    Description   -> "Top Yukawa mass"
  },
  yme == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 11,
    Value         -> 5.11*^-4,
    Description   -> "Electron Yukawa mass"
  },
  ymm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 13,
    Value         -> 0.10566,
    Description   -> "Muon Yukawa mass"
  },
  ymtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 15,
    Value         -> 1.777,
    Description   -> "Tau Yukawa mass"
  },




   (* Internal Parameters *)

  \[Alpha]EW == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]EWM1,
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Description -> "Electroweak coupling contant"},


  MW == {
        ParameterType -> Internal,
        Value -> Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]*\[Alpha]EW/Gf*MZ^2]],
        Description -> "W mass"},

  sw2 == {
        ParameterType -> Internal,
        Value -> 1-(MW/MZ)^2,
        Description -> "Squared Sin of the Weinberg angle"},

   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},

   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - sw2],
        Description -> "Cos of the Weinberg angle"},  

   sw == {
        TeX -> Subscript[s, w],
        ParameterType -> Internal,
        Value -> Sqrt[sw2],
        Description -> "Sin of the Weinberg angle"},  

   gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Definitions   -> {gw-> ee/sw},
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Definitions   -> {g1-> ee/cw},
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},
   
   vev == {
        ParameterType -> Internal,
        Value -> 2*MW*sw/ee,
        InteractionOrder -> {QED, -1},
        Description -> "Electroweak VEV"},

   vevd == {
        TeX -> Subscript[v, d],
        ParameterType -> Internal,
        Value -> Sqrt[vev^2 - 2*vevt^2],
        InteractionOrder -> {QED, -1},
        Description -> "VEV of doublet"},

   
   sa == {
        TeX -> Subscript[s, \[Alpha]],
        ParameterType -> Internal,
        Value -> 2*vevt/vev,
        Description -> "Sin alpha"},

   ca == {
        TeX -> Subscript[c, \[Alpha]],
        ParameterType -> Internal,
        Value -> Sqrt[1-sa^2],
        Description -> "Cos alpha"},  

   sb == {
        TeX -> Subscript[s, b],
        ParameterType -> Internal,
        Value -> Sqrt[2]*vevt/vev,
        Description -> "Sin-Beta"},

   cb == {
        TeX -> Subscript[c, b],
        ParameterType -> Internal,
        Value -> Sqrt[1-sb^2],
        Description -> "Cos-Beta"},

   sbp == {
        TeX -> Subscript[sP, b],
        ParameterType -> Internal,
        Value -> 2*vevt/(Sqrt[vevd^2 + 4*vevt^2]),
        Description -> "Sin Beta-prime"},

   cbp == {
        TeX -> Subscript[cP, b],
        ParameterType -> Internal,
        Value -> Sqrt[1-sbp^2],
        Description -> "Cos Beta-prime"},

   
(* CKM sector : Taking into account nonzero 31 and 32 elements *)

(* Define the Wolfenstein parameters as external parameters *)

  lamC == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 1,
    Value         -> 0.225,
    TeX           -> Subscript[\[Lambda], c],
    Description   -> "Cabibbo angle"
  },

  AC == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 2,
    Value         -> 0.811,
    TeX           -> A,
    Description   -> "Wolfenstein parameter A"
  },

  rhoCb == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 3,
    Value         -> 0.131,
    TeX           -> Subscript[\[Rho], b],
    Description   -> "Redefined Wolfenstein parameter rho"
  },

  etaCb == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 4,
    Value         -> 0.345,
    TeX           -> Subscript[\[Eta], b],
    Description   -> "Redefined Wolfenstein parameter eta"
  },

  rhoC == {
        ParameterType -> Internal,
        TeX           -> \[Rho],
        Value -> rhoCb/(1-lamC^2/2),
        Description -> "Wolfenstein parameter rho"},

  etaC == {
        ParameterType -> Internal,
        TeX           -> \[Eta],
        Value -> etaCb/(1-lamC^2/2),
        Description -> "Wolfenstein parameter eta"},


 CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    Unitary       -> True,
    Value         -> {CKM[1,1] -> 1-lamC^2/2,  CKM[1,2] -> lamC,                    CKM[1,3] -> AC lamC^3 (1/2 I etaC lamC^2-I etaC+rhoC),
                      CKM[2,1] -> -lamC,       CKM[2,2] -> -(I AC^2 etaC lamC^4)-lamC^2/2+1, CKM[2,3] -> AC lamC^2 (1+I etaC lamC^2),
                      CKM[3,1] -> AC lamC^3 (-I etaC-rhoC+1),           CKM[3,2] -> -AC lamC^2,                               CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"},


 (****** THE PMNS MATRIX ******)
 (****** Take the mixing angles and the mass squared diff as external parameters from http://www.nu-fit.org/?q=node/12 ******)
 (** Take the lightest neutrino mass as external input too. Treat the Dirac and Majorana Phases similarly **) 
 (** Give all the angles and the phases in radian **)

 th12 == {
    ParameterType -> External,
    BlockName     -> PMNSBLOCK,
    OrderBlock    -> 1,
    Value         -> Pi*33.72/180,
    TeX           -> Subscript[\[Theta], 12],
    Description   -> "Theta-12"
  },

  th23 == {
    ParameterType -> External,
    BlockName     -> PMNSBLOCK,
    OrderBlock    -> 2,
    Value         -> Pi*49.5/180,
    TeX           -> Subscript[\[Theta], 23],
    Description   -> "Theta-23"
  },  

th13 == {
    ParameterType -> External,
    BlockName     -> PMNSBLOCK,
    OrderBlock    -> 3,
    Value         -> Pi*8.5/180,
    TeX           -> Subscript[\[Theta], 13],
    Description   -> "Theta-13"
  },

dD == {
    ParameterType -> External,
    BlockName     -> PMNSBLOCK,
    OrderBlock    -> 4,
    Value         -> 0,
    TeX           -> Subscript[\[Alpha], D],
    Description   -> "Dirac CP-phase"
  },

am1 == {
    ParameterType -> External,
    BlockName     -> PMNSBLOCK,
    OrderBlock    -> 5,
    Value         -> 0,
    TeX           -> Subscript[\[Alpha], 1],
    Description   -> "First Majorana phase"
  },

am2 == {
    ParameterType -> External,
    BlockName     -> PMNSBLOCK,
    OrderBlock    -> 6,
    Value         -> 0,
    TeX           -> Subscript[\[Alpha], 2],
    Description   -> "Second Majorana phase"
  },

c12 == {
        TeX -> Subscript[c, 12],
        ParameterType -> Internal,
        Value -> Cos[th12],
        Description -> "Cos th12"},  

s12 == {
        TeX -> Subscript[s, 12],
        ParameterType -> Internal,
        Value -> Sin[th12],
        Description -> "Sin th12"},

c23 == {
        TeX -> Subscript[c, 23],
        ParameterType -> Internal,
        Value -> Cos[th23],
        Description -> "Cos th23"},  

s23 == {
        TeX -> Subscript[s, 23],
        ParameterType -> Internal,
        Value -> Sin[th23],
        Description -> "Sin th23"},

c13 == {
        TeX -> Subscript[c, 13],
        ParameterType -> Internal,
        Value -> Cos[th13],
        Description -> "Cos th13"},  

s13 == {
        TeX -> Subscript[s, 13],
        ParameterType -> Internal,
        Value -> Sin[th13],
        Description -> "Sin th13"},

PMNS == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    ComplexParameter -> True,
    Value         -> {PMNS[1,1] -> c12*c13*(Cos[am1] + I Sin[am1]),  
                      PMNS[1,2] -> s12*c13*(Cos[am2] + I Sin[am2]),                    
                      PMNS[1,3] -> s13*(Cos[dD] - I Sin[dD]),
                      PMNS[2,1] -> -s12*c23*(Cos[am1] + I Sin[am1]) -c12*s23*s13*(Cos[dD+am1] + I Sin[dD+am1]),       
                      PMNS[2,2] -> c12*c23*(Cos[am2] + I Sin[am2]) -s12*s23*s13*(Cos[dD+am2] + I Sin[dD+am2]), 
                      PMNS[2,3] -> s23*c13,
                      PMNS[3,1] -> s12*s23*(Cos[am1] + I Sin[am1]) -c12*c23*s13*(Cos[dD+am1] + I Sin[dD+am1]),           
                      PMNS[3,2] -> -c12*s23*(Cos[am2] + I Sin[am2]) -s12*c23*s13*(Cos[dD+am2] + I Sin[dD+am2]),                               
                      PMNS[3,3] -> c23*c13},
    TeX         -> Superscript[V,PMNS],
    Description -> "PMNS-Matrix"},

 (**** Neutrino masses (NH), m1 is the lightest ****)

 mv0 == {
    ParameterType -> External,
    BlockName     -> NUBLOCK,
    OrderBlock    -> 1,
    Value         -> 0,  (** in eV **)
    TeX           -> Subscript[m, 0],
    Description   -> "Lightest neutrino mass in eV"
  },

Dv12 == {
    ParameterType -> External,
    BlockName     -> NUBLOCK,
    OrderBlock    -> 2,
    Value         -> 7.5*10^(-5),  (** in eV^2 **)
    TeX           -> Superscript[\[Delta]m12, 2],
    Description   -> "Solar mass difference in eV^2"
  },

Dv13 == {
    ParameterType -> External,
    BlockName     -> NUBLOCK,
    OrderBlock    -> 3,
    Value         -> 2.48*10^(-3),  (** in eV^2 **)
    TeX           -> Superscript[\[Delta]m13, 2],
    Description   -> "Atmospheric mass difference in eV^2"
  },

Mv1 == {
        TeX -> Subscript[m, 1],
        ParameterType -> Internal,
        Value ->  mv0*10^(-9),
        Description -> "first neutrino mass in GeV"},

Mv2 == {
        TeX -> Subscript[m, 2],
        ParameterType -> Internal,
        Value -> Sqrt[Dv12 + mv0^2]*10^(-9),
        Description -> "second neutrino mass in GeV"},  

Mv3 == {
        TeX -> Subscript[m, 3],
        ParameterType -> Internal,
        Value -> Sqrt[Dv13 + mv0^2]*10^(-9),
        Description -> "third neutrino mass in GeV"},  

(***********  Triplet Yukawa Matrix   *************)

Ynu == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True,
    Value         -> {Ynu[1,1] -> Conjugate[(PMNS[1,1]*PMNS[1,1]*Mv1 +PMNS[1,2]*PMNS[1,2]*Mv2 +PMNS[1,3]*PMNS[1,3]*Mv3)]/(Sqrt[2]*vevt),  
                      Ynu[1,2] -> Conjugate[(PMNS[1,1]*PMNS[2,1]*Mv1 +PMNS[1,2]*PMNS[2,2]*Mv2 +PMNS[1,3]*PMNS[2,3]*Mv3)]/(Sqrt[2]*vevt),
                      Ynu[1,3] -> Conjugate[(PMNS[1,1]*PMNS[3,1]*Mv1 +PMNS[1,2]*PMNS[3,2]*Mv2 +PMNS[1,3]*PMNS[3,3]*Mv3)]/(Sqrt[2]*vevt),
                      Ynu[2,1] -> Conjugate[(PMNS[2,1]*PMNS[1,1]*Mv1 +PMNS[2,2]*PMNS[1,2]*Mv2 +PMNS[2,3]*PMNS[1,3]*Mv3)]/(Sqrt[2]*vevt),       
                      Ynu[2,2] -> Conjugate[(PMNS[2,1]*PMNS[2,1]*Mv1 +PMNS[2,2]*PMNS[2,2]*Mv2 +PMNS[2,3]*PMNS[2,3]*Mv3)]/(Sqrt[2]*vevt),
                      Ynu[2,3] -> Conjugate[(PMNS[2,1]*PMNS[3,1]*Mv1 +PMNS[2,2]*PMNS[3,2]*Mv2 +PMNS[2,3]*PMNS[3,3]*Mv3)]/(Sqrt[2]*vevt),
                      Ynu[3,1] -> Conjugate[(PMNS[3,1]*PMNS[1,1]*Mv1 +PMNS[3,2]*PMNS[1,2]*Mv2 +PMNS[3,3]*PMNS[1,3]*Mv3)]/(Sqrt[2]*vevt),
                      Ynu[3,2] -> Conjugate[(PMNS[3,1]*PMNS[2,1]*Mv1 +PMNS[3,2]*PMNS[2,2]*Mv2 +PMNS[3,3]*PMNS[2,3]*Mv3)]/(Sqrt[2]*vevt),
                      Ynu[3,3] -> Conjugate[(PMNS[3,1]*PMNS[3,1]*Mv1 +PMNS[3,2]*PMNS[3,2]*Mv2 +PMNS[3,3]*PMNS[3,3]*Mv3)]/(Sqrt[2]*vevt)},
    TeX         -> Superscript[Y,\[Nu]],
    InteractionOrder -> {QED, 1},
    Description -> "Neutrino Yukawa Matrix"},


(* Higgs selfcouplings, k1 and k2 takes care of the effect of lambda2 and lambda3 *)

k1 == {
        ParameterType -> External,
        BlockName -> HIGGSINPUTS,
        Value -> 1.0,
        Description -> "Departure from the sum rules 1"},

k2 == {
        ParameterType -> External,
        BlockName -> HIGGSINPUTS,
        Value -> 1.0,
        Description -> "Departure from the sum rules 2"},

(* Pseudoscalar and Singly charged scalar masses are declared Internal, check that they are real and positive *)

MPs == {
        ParameterType -> Internal,
        TeX -> Subscript[M, A],
        Value -> Sqrt[(vevd^2 + 4 vevt^2)(MHh^2 ca^2 + MHl^2 sa^2 -k1 vevt^2)/vevd^2],
        Description -> "Pseudosalar Mass"},

MCh == {
        ParameterType -> Internal,
        TeX -> Subscript[M, C],
        Value -> Sqrt[(vevd^2 + 2 vevt^2) (MCC^2 +(vevd^2 MPs^2)/(vevd^2 + 4 vevt^2) - k2 vevt^2)/(2 vevd^2)],
        Description -> "Singly charged scalar Mass"},

      
 
(* Trilinear parameters in the potential *)

  mtri == {
        ParameterType -> Internal,
        TeX -> \[Mu],
        Value -> (Sqrt[2] vevt MPs^2)/(vevd^2 + 4 vevt^2),
        InteractionOrder -> {QED,1},
        Description -> "Mu"},


  (* Quartic parameters in the potential *)

  l1 == {
        ParameterType -> Internal,
        TeX -> Subscript[\[Lambda], 1],
        Value -> (4 MCh^2)/(vevd^2 + 2 vevt^2) -(2 MPs^2)/(vevd^2 + 4 vevt^2) +((sa ca)/(vevd vevt)) (MHl^2 - MHh^2),
        InteractionOrder -> {QED, 2},
        Description -> "lambda-1"},

  l2 == {
        ParameterType -> Internal,
        TeX -> Subscript[\[Lambda], 2],
        Value -> ((sa^2 MHl^2 + ca^2 MHh^2)/2 +(vevd^2 MPs^2)/(2 (vevd^2 + 4 vevt^2)) -(2 vevd^2 MCh^2)/(vevd^2 + 2 vevt^2) +MCC^2)/vevt^2,
        InteractionOrder -> {QED, 2},
        Description -> "lambda-2"},

  l3 == {
        ParameterType -> Internal,
        TeX -> Subscript[\[Lambda], 3],
        Value -> ((2 vevd^2 MCh^2)/(vevd^2 + 2 vevt^2) -(vevd^2 MPs^2)/(vevd^2 + 4 vevt^2) -MCC^2)/vevt^2,
        InteractionOrder -> {QED, 2},
        Description -> "lambda-3"},

  l4 == {
        ParameterType -> Internal,
        TeX -> Subscript[\[Lambda], 4],
        Value -> (4 MPs^2)/(vevd^2 + 4 vevt^2) - (4 MCh^2)/(vevd^2 + 2 vevt^2),
        InteractionOrder -> {QED, 2},
        Description -> "lambda-4"},

  lph == {
        ParameterType -> Internal,
        TeX -> Subscript[\[Lambda], \[Phi]],
        Value -> 2(sa^2 MHh^2 + ca^2 MHl^2)/vevd^2,
        InteractionOrder -> {QED, 2},
        Description -> "lambda-phi"},

  (* Bilinear coefficients in the potential *)

  mph == {
        ParameterType -> Internal,
        TeX -> Superscript[m\[Phi], 2],
        Value -> (vevd^2 lph + 2 vevt (vevt (l1+l4) -2 Sqrt[2] mtri))/4,
        Description -> "mphi squared"},

  mchi == {
        ParameterType -> Internal,
        TeX -> Superscript[m\[Chi], 2],
        Value -> -(2 vevt^3 (l2+l3) + vevd^2 (vevt (l1+l4) - Sqrt[2] mtri))/(2 vevt),
        Description -> "mchi squared"},



(* Yukawa Matrices > the doublet couples to the quarks and the charged leptons *)

  
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yu[1,1] -> Sqrt[2] ymup/vevd, yu[2,2] -> Sqrt[2] ymc/vevd, yu[3,3] -> Sqrt[2] ymt/vevd},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yu[1,1] -> yup, yu[2,2] -> yc, yu[3,3] -> yt},
    TeX              -> Superscript[y, u],
    Description      -> "Up-type Yukawa couplings"
  },

  
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yd[1,1] -> Sqrt[2] ymdo/vevd, yd[2,2] -> Sqrt[2] yms/vevd, yd[3,3] -> Sqrt[2] ymb/vevd},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yd[1,1] -> ydo, yd[2,2] -> ys, yd[3,3] -> yb},
    TeX              -> Superscript[y, d],
    Description      -> "Down-type Yukawa couplings"
  },


  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yl[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yl[1,1] -> Sqrt[2] yme / vevd, yl[2,2] -> Sqrt[2] ymm / vevd, yl[3,3] -> Sqrt[2] ymtau / vevd},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yl[1,1] -> ye, yl[2,2] -> ym, yl[3,3] -> ytau},
    TeX              -> Superscript[y, l],
    Description      -> "Lepton Yukawa couplings"
  }

  

}
