
#include <iostream>
#include <cstdlib> 
#include <iomanip>
#include <fstream>
using namespace std;

// NOTE: you probably will never need to include theses files, 
// favorable way is like in example_1
#include "../../src/initIntegralsMem.h"

#include "../../src/I4I3I2.h" 
//needed for calling the internal functions I4, I3 and I2, 
//normally simply include libolec.h and call the contracting functions

//OL wrapping functions
#include "../OLEC_OL/OLEC_OL.h"

#include "clooptools.h"
 
int equals(double a, double b){
if(abs(a-b)>0.0000000001)
  return 0;
else return 1;

}

int main(int argc, char*argv[]){
  
  
 double m1s,  m2s,   m3s,   m4s,   m5s, 
	p1s,  p2s,   p3s,   p4s,   p5s,
	s12,  s23,   s34,   s45,   s15;

 double p1p1, p2p2, p3p3, p4p4, p5p5,
                   p1p2, p1p3, p1p4, p1p5, p2p3, p2p4, p2p5, p3p4, p3p5, p4p5;
                   

     double me = 0.51099906e-3;
        double mu = 0.1056583568;
        double mf = 0.0;
        double me2 = me*me;
        double mu2 = mu*mu;
        double me4 = me2*me2;
        double mu4 = mu2*mu2;

    string line;
        ifstream myMomentaFile;
                myMomentaFile.open ("mymomenta.dat");

                myMomentaFile >> p1p1;
                        myMomentaFile >> p2p2;
                        myMomentaFile >> p3p3;
                        myMomentaFile >> p4p4;
                        myMomentaFile >> p5p5;

                        myMomentaFile >> p1p2;
                        myMomentaFile >> p1p3;
                        myMomentaFile >> p1p4;
                        myMomentaFile >> p1p5;
                        
                        myMomentaFile >> p2p3;  
                        myMomentaFile >> p2p4;                                  
                        myMomentaFile >> p2p5;

     myMomentaFile >> p3p4;
                        myMomentaFile >> p3p5;                                                                  
                        
                        myMomentaFile >> p4p5;  
         
                m1s = mu2;
                m2s = mf;
                m3s = me2;
                m4s = me2;
                m5s = mf;

                p1s = p4p4;
                p2s = p1p1;
                p3s = p5p5;
                p4s = p2p2;
                p5s = p3p3;

       s12 = p4p4+p1p1-2*p1p4;
                s23 = p1p1+p5p5-2*p1p5;
                s34 = p5p5+p2p2-2*p2p5;
                s45 = p2p2+p3p3-2*p2p3;
                s15 = p4p4+p3p3+2*p3p4;

		cout << "SET1: kinematical points as generated by MC generator in Phokhara" << endl <<endl;

		/*
p1s = p2s = (double) 0;
p3s = p5s = (double)49/256;
p4s = (double)9/100;
s12 = (double)4;
s23 = (double)-1/5;
s34 =(double) 1/5;
s45 =(double) 3/10;
s15 =(double) -1/2;
m1s = m2s = m3s = (double)49/256;
m4s = m5s = (double)81/1600;
		*/
 integralsMem intsMem_LT, intsMem_OL; 

 
// using LT
 
 ltini();
setlambda(0); 

initIntegralsMem(&intsMem_LT,&B0,&C0,&D0,m1s,m2s,m3s,m4s,m5s,p1s,p2s,p3s,p4s,p5s,s12,s23,s34,s45,s15);

    
I4(&intsMem_LT);
I3(&intsMem_LT);
I2(&intsMem_LT);
  


//using OL

initIntegralsMem(&intsMem_OL,&B0_OL,&C0_OL,&D0_OL,m1s,m2s,m3s,m4s,m5s,p1s,p2s,p3s,p4s,p5s,s12,s23,s34,s45,s15); 

I4(&intsMem_OL);
I3(&intsMem_OL);
I2(&intsMem_OL);
  
cout << "initial values: \n"
<< "p1s = " <<p1s <<endl
<< "p2s = " << p2s<<endl
<< "p3s = " <<p3s <<endl
<< "p4s = " << p4s<<endl
<< "p5s = " << p5s<<endl
<< "s12 = " << s12<<endl
<< "s23 = " <<s23 <<endl
<< "s34 = " << s34<<endl
<< "s45 = " << s45<<endl
<< "s15 = " << s15<<endl
<< "m1s = " << m1s<<endl
<< "m2s = " << m2s<<endl
<< "m3s = " << m3s<<endl
<< "m4s = " << m4s<<endl
<< "m5s = " << m5s<<endl;


int n=25;

cout << "\n\nD0 test \n\n";
cout <<setw(3)<< "#"<<setw(n)<< "LT " <<setw(n)<< "OL "<< setw(n)<< " equals(OL,LT) " << endl;
for(int i=0;i<5;i++)
  cout <<setw(3)<< "["<<i<<"]"<<
  setw(n)<<intsMem_LT.D0_vals[i]<<setw(n)<<intsMem_OL.D0_vals[i]
		  <<setw(n)<<((equals(real(intsMem_LT.D0_vals[i]),real(intsMem_OL.D0_vals[i]))&&equals(imag(intsMem_LT.D0_vals[i]),imag(intsMem_OL.D0_vals[i])))?"ok":"warning")<<endl;

cout << "\n\nC0 test \n\n";
cout <<setw(6)<< "#"<<setw(n)<< "default " <<setw(n)<< "OL "<<setw(n)<< " equals(OL,LT) "<< endl;
for(int i=0;i<5;i++)for(int i2=0;i2<5;i2++)
  cout <<setw(6)<< "["<<i<<"]"<< "["<<i2<<"]"<<
  setw(n)<<intsMem_LT.C0_vals[i][i2]<<setw(n)<<intsMem_OL.C0_vals[i][i2]
  <<setw(n)<<((equals(real(intsMem_LT.C0_vals[i][i2]),real(intsMem_OL.C0_vals[i][i2]))&&equals(imag(intsMem_LT.C0_vals[i][i2]),imag(intsMem_OL.C0_vals[i][i2])))?"ok":"warning")<<
  endl;

 cout << "\n\nB0 test \n\n";
cout <<setw(10)<< "#"<<setw(n)<< "default " <<setw(n)<< "OL "<<setw(n)<< " equals(OL,LT) "<< endl;
for(int i=0;i<5;i++)for(int i2=0;i2<5;i2++)for(int i3=0;i3<5;i3++)
  cout <<setw(10)<< "["<<i<<"]"<< "["<<i2<<"]"<< "["<<i3<<"]"<<setw(n)<<
  intsMem_LT.B0_vals[i][i2][i3]<<
  setw(n)<<intsMem_OL.B0_vals[i][i2][i3]
   <<setw(n)<<((equals(real(intsMem_LT.B0_vals[i][i2][i3]),real(intsMem_OL.B0_vals[i][i2][i3]))&&equals(imag(intsMem_LT.B0_vals[i][i2][i3]),imag(intsMem_OL.B0_vals[i][i2][i3])))?"ok":"warning")<<
 
    endl<<endl;

 cout << "SET2: SOME ARBITRARY KINEMATICAL POINTS" << endl 
		<<endl;


		
p1s = p2s = (double) 0;
p3s = p5s = (double)49/256;
p4s = (double)9/100;
s12 = (double)4;
s23 = (double)-1/5;
s34 =(double) 1/5;
s45 =(double) 3/10;
s15 =(double) -1/2;
m1s = m2s = m3s = (double)49/256;
m4s = m5s = (double)81/1600;
		
// integralsMem intsMem_LT, intsMem_OL; 
 
// using LT
 
 ltini();
setlambda(0); 

initIntegralsMem(&intsMem_LT,&B0,&C0,&D0,m1s,m2s,m3s,m4s,m5s,p1s,p2s,p3s,p4s,p5s,s12,s23,s34,s45,s15);

    
I4(&intsMem_LT);
I3(&intsMem_LT);
I2(&intsMem_LT);
  


//using OL

initIntegralsMem(&intsMem_OL,&B0_OL,&C0_OL,&D0_OL,m1s,m2s,m3s,m4s,m5s,p1s,p2s,p3s,p4s,p5s,s12,s23,s34,s45,s15); 

I4(&intsMem_OL);
I3(&intsMem_OL);
I2(&intsMem_OL);
  
cout << "initial values: \n"
<< "p1s = " <<p1s <<endl
<< "p2s = " << p2s<<endl
<< "p3s = " <<p3s <<endl
<< "p4s = " << p4s<<endl
<< "p5s = " << p5s<<endl
<< "s12 = " << s12<<endl
<< "s23 = " <<s23 <<endl
<< "s34 = " << s34<<endl
<< "s45 = " << s45<<endl
<< "s15 = " << s15<<endl
<< "m1s = " << m1s<<endl
<< "m2s = " << m2s<<endl
<< "m3s = " << m3s<<endl
<< "m4s = " << m4s<<endl
<< "m5s = " << m5s<<endl;

cout << "\n\nD0 test \n\n";
cout <<setw(3)<< "#"<<setw(n)<< "LT " <<setw(n)<< "OL "<< setw(n)<< " equals(OL,LT) " << endl;
for(int i=0;i<5;i++)
  cout <<setw(3)<< "["<<i<<"]"<<
  setw(n)<<intsMem_LT.D0_vals[i]<<setw(n)<<intsMem_OL.D0_vals[i]
		  <<setw(n)<<((equals(real(intsMem_LT.D0_vals[i]),real(intsMem_OL.D0_vals[i]))&&equals(imag(intsMem_LT.D0_vals[i]),imag(intsMem_OL.D0_vals[i])))?"ok":"warning")<<endl;

cout << "\n\nC0 test \n\n";
cout <<setw(6)<< "#"<<setw(n)<< "default " <<setw(n)<< "OL "<<setw(n)<< " equals(OL,LT) "<< endl;
for(int i=0;i<5;i++)for(int i2=0;i2<5;i2++)
  cout <<setw(6)<< "["<<i<<"]"<< "["<<i2<<"]"<<
  setw(n)<<intsMem_LT.C0_vals[i][i2]<<setw(n)<<intsMem_OL.C0_vals[i][i2]
  <<setw(n)<<((equals(real(intsMem_LT.C0_vals[i][i2]),real(intsMem_OL.C0_vals[i][i2]))&&equals(imag(intsMem_LT.C0_vals[i][i2]),imag(intsMem_OL.C0_vals[i][i2])))?"ok":"warning")<<
  endl;

 cout << "\n\nB0 test \n\n";
cout <<setw(10)<< "#"<<setw(n)<< "default " <<setw(n)<< "OL "<<setw(n)<< " equals(OL,LT) "<< endl;
for(int i=0;i<5;i++)for(int i2=0;i2<5;i2++)for(int i3=0;i3<5;i3++)
  cout <<setw(10)<< "["<<i<<"]"<< "["<<i2<<"]"<< "["<<i3<<"]"<<setw(n)<<
  intsMem_LT.B0_vals[i][i2][i3]<<
  setw(n)<<intsMem_OL.B0_vals[i][i2][i3]
   <<setw(n)<<((equals(real(intsMem_LT.B0_vals[i][i2][i3]),real(intsMem_OL.B0_vals[i][i2][i3]))&&equals(imag(intsMem_LT.B0_vals[i][i2][i3]),imag(intsMem_OL.B0_vals[i][i2][i3])))?"ok":"warning")<<
 
  endl;

 }
