#ifndef LIBOLEC_H_
#define LIBOLEC_H_
#include <complex>
// #include "../src/initIntegralsMem.h"
// #include "../contracts.h"

#include <complex>
typedef struct {
double ms1;
double ms2;
double ms3;
double ms4;
double ms5;
double ps1;
double ps2;
double ps3;
double ps4;
double ps5;
double s12;
double s23;
double s34;
double s45;
double s15;
}invariants;

typedef struct {
double p1p2;
double p2p3;
double p3p4;
double p4p5;
double p1p5;
double p3p5;
double p1p4;
double p2p5;
double p1p3;
double p2p4;
}quadratics;


//LT setup
#define LAMBDA 1.0
//OL setup
#define RMU 1.0

typedef struct{
  
  invariants inv;
  quadratics q;

std::complex<double> E0_vals;
  int E0_evaluated;
 std::complex<double> D0_vals [5];
  int D0_evaluated;
  
 std::complex<double> C0_vals [5][5];
  int C0_evaluated;    
 std::complex<double> B0_vals [5][5][5];
  int B0_evaluated; 
  double matrix5[6][6];

  //deleteMePlease//
 std::complex<double> C5_vals [5][5][5];
int C5_evaluated;
//stopeDele


 double minor6cache[6][6];
 double minorCayley6cache[6][6][6][6];

//double YY_vals [5][5];

//
int LT_OL_flag; //0 LT (default); 1 OL; -1 custom;

std::complex<double> (*B0_pointer)(double,double,double);
std::complex<double> (*C0_pointer)(double,double,double,double,double,double);
std::complex<double> (*D0_pointer)(
  double,double,double,double,double,
  double,double,double,double,double
		       );
  
}integralsMem;//cache


integralsMem *initIntegralsMem(
  double m1s, double m2s, double m3s, double m4s, double m5s,
  double p1s,double p2s, double p3s,double p4s,double p5s,
  double s12, double s23,double s34,double s45,double s15
	     );
	     
//default init
int initIntegralsMem(integralsMem*,
  double m1s, double m2s, double m3s, double m4s, double m5s,
  double p1s,double p2s, double p3s,double p4s,double p5s,
  double s12, double s23,double s34,double s45,double s15
	     );
	   
// custom init
int initIntegralsMem(
		integralsMem *intsM,
		std::complex<double> (*B0_func_pointer)(double,double,double),
		std::complex<double> (*C0_func_pointer)(double,double,double,double,double,double),
		std::complex<double> (*D0_func_pointer)(  double,double,double,double,double,  double,double,double,double,double),
		    double m1s, double m2s, double m3s, double m4s, double m5s,
		    double p1s,double p2s, double p3s,double p4s,double p5s,
		    double s12, double s23,double s34,double s45,double s15
		    );     
	     
int initIntegralsMem(invariants inv);
void initQuadratics (invariants inv, quadratics* q);
void freeIntegralsMem(integralsMem * intMem);

std::complex<double> CE1(int chord1, integralsMem * intsM);
std::complex<double> CE2(int chord1,int chord2, integralsMem *intsM);
std::complex<double> CE3(int chord1,int chord2, int chord3, integralsMem *intsM);

std::complex<double> CE2g(integralsMem *intsM);
std::complex<double> CE3g(int chord1, integralsMem *intsM);
std::complex<double> E0(integralsMem *intsM);
#endif