/**
 * Auxilary functions
 * 
 * 
 */
#include "initIntegralsMem.h"
#include "mathematicalFunctions.cpp"
#include "matrixAlgebra.h"
#include "I4I3I2.h"
#include <complex>
#include <iostream>
using namespace std;
 
 double qaQ0(int chord1,integralsMem *intMem){
  return (double)-1/2*(intMem->matrix5[1][chord1]-intMem->matrix5[1][1]);
}


 double qaQs(int chord1,  int chord2){
  
  return (double)1/2*(deltaK(chord1,chord2)-deltaK(1,chord2));
}

 double qaQs0(int chord1, int chord2, integralsMem * intsM){

double mat = intsM->minor6cache[chord2][chord2];

 double ret = (-1./2*(mat*(intsM->matrix5[1][chord1]-intsM->matrix5[1][1])
+intsM->minor6cache[chord2][0]*(deltaK(chord1,chord2)-
deltaK(1, chord2))))/mat;

// cout << "ret=" << chord1 << "  " << chord2 << "  " <<ret << endl;

  
 return ret;

}

 double qaQ0s(int chord1, int chord2, integralsMem *intsM){
 
 double mat = intsM->minor6cache[0][0];

 double ret = 1/mat*(1./2*(intsM->minor6cache[chord2][0]*(
intsM->matrix5[1][chord1]-intsM->matrix5[1][1])+mat*(deltaK(chord1,chord2)-deltaK(1, chord2))));
  
 //  double ret = YY(chord1, 1,i,q)-YY(1, 1,i,q);

 // cout << "mat=" << mat << endl;
 return ret;

}

 double qaQst(int chord1, int chord2, int chord3, integralsMem *intsM){

  double mat = intsM->minor6cache[chord2][chord2];
  double ret = 1/mat*(1./2*(1-deltaK(chord2,chord3))*(
mat*(deltaK(chord1,chord3)-deltaK(1,chord3))-
intsM->minor6cache[chord2][chord3]*
(deltaK(chord1,chord2) - deltaK(1, chord2))));
  return ret;
}

std::complex<double> R(int chord1, integralsMem * intsM){

if(intsM->D0_evaluated==0){
 I4(intsM );
 intsM->D0_evaluated=1;
}
if(intsM->C0_evaluated==0){
 I3(intsM );
 intsM->C0_evaluated=1;
}
  
 double mat =intsM->minor6cache[chord1][chord1]  ;
 std::complex<double>  sum=0.0;
if(chord1<6) //if(t!=chord1&&chord1<6) (optimalization)
 for(int t=1;t<6;t++)
{ 
//    if(t!=chord1&&chord1<6)
if(t!=chord1)
     {
           sum += intsM->minor6cache[chord1][t]*intsM->C0_vals[chord1-1][t-1];
       }
}
 std::complex<double> ret = (intsM->minor6cache[chord1][0]*intsM->D0_vals[chord1-1]);
 ret -=sum;

 return ret/mat;

}

std::complex<double> R(int chord1, int chord2, integralsMem * intsM){
// return 0;
if(intsM->D0_evaluated==0){
 I4(intsM );
 intsM->D0_evaluated=1;
}
if(intsM->C0_evaluated==0){
 I3(intsM );
 intsM->C0_evaluated=1;
}
if(intsM->B0_evaluated==0){
 I2(intsM );
 intsM->B0_evaluated=1;
}
  
 double mat =intsM-> minorCayley6cache[chord1][chord2][chord1][chord2];
 std::complex<double>  sum=0.0;

 for(int u=1;u<6;u++)
{ 
   if(u!=chord1&&u!=chord2&&chord1!=chord2&&chord1<6&&chord2<6)
     {
           sum += intsM->minorCayley6cache[chord1][chord2][u][chord2]*
           intsM->B0_vals[chord1-1][chord2-1][u-1];
       }
}
 std::complex<double> ret = (intsM->minorCayley6cache[chord1][chord2][0][chord2]*
 intsM->C0_vals[chord1-1][chord2-1]);
                       ret -=sum;

 return ret/mat;

}
double YS(int i,integralsMem *intsM){return ( intsM->matrix5[1][i]-
intsM->matrix5[1][1]);}

std::complex<double> bracket(int chord1, integralsMem * intsM){
// return 10;
if(intsM->D0_evaluated==0){
 I4(intsM );
 intsM->D0_evaluated=1;
}
if(intsM->C0_evaluated==0){
 I3(intsM );
 intsM->C0_evaluated=1;
}
if(intsM->B0_evaluated==0){
 I2(intsM );
 intsM->B0_evaluated=1;
}
  
 double mat = intsM->minor6cache[chord1][chord1] ;
 std::complex<double>  sum=0.0;

 for(int t=1;t<6;t++)
{ 
   if(t!=chord1&&chord1<6)
     {
           sum += intsM->minor6cache[0][t]*
           intsM->C0_vals[chord1-1][t-1]-
           intsM->minor6cache[chord1][t]*R(chord1,t,intsM);
       }
}
 std::complex<double> ret = (-intsM->minor6cache[0][0]*
 intsM->D0_vals[chord1-1]+2*intsM->minor6cache[0][chord1]*R(chord1,intsM));
                       ret = ret+sum;

 return ret/mat;

}


std::complex<double> E0(integralsMem *intsM){
  
  std::complex<double> E=0;  
  
  if(intsM->D0_evaluated==0){
 I4(intsM );
 intsM->D0_evaluated=1;
}
  
  for(int s=1;s<=5;s++){
E+=intsM->minor6cache[0][s]*intsM->D0_vals[s-1];
  }
  
  return E/intsM->minor6cache[0][0];
}


