/**
 * Functions implementing contractions
 * 
 * 
 * 
 */
#include "I4I3I2.h"
#include "auxQS.h"

#include "initIntegralsMem.h"

#include "mathematicalFunctions.h"
#include <complex>
#include <iostream>
#include "C5.h"
using namespace std;

complex<double> CE1(int chord1, integralsMem * intsM){

    if(!intsM->D0_evaluated){
       I4(intsM);intsM->D0_evaluated=1;
  }
    chord1++;
  if(chord1==6)chord1=1;
  complex<double> ret=0.0;
    complex<double> E0_val=E0(intsM);
  for(int s=1;s<=5;s++)
//     ret+=qaQs(chord1,s,i,q)*I4(s,i,q);
     ret+=qaQs(chord1,s)*(intsM->D0_vals[s-1]);
  ret-=E0_val*qaQ0(chord1,intsM);
  return ret;
}
complex<double> CE2(int chord1,int chord2, integralsMem *intsM){
  
    if(!intsM->D0_evaluated){
       I4(intsM);intsM->D0_evaluated=1;}
    if(!intsM->C0_evaluated){
       I3(intsM);intsM->C0_evaluated=1;}

  complex<double> E1_val=-CE1(chord1,intsM);

  chord1++; chord2++;
  if(chord1==6)chord1=1;
  if(chord2==6)chord2=1;

  complex<double>  ret=0.0;
  complex<double>  sumt=0.0;

  for(int s=1;s<=5;s++)
    {
	  sumt=0;
      for(int t=1;t<=5;t++)
	{
	   	  if(s!=t)
	    {sumt += qaQst(chord1,s,t,intsM)*(intsM->C0_vals[s-1][t-1]);}
	};
      ret=ret+(sumt-
	       qaQs0(chord1,s,intsM)*(intsM->D0_vals[s-1]))*qaQs(chord2,s);
    }
  ret=ret+E1_val*qaQ0(chord2,intsM);
      return ret;
    
}  


    complex<double> CE3(int chord1,int chord2, int chord3, integralsMem *intsM){
  
 if(!intsM->D0_evaluated){
       I4(intsM);intsM->D0_evaluated=1;}
    if(!intsM->C0_evaluated){
       I3(intsM);intsM->C0_evaluated=1;
  }
    if(!intsM->B0_evaluated){
       I2(intsM);intsM->B0_evaluated=1;
  }
  
  /*
    if(!intsM->C5_evaluated){
       C5(intsM);intsM->C5_evaluated=1;
  }*/


  complex<double> E2_val=-CE2(chord1,chord2,intsM);

  chord1++; chord2++; chord3++;
  if(chord1==6)chord1=1;
  	if(chord2==6)chord2=1;
	 if(chord3==6)chord3=1;


  complex<double> ret=0.0;
 /* 
  if(chord1!=1&&chord2!=1&&chord3!=1){ret +=E2_val*qaQ0(chord3,intsM)-
      intsM->C5_vals[chord1-1][chord2-1][chord3-1];}*/
 
  if(chord1!=1&&chord2!=1&&chord3!=1){ret +=E2_val*qaQ0(chord3,intsM)-
      C5(chord1-1,chord2-1,chord3-1,intsM);}

return ret;
    }

    complex<double> CE2g(integralsMem *intsM){
  
 if(!intsM->D0_evaluated){
       I4(intsM);intsM->D0_evaluated=1;}
 
 complex<double> ret=(intsM->D0_vals[0])+/*YY(1,1,intsM)*/intsM->matrix5[1][1]*E0(intsM)/2.;

return ret;
    }


    complex<double> CE3g(int chord1, integralsMem *intsM){
  
 if(!intsM->D0_evaluated){
       I4(intsM);intsM->D0_evaluated=1;}
    if(!intsM->C0_evaluated){
       I3(intsM);intsM->C0_evaluated=1;
  }

  chord1++; if(chord1==6)chord1=1;
  
complex<double> ret=0.0;

 for(int s=1;s<6;s++)
   {
     ret +=intsM->matrix5[1][1]/2*(intsM->D0_vals[s-1])*qaQ0s(chord1,s,intsM)+
       qaQst(chord1,1,s,intsM)*(intsM->C0_vals[0][s-1]);
   }

 ret-=(intsM->D0_vals[0])*qaQs0(chord1,1,intsM);

return ret;
    }
