#include "kinematics.h"
#include "initIntegralsMem.h"
// #include "mcm.h"
#include <stdlib.h>
#include <iostream>
#include "matrixAlgebra.h"
using namespace std;

//the default init
int initIntegralsMem(  integralsMem * intMem,
  double m1s, double m2s, double m3s, double m4s, double m5s,
  double p1s,double p2s, double p3s,double p4s,double p5s,
  double s12, double s23,double s34,double s45,double s15
	     ){

  
  invariants inv={m1s,m2s,m3s,m4s,m5s,p1s,p2s,p3s,p4s,p5s,s12,s23,s34,s45,s15};
  intMem->inv=inv;
  initQuadratics(inv, &(intMem->q));

intMem->matrix5[0][0]= 0;
intMem->matrix5[0][1]= 1;
intMem->matrix5[0][2]= 1;
intMem->matrix5[0][3]= 1;
intMem->matrix5[0][4]= 1;
intMem->matrix5[0][5]= 1;
intMem->matrix5[1][0]= 1;
intMem->matrix5[2][0]= 1;
intMem->matrix5[3][0]= 1;
intMem->matrix5[4][0]=1;
intMem->matrix5[5][0]= 1;
intMem->matrix5[1][1]= intMem->inv.ms1+intMem->inv.ms1;
intMem->matrix5[1][2]= intMem->matrix5[2][1]=intMem->inv.ms1+intMem->inv.ms2-intMem->inv.ps1;
intMem->matrix5[1][3]=intMem->matrix5[3][1]= intMem->inv.ms1+intMem->inv.ms3-(intMem->inv.ps1+intMem->inv.ps2+2*intMem->q.p1p2);
intMem->matrix5[1][4]=intMem->matrix5[4][1]=intMem->inv.ms1+intMem->inv.ms4- (intMem->inv.ps1+intMem->inv.ps2+intMem->inv.ps3+2*intMem->q.p1p2+2*intMem->q.p2p3+2*intMem->q.p1p3);
intMem->matrix5[1][5]=intMem->matrix5[5][1]= intMem->inv.ms1+intMem->inv.ms5-(intMem->inv.ps1+intMem->inv.ps2+intMem->inv.ps3+intMem->inv.ps4+2*intMem->q.p1p2+2*intMem->q.p2p3+2*intMem->q.p1p3+2*intMem->q.p1p4+2*intMem->q.p2p4+2*intMem->q.p3p4);
intMem->matrix5[2][2]= 2*intMem->inv.ms2 ;
intMem->matrix5[2][3]=intMem->matrix5[3][2]= intMem->inv.ms2+intMem->inv.ms3-intMem->inv.ps2;
intMem->matrix5[2][4]=intMem->matrix5[4][2]= intMem->inv.ms2+intMem->inv.ms4-(intMem->inv.ps2+intMem->inv.ps3+2*intMem->q.p2p3);
intMem->matrix5[2][5]=intMem->matrix5[5][2]= intMem->inv.ms2+intMem->inv.ms5-intMem->inv.ps2-intMem->inv.ps3-intMem->inv.ps4-2*intMem->q.p2p3-2*intMem->q.p2p4-2*intMem->q.p3p4;
intMem->matrix5[3][3]=2*intMem->inv.ms3;
intMem->matrix5[3][4]=intMem->matrix5[4][3]= intMem->inv.ms4+intMem->inv.ms3-intMem->inv.ps3;
intMem->matrix5[3][5]=intMem->matrix5[5][3]=intMem->inv.ms3+intMem->inv.ms5- intMem->inv.ps3-intMem->inv.ps4-2*intMem->q.p3p4;
intMem->matrix5[4][4]=2*intMem->inv.ms4  ;
intMem->matrix5[4][5]= intMem->matrix5[5][4]=intMem->inv.ms4+intMem->inv.ms5-intMem->inv.ps4;
intMem->matrix5[5][5]= intMem->inv.ms5*2;



  int c1,c2,i,j;double x;
  for(i=0;i<6;i++){
    for(j=0;j<6&&i>=j;j++){
      intMem->minor6cache[i][j]=minorCay6(intMem->matrix5,i,j);
      if(j!=i)
      intMem->minor6cache[j][i]=intMem->minor6cache[i][j];
    }}
    

  for(i=0;i<6;i++){
    for(j=0;j<6&&i>=j;j++){
 
       for(c1=0;c1<6;c1++)
	for(c2=0;c2<6&&c1>=c2;c2++){

	  intMem->minorCayley6cache[i][j][c1][c2]=minorCayley6(intMem->matrix5,i,j,c1,c2) ;
	if(j!=i)
	 intMem->minorCayley6cache[j][i][c1][c2]= - intMem->minorCayley6cache[i][j][c1][c2];
	if(c2!=c1)
	  intMem->minorCayley6cache[i][j][c2][c1]= - intMem->minorCayley6cache[i][j][c1][c2];
	if(c2!=c1&&j!=i)
	intMem->minorCayley6cache[j][i][c2][c1]=  intMem->minorCayley6cache[i][j][c1][c2];
	
	}
	
    }}


// intMem->LT_OL_flag=0;
   intMem->B0_evaluated=0;
  intMem->C0_evaluated=0;
  intMem->D0_evaluated=0;
  intMem->C5_evaluated=0;
  //  


  return 0;
}

 
inline void initQuadratics (invariants inv, quadratics* q){
  q->p1p2=(inv.s12-inv.ps1-inv.ps2)/2;
	  q->p2p3=(inv.s23-inv.ps2-inv.ps3)/2;
	  q->p3p4=(inv.s34-inv.ps3-inv.ps4)/2;
	  q->p4p5=(inv.s45-inv.ps4-inv.ps5)/2;
	  q->p1p5=(inv.s15-inv.ps1-inv.ps5)/2;
	  q->p3p5=(inv.s12-inv.s34-inv.s45+inv.ps4)/2;
	  q->p1p4=(inv.s23-inv.s15-inv.s45+inv.ps5)/2;
          q->p2p5=(inv.s34-inv.s12-inv.s15+inv.ps1)/2;
          q->p1p3=(inv.s45-inv.s12-inv.s23+inv.ps2)/2;
          q->p2p4=(inv.s15-inv.s23-inv.s34+inv.ps3)/2;
}


int initIntegralsMem(integralsMem *intsM,
		std::complex<double> (*B0_func_pointer)(double,double,double),
		std::complex<double> (*C0_func_pointer)(double,double,double,double,double,double),
		std::complex<double> (*D0_func_pointer)(  double,double,double,double,double,  double,double,double,double,double),
		    double m1s, double m2s, double m3s, double m4s, double m5s,
		    double p1s,double p2s, double p3s,double p4s,double p5s,
		    double s12, double s23,double s34,double s45,double s15
		    ){

  initIntegralsMem(intsM,m1s,m2s,m3s,m4s,m5s,p1s,p2s,p3s,p4s,p5s,s12,s23,s34,s45,s15); 
// intsM->LT_OL_flag=-1;
intsM->B0_pointer=B0_func_pointer;
intsM->C0_pointer=C0_func_pointer;
intsM->D0_pointer=D0_func_pointer;
 return 0;

}

