#ifndef INITINTMEM_H_
#define INITINTMEM_H_

#include <complex>
#include "kinematics.h"

//LT setup
#define LAMBDA 0
//OL setup
#define RMU 1.0

typedef struct{
  
  invariants inv;
  quadratics q;

std::complex<double> E0_vals;
  int E0_evaluated;
 std::complex<double> D0_vals [5];
  int D0_evaluated;
  
 std::complex<double> C0_vals [5][5];
  int C0_evaluated;    
 std::complex<double> B0_vals [5][5][5];
  int B0_evaluated; 
  double matrix5[6][6];

  //deleteMePlease//
 std::complex<double> C5_vals [5][5][5];
int C5_evaluated;
//stopeDele


 double minor6cache[6][6];
 double minorCayley6cache[6][6][6][6];

//double YY_vals [5][5];

//not used anymore
// int LT_OL_flag; //0 LT (default); 1 OL; -1 custom;

std::complex<double> (*B0_pointer)(double,double,double);
std::complex<double> (*C0_pointer)(double,double,double,double,double,double);
std::complex<double> (*D0_pointer)(
  double,double,double,double,double,
  double,double,double,double,double
		       );
  
}integralsMem;//cache


//default init
int initIntegralsMem(integralsMem*,
  double m1s, double m2s, double m3s, double m4s, double m5s,
  double p1s,double p2s, double p3s,double p4s,double p5s,
  double s12, double s23,double s34,double s45,double s15
	     );
	   
// custom init
int initIntegralsMem(
		integralsMem *intsM,
		std::complex<double> (*B0_func_pointer)(double,double,double),
		std::complex<double> (*C0_func_pointer)(double,double,double,double,double,double),
		std::complex<double> (*D0_func_pointer)(  double,double,double,double,double,  double,double,double,double,double),
		    double m1s, double m2s, double m3s, double m4s, double m5s,
		    double p1s,double p2s, double p3s,double p4s,double p5s,
		    double s12, double s23,double s34,double s45,double s15
		    );     
	     
int initIntegralsMem(invariants inv);
void initQuadratics (invariants inv, quadratics* q);
void freeIntegralsMem(integralsMem * intMem);
#endif